/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.LabelMapComponent;
import com.oracle.cie.gdr.external.Patch;
import com.oracle.cie.rest.Repository;
import java.util.LinkedHashMap;
import java.util.Map;

public class InventoryCache {
    private Map<MetaDataHome, Home> _homeCache = new LinkedHashMap<MetaDataHome, Home>();
    private Map<InventoryArtifactKey, Component> _componentCache = new LinkedHashMap<InventoryArtifactKey, Component>();
    private Map<InventoryArtifactKey, Distribution> _distributionCache = new LinkedHashMap<InventoryArtifactKey, Distribution>();
    private Map<InventoryArtifactKey, FeatureSet> _featureSetCache = new LinkedHashMap<InventoryArtifactKey, FeatureSet>();
    private Map<InventoryArtifactKey, Patch> _patchCache = new LinkedHashMap<InventoryArtifactKey, Patch>();
    private Map<InventoryArtifactKey, LabelMapComponent> _labelMapComponentCache = new LinkedHashMap<InventoryArtifactKey, LabelMapComponent>();
    private static boolean _enableCache = true;
    private static final InventoryCache _instance = new InventoryCache();

    private InventoryCache() {
    }

    public static InventoryCache getInstance() {
        return _instance;
    }

    public static void enableCache() {
        _enableCache = true;
    }

    public static void disableCache() {
        _enableCache = false;
    }

    public void clearCache() {
        this._homeCache.clear();
        this._componentCache.clear();
        this._distributionCache.clear();
        this._featureSetCache.clear();
        this._patchCache.clear();
        this._labelMapComponentCache.clear();
    }

    public void putHome(MetaDataHome metaDataHome, Home home) throws InventoryException {
        if (_enableCache) {
            if (null == metaDataHome || null == home) {
                throw new InventoryException("The meta-data home and home are required.");
            }
            this._homeCache.put(metaDataHome, home);
        }
    }

    public Home getHome(MetaDataHome metaDataHome) throws InventoryException {
        if (null == metaDataHome) {
            throw new InventoryException("The meta-data home is required.");
        }
        return this._homeCache.get(metaDataHome);
    }

    public void putComponent(MetaDataHome metaDataHome, Component component) throws InventoryException {
        if (_enableCache) {
            if (null == metaDataHome || null == component) {
                throw new InventoryException("The meta-data home and component are required.");
            }
            this._componentCache.put(new InventoryArtifactKey(metaDataHome, component.getName(), component.getVersion()), component);
        }
    }

    public void putComponent(Repository repository, Component component) throws InventoryException {
        if (_enableCache) {
            if (null == repository || null == component) {
                throw new InventoryException("The repository and component are required.");
            }
            this._componentCache.put(new InventoryArtifactKey(repository, component.getName(), component.getVersion()), component);
        }
    }

    public Component getComponent(MetaDataHome metaDataHome, String name, String version) throws InventoryException {
        if (null == metaDataHome || null == name || null == version) {
            throw new InventoryException("The meta-data home, name and version for the component are required.");
        }
        return this._componentCache.get(new InventoryArtifactKey(metaDataHome, name, version));
    }

    public Component getComponent(Repository repository, String name, String version) throws InventoryException {
        if (null == repository || null == name || null == version) {
            throw new InventoryException("The repository, name and version for the component are required.");
        }
        return this._componentCache.get(new InventoryArtifactKey(repository, name, version));
    }

    public void putLabelMapComponent(MetaDataHome metaDataHome, LabelMapComponent labelMapComponent) throws InventoryException {
        if (_enableCache) {
            if (null == metaDataHome || null == labelMapComponent) {
                throw new InventoryException("The meta-data home and label map are required.");
            }
            this._labelMapComponentCache.put(new InventoryArtifactKey(metaDataHome, labelMapComponent.getName(), labelMapComponent.getVersion()), labelMapComponent);
        }
    }

    public LabelMapComponent getLabelMapComponent(MetaDataHome metaDataHome, String name, String version) throws InventoryException {
        if (null == metaDataHome || null == name || null == version) {
            throw new InventoryException("The metaDataHome, name and version for the component are required.");
        }
        return this._labelMapComponentCache.get(new InventoryArtifactKey(metaDataHome, name, version));
    }

    public void putDistribution(MetaDataHome metaDataHome, Distribution distribution) throws InventoryException {
        if (_enableCache) {
            if (null == metaDataHome || null == distribution) {
                throw new InventoryException("The meta-data home and distribution are required.");
            }
            this._distributionCache.put(new InventoryArtifactKey(metaDataHome, distribution.getName(), distribution.getVersion()), distribution);
        }
    }

    public void putDistribution(Repository repository, Distribution distribution) throws InventoryException {
        if (_enableCache) {
            if (null == repository || null == distribution) {
                throw new InventoryException("The repository and distribution are required.");
            }
            this._distributionCache.put(new InventoryArtifactKey(repository, distribution.getName(), distribution.getVersion()), distribution);
        }
    }

    public Distribution getDistribution(MetaDataHome metaDataHome, String name, String version) throws InventoryException {
        if (null == metaDataHome || null == name || null == version) {
            throw new InventoryException("The meta-data home, name and version for the component are required.");
        }
        return this._distributionCache.get(new InventoryArtifactKey(metaDataHome, name, version));
    }

    public Distribution getDistribution(Repository repository, String name, String version) throws InventoryException {
        if (null == repository || null == name || null == version) {
            throw new InventoryException("The repository, name and version for the component are required.");
        }
        return this._distributionCache.get(new InventoryArtifactKey(repository, name, version));
    }

    public void putFeatureSet(MetaDataHome metaDataHome, FeatureSet featureSet) throws InventoryException {
        if (_enableCache) {
            if (null == metaDataHome || null == featureSet) {
                throw new InventoryException("The meta-data home and feature Set are required.");
            }
            this._featureSetCache.put(new InventoryArtifactKey(metaDataHome, featureSet.getName(), featureSet.getVersion()), featureSet);
        }
    }

    public void putFeatureSet(Repository repository, FeatureSet featureSet) throws InventoryException {
        if (_enableCache) {
            if (null == repository || null == featureSet) {
                throw new InventoryException("The repository and feature Set are required.");
            }
            this._featureSetCache.put(new InventoryArtifactKey(repository, featureSet.getName(), featureSet.getVersion()), featureSet);
        }
    }

    public FeatureSet getFeatureSet(MetaDataHome metaDataHome, String name, String version) throws InventoryException {
        if (null == metaDataHome || null == name || null == version) {
            throw new InventoryException("The meta-data home, name and version for the component are required.");
        }
        return this._featureSetCache.get(new InventoryArtifactKey(metaDataHome, name, version));
    }

    public FeatureSet getFeatureSet(Repository repository, String name, String version) throws InventoryException {
        if (null == repository || null == name || null == version) {
            throw new InventoryException("The repository, name and version for the component are required.");
        }
        return this._featureSetCache.get(new InventoryArtifactKey(repository, name, version));
    }

    public void putPatch(MetaDataHome metaDataHome, Patch patch) throws InventoryException {
        if (_enableCache) {
            if (null == metaDataHome || null == patch) {
                throw new InventoryException("The meta-data home and patch are required.");
            }
            this._patchCache.put(new InventoryArtifactKey(metaDataHome, patch.getPatchId(), null), patch);
        }
    }

    public Patch getPatch(MetaDataHome metaDataHome, String patchId) throws InventoryException {
        if (null == metaDataHome || null == patchId) {
            throw new InventoryException("The meta-data home, name and version for the patch are required.");
        }
        return this._patchCache.get(new InventoryArtifactKey(metaDataHome, patchId, null));
    }

    private static class InventoryArtifactKey {
        MetaDataHome _metaDataHome;
        Repository _repository;
        String _artifactName;
        String _artifactVersion;

        private InventoryArtifactKey(MetaDataHome metaDataHome, String artifactName, String artifactVersion) {
            this._metaDataHome = metaDataHome;
            this._artifactName = artifactName;
            this._artifactVersion = artifactVersion;
        }

        private InventoryArtifactKey(Repository repository, String artifactName, String artifactVersion) {
            this._repository = repository;
            this._artifactName = artifactName;
            this._artifactVersion = artifactVersion;
        }

        public boolean equals(Object o) {
            if (!(o instanceof InventoryArtifactKey)) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InventoryArtifactKey that = (InventoryArtifactKey)o;
            return !((this._artifactName == null ? that._artifactName != null : !this._artifactName.equals(that._artifactName)) || (this._artifactVersion == null ? that._artifactVersion != null : !this._artifactVersion.equals(that._artifactVersion)) || (this._metaDataHome != null ? !this._metaDataHome.equals(that._metaDataHome) : that._metaDataHome != null) && (this._repository == null ? that._repository != null : !this._repository.equals(that._repository)));
        }

        public int hashCode() {
            int result = this._metaDataHome != null ? this._metaDataHome.hashCode() : 0;
            result = 31 * result + (this._artifactName != null ? this._artifactName.hashCode() : 0);
            result = 31 * result + (this._artifactVersion != null ? this._artifactVersion.hashCode() : 0);
            return result;
        }
    }
}

