/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.external.GdrInventory;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.LabelMap;
import com.oracle.cie.gdr.external.impl.BaseInventoryImpl;
import com.oracle.cie.gdr.external.impl.LabelMapImpl;
import com.oracle.cie.gdr.helpers.LabelMapHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.File;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GdrInventoryImpl
extends BaseInventoryImpl
implements GdrInventory {
    private LabelMap _labelMap;
    private static final Logger _log = Logger.getLogger(GdrInventoryImpl.class.getName());

    public GdrInventoryImpl(File metaDataHome) throws InventoryException {
        this(NioHelper.getInstance().getPath(metaDataHome));
    }

    public GdrInventoryImpl(Path metaDataHome) throws InventoryException {
        super(metaDataHome);
        this._mode = Mode.PACKAGE_SHIPHOME;
        try {
            this._labelMap = new LabelMapImpl(LabelMapHelper.getInstance().getLabelMap(this._metaDataHome.getGdrMetaDataHome()), this._metaDataHome);
        }
        catch (Exception exception) {
            _log.log(Level.SEVERE, "A problem occurred when loading the gdr inventory.", exception);
            throw new InventoryException(exception);
        }
    }

    @Override
    protected MetaDataHome loadMetaDataHome(File metaDataHome) throws InventoryException {
        return this.loadMetaDataHome(NioHelper.getInstance().getPath(metaDataHome));
    }

    @Override
    protected MetaDataHome loadMetaDataHome(Path metaDataHome) throws InventoryException {
        try {
            return new MetaDataHome(metaDataHome, false);
        }
        catch (Exception exception) {
            throw new InventoryException(exception);
        }
    }

    @Override
    public LabelMap getLabelMap() {
        return this._labelMap;
    }
}

