/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.external.InstallType;
import com.oracle.cie.gdr.external.InstallTypeSelector;
import com.oracle.cie.gdr.session.DistributionSessionImpl;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class DefaultInstallTypeSelector
implements InstallTypeSelector {
    private static final Logger _log = Logger.getLogger(DistributionSessionImpl.class.getName());
    private static final String _db_featureSet = "glcm_opatchauto_db";
    private static final String _em_featureSet = "glcm_opatchauto_core";
    private static final String _opatch_featureSet = "opatch";

    @Override
    public InstallType getCustomInstallType(Set<InstallType> installTypes, File oraHome) throws GdrException {
        try {
            if (oraHome != null) {
                String installTypeSelector = "";
                Home home = Home.getHome(oraHome);
                for (DistributionTarget dist : home.getInstalledDistributions()) {
                    if (!BlackListItem.matches(dist.getDistributionName(), dist.getDistributionVersion())) continue;
                    String distributionName = StringUtil.isNullOrEmpty((String)dist.getDistribution().getExternalName()) ? dist.getDistributionName() : dist.getDistribution().getExternalName();
                    String distributionVersion = StringUtil.isNullOrEmpty((String)dist.getDistribution().getExternalVersion()) ? dist.getDistributionVersion() : dist.getDistribution().getExternalVersion();
                    GdrException e = new GdrException("This product cannot be installed on top of distribution " + distributionName + " " + distributionVersion);
                    _log.throwing(DefaultInstallTypeSelector.class.getName(), "getCustomInstallType", e);
                    throw e;
                }
                for (FeatureSet feature : home.getInstalledFeatures()) {
                    if (feature.getName().equals(_db_featureSet)) {
                        _log.info("FeatureSet " + feature + " found by Install Type Selector");
                        installTypeSelector = "db";
                        break;
                    }
                    if (feature.getName().equals(_em_featureSet)) {
                        _log.info("FeatureSet " + feature + " found by Install Type Selector");
                        installTypeSelector = "core";
                        continue;
                    }
                    if (!feature.getName().equals(_opatch_featureSet) || !StringUtil.isNullOrEmpty((String)installTypeSelector)) continue;
                    _log.info("FeatureSet " + feature + " found by Install Type Selector");
                    installTypeSelector = "only";
                }
                if (!StringUtil.isNullOrEmpty((String)installTypeSelector)) {
                    for (InstallType type : installTypes) {
                        if (!type.getName().toLowerCase().contains(installTypeSelector.toLowerCase())) continue;
                        _log.info("Install Type " + type.getName() + " selected to be installed");
                        return type;
                    }
                }
                _log.warning("No default install type found");
            }
            return null;
        }
        catch (Exception e) {
            throw new GdrException((Throwable)e);
        }
    }

    @Override
    public Set<InstallType> getCompatibleInstallTypes(Set<InstallType> installTypes, File oraHome) throws GdrException {
        InstallType customInstallType = this.getCustomInstallType(installTypes, oraHome);
        HashSet<InstallType> availableInstallTypes = new HashSet<InstallType>();
        if (customInstallType != null) {
            availableInstallTypes.add(customInstallType);
        }
        return availableInstallTypes;
    }

    private static enum BlackListItem {
        oms_13_2_0_0_0("Oracle_Management_Server", "13.2.0.0.0"),
        cca_13_2_0_0_0("CloudControl_Agent", "13.2.0.0.0"),
        oms_13_3_0_0_0("Oracle_Management_Server", "13.3.0.0.0"),
        cca_13_3_0_0_0("CloudControl_Agent", "13.3.0.0.0");

        private String distributionName;
        private String distributionVersion;

        private BlackListItem(String name, String version) {
            this.distributionName = name;
            this.distributionVersion = version;
        }

        static boolean matches(String name, String version) {
            for (BlackListItem item : BlackListItem.values()) {
                if (!item.distributionName.equals(name) || !item.distributionVersion.equals(version)) continue;
                return true;
            }
            return false;
        }
    }
}

