/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.dependency.mgmt.impl.ArtifactImpl;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.external.CoordinateGenerator;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.maven.PomException;
import com.oracle.cie.gdr.maven.PomProcessor;
import com.oracle.cie.gdr.repository.RepositoryProcessor;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.repository.common.NextGenHelper;
import com.oracle.cie.repository.common.NextGenHelperFactory;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class CoordinateGeneratorImpl
implements CoordinateGenerator {
    private static final Logger _log = Logger.getLogger(CoordinateGeneratorImpl.class.getName());
    private static RestHandler _restHandler = RestFactory.getRestHandler();
    private static NextGenHelper _nextGenHelper = NextGenHelperFactory.getNextGenHelper((RestHandler)_restHandler);
    private String _cacheRepo = null;

    public CoordinateGeneratorImpl() {
    }

    public CoordinateGeneratorImpl(String cacheRepo) {
        if (!StringUtil.isNullOrEmpty((String)cacheRepo)) {
            this._cacheRepo = cacheRepo;
        }
    }

    private RepositoryProcessor getRepositoryProcessor(String repoLocation, String coordinateOverrides) throws RestException, RepositoryCommonException, IOException, DependencyManagementException {
        RepoCommonConfig repoCommonConfig = RepoCommonConfig.createRepoCommonConfig(null, (String)repoLocation, (String)this._cacheRepo, null, null, null, null);
        if (StringUtil.isNullOrEmpty((String)coordinateOverrides)) {
            repoCommonConfig.setProperty("USE_LATEST", "true");
        } else {
            repoCommonConfig.setProperty("DEPENDENCY_OVERRIDE_COORDINATES", coordinateOverrides);
        }
        RepositoryVersionResolver versionResolver = _nextGenHelper.getConfiguredRepositoryVersionResolver(repoCommonConfig);
        File gdrDir = new File(repoCommonConfig.getRepoBaseDir() + File.separator + "gdr" + File.separator + "dev");
        ArrayList<Repository> repos = new ArrayList<Repository>();
        for (Repository r : repoCommonConfig.getRepositories()) {
            repos.add(r);
        }
        return new RepositoryProcessor(_restHandler, versionResolver, gdrDir, repos, false);
    }

    @Override
    public List<Artifact> getPomCoordinatesFromDist(String name, String version, String pathFromProductDir, String repoLocation) throws PomException {
        return this.getPomCoordinatesFromDist(name, version, pathFromProductDir, repoLocation, null);
    }

    @Override
    public List<Artifact> getPomCoordinatesFromDist(String name, String version, String pathFromProductDir, String repoLocation, String symbol) throws PomException {
        return this.getPomCoordinatesFromDist(name, version, pathFromProductDir, repoLocation, symbol, null);
    }

    @Override
    public List<Artifact> getPomCoordinatesFromDist(String name, String version, String pathFromProductDir, String repoLocation, String symbol, String coordinateOverrides) throws PomException {
        try {
            RepositoryProcessor processor = this.getRepositoryProcessor(repoLocation, coordinateOverrides);
            Set<Component> components = processor.getComponents(processor.getComponentArtifactsFromDistribution(name, version));
            HashSet<String> paths = new HashSet<String>();
            paths.add(pathFromProductDir);
            Map<String, List<Artifact>> coordinatesMap = this.getPomCoordinatesFromComponents(components, paths, symbol);
            return coordinatesMap.get(pathFromProductDir);
        }
        catch (Exception e) {
            PomException ex = new PomException(e);
            _log.throwing(CoordinateGeneratorImpl.class.getName(), "getPomCoordinatesFromDist", (Throwable)((Object)ex));
            throw ex;
        }
    }

    @Override
    public Map<String, List<Artifact>> getPomCoordinatesFromDist(String name, String version, Set<String> pathFromProductDir, String repoLocation) throws PomException {
        return this.getPomCoordinatesFromDist(name, version, pathFromProductDir, repoLocation, null);
    }

    @Override
    public Map<String, List<Artifact>> getPomCoordinatesFromDist(String name, String version, Set<String> pathFromProductDir, String repoLocation, String coordinateOverrides) throws PomException {
        try {
            RepositoryProcessor processor = this.getRepositoryProcessor(repoLocation, coordinateOverrides);
            Set<Component> components = processor.getComponents(processor.getComponentArtifactsFromDistribution(name, version));
            return this.getPomCoordinatesFromComponents(components, pathFromProductDir, null);
        }
        catch (Exception e) {
            PomException ex = new PomException(e);
            _log.throwing(CoordinateGeneratorImpl.class.getName(), "getPomCoordinatesFromDist", (Throwable)((Object)ex));
            throw ex;
        }
    }

    @Override
    public List<Artifact> getPomCoordinatesFromFeature(String name, String version, String pathFromProductDir, String repoLocation) throws PomException {
        return this.getPomCoordinatesFromFeature(name, version, pathFromProductDir, repoLocation, null);
    }

    @Override
    public List<Artifact> getPomCoordinatesFromFeature(String name, String version, String pathFromProductDir, String repoLocation, String symbol) throws PomException {
        return this.getPomCoordinatesFromFeature(name, version, pathFromProductDir, repoLocation, symbol, null);
    }

    @Override
    public List<Artifact> getPomCoordinatesFromFeature(String name, String version, String pathFromProductDir, String repoLocation, String symbol, String coordinateOverrides) throws PomException {
        try {
            RepositoryProcessor processor = this.getRepositoryProcessor(repoLocation, coordinateOverrides);
            FeatureSetReference featureRef = new FeatureSetReference(name, version);
            HashSet<FeatureSetReference> featureRefs = new HashSet<FeatureSetReference>();
            featureRefs.add(featureRef);
            Set<Component> components = processor.getComponents(processor.getComponentArtifactsFromFeatures(featureRefs));
            HashSet<String> paths = new HashSet<String>();
            paths.add(pathFromProductDir);
            Map<String, List<Artifact>> coordinatesMap = this.getPomCoordinatesFromComponents(components, paths, symbol);
            return coordinatesMap.get(pathFromProductDir);
        }
        catch (Exception e) {
            PomException ex = new PomException(e);
            _log.throwing(CoordinateGeneratorImpl.class.getName(), "getPomCoordinatesFromFeature", (Throwable)((Object)ex));
            throw ex;
        }
    }

    @Override
    public Map<String, List<Artifact>> getPomCoordinatesFromFeature(String name, String version, Set<String> pathFromProductDir, String repoLocation) throws PomException {
        return this.getPomCoordinatesFromFeature(name, version, pathFromProductDir, repoLocation, null);
    }

    @Override
    public Map<String, List<Artifact>> getPomCoordinatesFromFeature(String name, String version, Set<String> pathFromProductDir, String repoLocation, String coordinateOverrides) throws PomException {
        try {
            RepositoryProcessor processor = this.getRepositoryProcessor(repoLocation, coordinateOverrides);
            FeatureSetReference featureRef = new FeatureSetReference(name, version);
            HashSet<FeatureSetReference> featureRefs = new HashSet<FeatureSetReference>();
            featureRefs.add(featureRef);
            Set<Component> components = processor.getComponents(processor.getComponentArtifactsFromFeatures(featureRefs));
            return this.getPomCoordinatesFromComponents(components, pathFromProductDir, null);
        }
        catch (Exception e) {
            PomException ex = new PomException(e);
            _log.throwing(CoordinateGeneratorImpl.class.getName(), "getPomCoordinatesFromFeature", (Throwable)((Object)ex));
            throw ex;
        }
    }

    @Override
    public List<Artifact> getPomCoordinatesFromComp(String name, String version, String pathFromProductDir, String repoLocation) throws PomException {
        return this.getPomCoordinatesFromComp(name, version, pathFromProductDir, repoLocation, null);
    }

    @Override
    public List<Artifact> getPomCoordinatesFromComp(String name, String version, String pathFromProductDir, String repoLocation, String symbol) throws PomException {
        return this.getPomCoordinatesFromComp(name, version, pathFromProductDir, repoLocation, symbol, null);
    }

    @Override
    public List<Artifact> getPomCoordinatesFromComp(String name, String version, String pathFromProductDir, String repoLocation, String symbol, String coordinateOverrides) throws PomException {
        try {
            RepositoryProcessor processor = this.getRepositoryProcessor(repoLocation, coordinateOverrides);
            ComponentReference compRef = new ComponentReference(name, version);
            ArrayList<ComponentReference> compRefs = new ArrayList<ComponentReference>();
            compRefs.add(compRef);
            Set<Component> components = processor.getComponents(processor.getComponentArtifacts(compRefs));
            HashSet<String> paths = new HashSet<String>();
            paths.add(pathFromProductDir);
            Map<String, List<Artifact>> coordinatesMap = this.getPomCoordinatesFromComponents(components, paths, symbol);
            return coordinatesMap.get(pathFromProductDir);
        }
        catch (Exception e) {
            PomException ex = new PomException(e);
            _log.throwing(CoordinateGeneratorImpl.class.getName(), "getPomCoordinatesFromComp", (Throwable)((Object)ex));
            throw ex;
        }
    }

    @Override
    public Map<String, List<Artifact>> getPomCoordinatesFromComp(String name, String version, Set<String> pathFromProductDir, String repoLocation) throws PomException {
        return this.getPomCoordinatesFromComp(name, version, pathFromProductDir, repoLocation, null);
    }

    @Override
    public Map<String, List<Artifact>> getPomCoordinatesFromComp(String name, String version, Set<String> pathFromProductDir, String repoLocation, String coordinateOverrides) throws PomException {
        try {
            RepositoryProcessor processor = this.getRepositoryProcessor(repoLocation, coordinateOverrides);
            ComponentReference compRef = new ComponentReference(name, version);
            ArrayList<ComponentReference> compRefs = new ArrayList<ComponentReference>();
            compRefs.add(compRef);
            Set<Component> components = processor.getComponents(processor.getComponentArtifacts(compRefs));
            return this.getPomCoordinatesFromComponents(components, pathFromProductDir, null);
        }
        catch (Exception e) {
            PomException ex = new PomException(e);
            _log.throwing(CoordinateGeneratorImpl.class.getName(), "getPomCoordinatesFromComp", (Throwable)((Object)ex));
            throw ex;
        }
    }

    private Map<String, List<Artifact>> getPomCoordinatesFromComponents(Set<Component> components, Set<String> pathFromProductDir, String symbol) throws RestException, IOException, DataHandlerException, DependencyManagementException, GdrException, RepositoryCommonException {
        HashMap<String, List<Artifact>> coordinatesMap = new HashMap<String, List<Artifact>>();
        if (components != null && !components.isEmpty()) {
            for (Component comp : components) {
                Collection<ComponentTarget> compTargets;
                if (comp == null || (compTargets = FeatureSetHelper.getInstance().getComponentTargets(Mode.PACKAGE_SHIPHOME, comp, null, new ServiceHolder())) == null) continue;
                for (ComponentTarget compTarget : compTargets) {
                    if (!StringUtil.isNullOrEmpty((String)symbol) && !compTarget.getSymbol().equals(symbol)) continue;
                    for (FileTarget fileTarget : compTarget.getFileTargets()) {
                        String targetPath = FileUtils.formatPath(fileTarget.getDest(), "/");
                        if (!pathFromProductDir.contains(targetPath)) continue;
                        Module module = PomProcessor.generateArtifactModule(comp, fileTarget);
                        ArtifactImpl coordinate = new ArtifactImpl(module.getGroup(), module.getName(), module.getVersion(), module.getType());
                        if (coordinatesMap.containsKey(targetPath)) {
                            ((List)coordinatesMap.get(targetPath)).add(coordinate);
                            continue;
                        }
                        ArrayList<ArtifactImpl> coordinates = new ArrayList<ArtifactImpl>();
                        coordinates.add(coordinate);
                        coordinatesMap.put(targetPath, coordinates);
                    }
                }
            }
        }
        return coordinatesMap;
    }
}

