/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.dao.lbm.LabelMapReference;
import com.oracle.cie.gdr.external.ComponentMapping;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.LabelMapComponent;
import com.oracle.cie.gdr.external.impl.InventoryCache;
import com.oracle.cie.gdr.external.impl.LabelMapComponentImpl;
import java.util.ArrayList;
import java.util.List;

public class ComponentMappingImpl
implements ComponentMapping {
    private com.oracle.cie.gdr.dao.lbm.ComponentMapping _componentMapping;
    private MetaDataHome _metaDataHome;
    private LabelMap _labelMap;

    ComponentMappingImpl(com.oracle.cie.gdr.dao.lbm.ComponentMapping componentMapping, MetaDataHome metaDataHome, LabelMap labelMap) {
        this._componentMapping = componentMapping;
        this._metaDataHome = metaDataHome;
        this._labelMap = labelMap;
    }

    @Override
    public List<LabelMapComponent> getComponents() throws InventoryException {
        ArrayList<LabelMapComponent> labelMapRefs = new ArrayList<LabelMapComponent>();
        LabelMapComponent cachedComponent = null;
        for (LabelMapReference labelMapRef : this._componentMapping.getComponents()) {
            cachedComponent = InventoryCache.getInstance().getLabelMapComponent(this._metaDataHome, labelMapRef.getName(), labelMapRef.getVersion());
            if (null == cachedComponent) {
                cachedComponent = LabelMapComponentImpl.newInstance(labelMapRef.getName(), labelMapRef.getVersion(), this._metaDataHome, Mode.PACKAGE_SHIPHOME, labelMapRef, this._labelMap);
                InventoryCache.getInstance().putLabelMapComponent(this._metaDataHome, cachedComponent);
            }
            labelMapRefs.add(cachedComponent);
        }
        return labelMapRefs;
    }

    @Override
    public String getSeries() {
        return this._componentMapping.getSeries();
    }

    @Override
    public String getProduct() {
        return this._componentMapping.getProduct();
    }

    @Override
    public String getLabel() {
        return this._componentMapping.getLabel();
    }
}

