/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.builder.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cpd.Permission;
import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.external.builder.PermissionBuilder;
import com.oracle.cie.gdr.external.builder.impl.SelectionBuilderImpl;
import java.util.ArrayList;
import java.util.List;

public class PermissionBuilderImpl
extends SelectionBuilderImpl<Permission>
implements PermissionBuilder {
    public PermissionBuilderImpl(String mode) {
        super(new Permission());
        this.setMode(mode);
        this.setRegex(".*");
    }

    @Override
    public String getMode() {
        return this.getPermission().getMode();
    }

    @Override
    public void setMode(String mode) {
        this.getPermission().setMode(mode);
        if (!StringUtil.isNullOrEmpty((String)mode, (boolean)true)) {
            this.getPermission().setSourcePerms(false);
        }
    }

    @Override
    public boolean isSourcePerms() {
        return this.getPermission().isSourcePerms();
    }

    @Override
    public void setSourcePerms(boolean sourcePerms) {
        this.getPermission().setSourcePerms(sourcePerms);
        if (sourcePerms) {
            this.getPermission().setMode(null);
        }
    }

    Permission getPermission() {
        return (Permission)((Object)this.getSelection());
    }

    static List<Permission> getFileMapPermissions(List<PermissionBuilder> permissionBuilders) throws BuilderException {
        ArrayList<Permission> permissions = null;
        if (permissionBuilders != null && !permissionBuilders.isEmpty()) {
            permissions = new ArrayList<Permission>();
            for (PermissionBuilder permissionBuilder : permissionBuilders) {
                Permission permission = ((PermissionBuilderImpl)permissionBuilder).getPermission();
                if (StringUtil.isNullOrEmpty((String)permission.getMode(), (boolean)true) && !permission.isSourcePerms()) {
                    throw new BuilderException("The permission did not define a mode and was not enabled for source permissions: " + (Object)((Object)permission));
                }
                if (permission.isEmpty()) {
                    throw new BuilderException("Permission cannot be empty.  Please set a valid name, wildcard, regex, or pathmatcher value after creating the permission builder.");
                }
                permissions.add(permission);
            }
        }
        return permissions;
    }
}

