/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.builder.impl;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.cpd.Library;
import com.oracle.cie.gdr.dao.cpd.LibraryEntry;
import com.oracle.cie.gdr.dao.cpd.Variable;
import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.external.builder.ComponentBuilder;
import com.oracle.cie.gdr.external.builder.FileMapBuilder;
import com.oracle.cie.gdr.external.builder.StringsubsBuilder;
import com.oracle.cie.gdr.external.builder.impl.FileMapBuilderImpl;
import com.oracle.cie.gdr.external.builder.impl.StringsubsBuilderImpl;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ComponentBuilderImpl
implements ComponentBuilder {
    private Component _component;
    private boolean _extension;
    private List<FileMapBuilder> _fileMapBuilders = new ArrayList<FileMapBuilder>();
    private Map<String, String> _variables;
    private List<Library> _cachedLibraries;

    public ComponentBuilderImpl(String name, String version) throws BuilderException {
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            throw new BuilderException("The component name was null or empty.");
        }
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            throw new BuilderException("The component version was null or empty.");
        }
        this._component = new Component(name, version);
        this.setDescription(name);
    }

    @Override
    public String getName() {
        return this._component.getName();
    }

    @Override
    public String getVersion() {
        return this._component.getVersion();
    }

    @Override
    public String getDescription() {
        return this._component.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this._component.setDescription(description);
    }

    @Override
    public String getDescriptionKey() {
        return this._component.getDescriptionKey();
    }

    @Override
    public void setDescriptionKey(String key) {
        this._component.setDescriptionKey(key);
    }

    @Override
    public boolean isExtension() {
        return this._extension;
    }

    @Override
    public void setExtension(boolean extension) {
        this._extension = extension;
    }

    @Override
    public String getPomGen() {
        return this._component.getPomGen();
    }

    @Override
    public void setPomGen(boolean pomGen) {
        this.setPomGen(String.valueOf(pomGen));
    }

    @Override
    public boolean isReplicable() {
        return this._component.isReplicable();
    }

    @Override
    public void setReplicable(String replicable) {
        if (!StringUtil.isNullOrEmpty((String)replicable)) {
            this._component.setReplicable(Boolean.valueOf(replicable));
        }
    }

    @Override
    public boolean isSingleton() {
        return this._component.isSingleton();
    }

    @Override
    public void setSingleton(String singleton) {
        if (!StringUtil.isNullOrEmpty((String)singleton)) {
            this._component.setSingleton(Boolean.valueOf(singleton));
        }
    }

    @Override
    public void setPomGen(String pomGen) {
        this._component.setPomGen(pomGen);
    }

    @Override
    public void setVariables(Map<String, String> variables) {
        this._variables = variables;
    }

    @Override
    public Map<String, String> getVariables() {
        return this._variables;
    }

    @Override
    public FileMapBuilder addFileMap(String symbol) throws BuilderException {
        FileMapBuilderImpl fileMapBuilder = new FileMapBuilderImpl(symbol);
        this.addFileMap(fileMapBuilder);
        return fileMapBuilder;
    }

    @Override
    public List<FileMapBuilder> getFileMapBuilders() {
        return this._fileMapBuilders;
    }

    void addFileMap(FileMapBuilder fileMapBuilder) {
        this._fileMapBuilders.add(fileMapBuilder);
    }

    @Override
    public void addLibrary(String name, String type) {
        this.addLibrary(new Library(name, type));
    }

    @Override
    public void addLibrary(String name, String type, List<String> entries) {
        Library library = new Library(name, type);
        ArrayList<LibraryEntry> entriesList = new ArrayList<LibraryEntry>();
        for (String entryName : entries) {
            LibraryEntry entry = new LibraryEntry();
            entry.setName(entryName);
            entriesList.add(entry);
        }
        library.setEntries(entriesList);
        this.addLibrary(library);
    }

    private void addLibrary(Library library) {
        if (this._cachedLibraries == null) {
            this._cachedLibraries = new ArrayList<Library>();
        }
        this._cachedLibraries.add(library);
    }

    @Override
    public List<Library> getLibraries() {
        return this._cachedLibraries;
    }

    @Override
    public void save(File directory) throws BuilderException {
        if (directory == null) {
            throw new BuilderException("The specified save location was null.");
        }
        if (directory.exists() && !directory.isDirectory()) {
            throw new BuilderException("The specified save location was not a directory " + directory);
        }
        this.prepareToSave();
        try {
            String path = ComponentHelper.getInstallDir() + File.separator + ComponentHelper.getInstance().getPath() + File.separator + ComponentHelper.getFormattedName(this._component.getName()) + File.separator + this._component.getVersion();
            if (this.isExtension()) {
                path = path + "/" + ComponentHelper.getExtensionsDir();
            }
            File file = new File(directory, path + File.separator + ComponentHelper.getComponentDefFileName());
            ComponentHelper.getInstance().save((IDataHandlerWrapper)this._component, file);
        }
        catch (DataHandlerException e) {
            throw new BuilderException(e);
        }
    }

    protected void prepareToSave() throws BuilderException {
        ArrayList<FileMap> fileMaps = null;
        if (this._fileMapBuilders != null && !this._fileMapBuilders.isEmpty()) {
            fileMaps = new ArrayList<FileMap>();
            for (FileMapBuilder fileMapBuilder : this._fileMapBuilders) {
                fileMaps.add(((FileMapBuilderImpl)fileMapBuilder).getFileMap());
            }
        }
        if (this._variables != null && !this._variables.isEmpty()) {
            ArrayList<Variable> variables = new ArrayList<Variable>();
            for (Map.Entry<String, String> variable : this._variables.entrySet()) {
                variables.add(new Variable(variable.getKey(), variable.getValue()));
            }
            this._component.setVariables(variables);
        }
        this._component.setFileMaps(fileMaps);
        if (this._cachedLibraries != null && !this._cachedLibraries.isEmpty()) {
            this._component.setLibraries(this._cachedLibraries);
        }
    }

    public String toString() {
        return this._component.toString();
    }

    @Override
    public void setStringsubs(StringsubsBuilder stringsubs) {
        this._component.setStringsubs(((StringsubsBuilderImpl)stringsubs).getStringsubs());
    }
}

