/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dependency;

import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.dao.DependencyRef;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dependency.FeatureDefaultOrResolver;
import com.oracle.cie.gdr.external.FederatedRelationship;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class FederatedFeatureOrResolver
extends FeatureDefaultOrResolver {
    private Home _home;

    public FederatedFeatureOrResolver(FeatureSet feature, DependencyRef req, Home home) {
        super(feature, req);
        this._home = home;
    }

    @Override
    public boolean isResolvable() {
        Home parentFeatureHome;
        LinkedHashMap homesToFeatures = new LinkedHashMap();
        for (Home home : this._home.getFederatedHomes(FederatedRelationship.CHAINED_DEPENDENCY, true)) {
            homesToFeatures.put(home, new LinkedHashSet());
        }
        for (TEdge edge : this.getSelCandidates()) {
            VKey vKey = (VKey)((TVertex)edge.getDest()).getKey();
            if (((EKey)edge.getKey()).getType() != EKey.EType.REQUIRES || vKey.getType() != VKey.VType.TINFO) continue;
            FeatureSet th = (FeatureSet)vKey.getItem();
            if (!th.isExternal()) {
                ((Set)homesToFeatures.get(this._home)).add(edge);
                continue;
            }
            try {
                ((Set)homesToFeatures.get(this._home.getFeatureSetFederatedHome(th, FederatedRelationship.CHAINED_DEPENDENCY))).add(edge);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to locate home for feature set " + this.getItem());
            }
        }
        try {
            parentFeatureHome = ((FeatureSet)this.getItem()).isExternal() ? this._home.getFeatureSetFederatedHome((FeatureSet)this.getItem(), FederatedRelationship.CHAINED_DEPENDENCY) : this._home;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to locate home for feature set " + this.getItem());
        }
        boolean foundParentHome = false;
        for (Map.Entry entry : homesToFeatures.entrySet()) {
            if (!foundParentHome && !((Home)entry.getKey()).getHomePath().equals(parentFeatureHome.getHomePath())) continue;
            foundParentHome = true;
            if (((Set)entry.getValue()).isEmpty()) continue;
            if (((Set)entry.getValue()).size() == 1) {
                this.setSelected((TEdge)((Set)entry.getValue()).iterator().next());
                return true;
            }
            return false;
        }
        return false;
    }
}

