/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dependency;

import com.oracle.cie.common.Version;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.OrResolver;
import com.oracle.cie.dependency.SelectionTarget;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.VersionHelper;
import com.oracle.cie.dependency.dao.DependencyRef;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.dbd.InstallType;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dependency.FeatureDefaultOrResolverFactory;
import com.oracle.cie.gdr.dependency.FeatureSelectionConflictException;
import com.oracle.cie.gdr.dependency.FeatureUndeterministicSelectionException;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class FeatureSelectionTarget
extends SelectionTarget<FeatureSet> {
    protected Collection<FeatureSet> _features;
    protected List<FeatureSet> _items;
    protected List<FeatureSet> _existingItems;
    protected Mode _mode;
    protected FeatureDefaultOrResolverFactory _orResolverFactory;

    FeatureSelectionTarget(Collection<FeatureSet> features, Collection<FeatureSet> installedFeatures) {
        this(features, installedFeatures, Mode.INSTALL);
    }

    FeatureSelectionTarget(Collection<FeatureSet> features, Collection<FeatureSet> installedFeatures, Mode mode) {
        this(features, installedFeatures, mode, null);
    }

    FeatureSelectionTarget(Collection<FeatureSet> features, Collection<FeatureSet> installedFeatures, Mode mode, FeatureDefaultOrResolverFactory orResolverFactory) {
        this._features = features;
        this._mode = mode != null ? mode : Mode.INSTALL;
        this._orResolverFactory = orResolverFactory == null ? new FeatureDefaultOrResolverFactory() : orResolverFactory;
        HashSet<FeatureSet> allFeatures = new HashSet<FeatureSet>();
        if (features != null) {
            allFeatures.addAll(FeatureSetHelper.getInstance().swapSupersededFeatureSets(features));
        }
        if (installedFeatures != null) {
            this._existingItems = FeatureSetHelper.getInstance().swapSupersededFeatureSets(installedFeatures);
            allFeatures.addAll(this._existingItems);
        } else {
            this._existingItems = new ArrayList<FeatureSet>();
        }
        this._items = new ArrayList<FeatureSet>(allFeatures);
        this.init();
        HashSet<FeatureSet> selected = new HashSet<FeatureSet>();
        if (this._features != null) {
            for (FeatureSet feature : this._features) {
                if (!feature.isVisible() && !feature.isRequired()) continue;
                selected.add(feature);
            }
        }
        this.setSelectableItems(selected);
    }

    public Set<FeatureSet> getFeatures() {
        return new LinkedHashSet<FeatureSet>(this._features);
    }

    public Set<FeatureSet> getInstalledFeatures() {
        return new LinkedHashSet<FeatureSet>(this._existingItems);
    }

    public Mode getMode() {
        return this._mode;
    }

    public void setInstallType(InstallType installType) throws DependencyException {
        this.unselectAll();
        Set<FeatureSetReference> installTypeFeatures = installType.getFullFeatures();
        if (installTypeFeatures != null && !installTypeFeatures.isEmpty()) {
            List orderedFeatures = this.getOrderedItems();
            block0: for (FeatureSetReference ref : installTypeFeatures) {
                if (!ref.isSelected() && !ref.isRequired()) continue;
                for (FeatureSet feature : orderedFeatures) {
                    if (!feature.matchesReference(ref)) continue;
                    if (this.isSelected(feature) || this.isInstalled(feature)) continue block0;
                    this.selectWithPrerequisites(feature, true);
                    continue block0;
                }
            }
        }
    }

    protected List<FeatureSet> getItems() {
        return this._items;
    }

    protected List<FeatureSet> getItems(FeatureSet parent, DependencyRef dep) {
        ArrayList<FeatureSet> features = new ArrayList<FeatureSet>();
        String name = dep.getName();
        HashMap<Version, FeatureSet> versionMap = new HashMap<Version, FeatureSet>();
        for (FeatureSet featureSet : this.getItems()) {
            if (!name.equals(featureSet.getName())) continue;
            versionMap.put(new Version(featureSet.getVersion()), featureSet);
        }
        if (!versionMap.isEmpty()) {
            List ranges;
            FeatureSet match;
            if (dep.isSetVersion() && (match = (FeatureSet)versionMap.get(new Version(dep.getVersion()))) != null) {
                features.add(match);
            }
            if ((ranges = dep.getVersionRanges()) != null && !ranges.isEmpty()) {
                for (Version version : versionMap.keySet()) {
                    FeatureSet match2;
                    if (!VersionHelper.isVersionWithinRanges((Version)version, (List)ranges) || features.contains(match2 = (FeatureSet)versionMap.get(version))) continue;
                    features.add(match2);
                }
            }
            if (features.isEmpty()) {
                HashSet<Version> hashSet = new HashSet<Version>();
                block2: for (FeatureSet featureSet : versionMap.values()) {
                    if (featureSet.isUpgrades()) {
                        for (FeatureSet upgrade : featureSet.getUpgrades()) {
                            hashSet.add(new Version(upgrade.getVersion()));
                        }
                    }
                    if (featureSet.hasReplaces()) {
                        for (FeatureSet replacedFeature : featureSet.getReplaces()) {
                            hashSet.add(new Version(replacedFeature.getVersion()));
                            if (!replacedFeature.isUpgrades()) continue;
                            for (FeatureSet upgrade : replacedFeature.getUpgrades()) {
                                hashSet.add(new Version(upgrade.getVersion()));
                            }
                        }
                    }
                    if (hashSet.isEmpty()) continue;
                    if (dep.isSetVersion() && hashSet.contains(new Version(dep.getVersion()))) {
                        features.add(featureSet);
                        break;
                    }
                    if (ranges == null || ranges.isEmpty()) continue;
                    for (Version oldVersion : hashSet) {
                        if (!VersionHelper.isVersionWithinRanges((Version)oldVersion, (List)ranges)) continue;
                        features.add(featureSet);
                        continue block2;
                    }
                }
            }
            if (features.isEmpty()) {
                for (FeatureSet feature : this.getFeatures()) {
                    if (!name.equals(feature.getName()) || !feature.isSuperseded() || !versionMap.containsKey(new Version(feature.getSupersededVersion()))) continue;
                    features.add((FeatureSet)versionMap.get(new Version(feature.getSupersededVersion())));
                }
            }
        }
        return features;
    }

    protected List<FeatureSet> getImplicitConflicts(FeatureSet parent) {
        ArrayList<FeatureSet> features = new ArrayList<FeatureSet>();
        return features;
    }

    protected List<FeatureSet> getExistingItems() {
        return this._existingItems;
    }

    protected Comparator<FeatureSet> getItemComparator() {
        return new FeatureSetComparator();
    }

    protected OrResolver getDefaultOrResolver(FeatureSet parent, DependencyRef req) {
        return this._orResolverFactory.getFeatureDefaultOrResolver(parent, req);
    }

    protected void throwSelectionConflictException(Collection<TVertex> unresolvedPrereqs, Collection<TVertex> selfConflicts, Collection<TVertex> prereqsConflictingWithInstalled, Collection<TVertex> installedConflicts) throws DependencyException {
        throw new FeatureSelectionConflictException(unresolvedPrereqs, selfConflicts, prereqsConflictingWithInstalled, installedConflicts);
    }

    protected void throwUndeterministicSelectionException(Collection<TVertex> unresolvedORs, DirectedGraph<VKey, TVertex, EKey, TEdge> graph) throws DependencyException {
        throw new FeatureUndeterministicSelectionException(unresolvedORs, graph);
    }

    protected void throwDependencyException(SelectionTarget.ErrorType errorType, Throwable cause) throws DependencyException {
        if (cause == null) {
            throw new DependencyException("Error -- " + errorType.toString(), errorType);
        }
        throw new DependencyException(cause, errorType);
    }

    private static class FeatureSetComparator
    implements Comparator<FeatureSet> {
        private FeatureSetComparator() {
        }

        @Override
        public int compare(FeatureSet feature1, FeatureSet feature2) {
            Version v2;
            String name2;
            String name1 = feature1.getName();
            if (!name1.equals(name2 = feature2.getName())) {
                return name1.compareTo(name2);
            }
            Version v1 = new Version(feature1.getVersion());
            if (!v1.equals((Object)(v2 = new Version(feature2.getVersion())))) {
                return v1.compareTo(v2);
            }
            return 1;
        }
    }
}

