/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.deinstallation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.deinstallation.CommonDeInstaller;
import com.oracle.cie.gdr.deinstallation.DeInstallationSession;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatchComponentArchiveDeInstaller
extends CommonDeInstaller {
    private static final Logger _log = Logger.getLogger(PatchComponentArchiveDeInstaller.class.getName());
    private Map<DistributionTarget, ComponentLoader> _distributionsMap;
    private Registry _lockedRegistry;
    private String _patchId;
    private Path _homePath;

    public PatchComponentArchiveDeInstaller(DeInstallationSession deInstallerSession, Set<Reference> componentRefs, Registry registry, String patchId, SessionInfo sessionInfo) throws GdrException, IOException, DataHandlerException {
        super(deInstallerSession);
        this._lockedRegistry = registry;
        this._registrySession = sessionInfo;
        this._patchId = patchId;
        this._homePath = deInstallerSession.getHomeDirPath();
        this.init(componentRefs);
    }

    protected void init(Set<Reference> componentReferences) throws GdrException, IOException, DataHandlerException {
        if (componentReferences == null || componentReferences.isEmpty()) {
            GdrException ex = new GdrException("Failed to deinstall because no components were provided.");
            _log.throwing(this.getClass().getName(), "init", ex);
            throw ex;
        }
        this._distributionsMap = new HashMap<DistributionTarget, ComponentLoader>();
        if (componentReferences != null && !componentReferences.isEmpty()) {
            for (Reference componentReference : componentReferences) {
                ComponentReference installedComp = this.getHome().getInstalledComponent(componentReference.getName(), componentReference.getVersion());
                if (installedComp == null || installedComp.getStatus().isNotInstalled()) {
                    if (!_log.isLoggable(Level.FINE)) continue;
                    _log.fine("Component " + (Object)((Object)componentReference) + " was not installed in the home directory " + this._homePath + ", skipping...");
                    continue;
                }
                Set<FeatureSet> componentsFeatureSets = this.getHome().getInstalledFeatureSets(installedComp);
                if (componentsFeatureSets.isEmpty()) {
                    GdrException ex = new GdrException("The Component " + (Object)((Object)installedComp) + " is not a member of any feature sets in the home directory " + this._homePath);
                    _log.throwing(this.getClass().getName(), "init", ex);
                    throw ex;
                }
                for (FeatureSet componentFeatureSet : componentsFeatureSets) {
                    this.addFeatureSet(componentFeatureSet, componentReferences);
                }
            }
        }
        if (this._distributionsMap.isEmpty()) {
            _log.info("None of the features or components specified for deinstall were installed.");
        }
    }

    protected void addFeatureSet(FeatureSet featureSet, Set<Reference> componentFilter) throws GdrException, IOException, DataHandlerException {
        Collection<DistributionTarget> featureDistributions = this.getHome().getInstalledDistributions(featureSet);
        HashSet<FeatureSet> featuresets = new HashSet<FeatureSet>();
        featuresets.add(featureSet);
        DistributionInfo targetDistInfo = null;
        DistributionTarget distributionTargetToReplace = null;
        for (DistributionInfo distInfo : this.getLockedRegistry().getDistributions()) {
            for (FeatureInfo fInfo : distInfo.getFeatures()) {
                if (!fInfo.getName().equals(featureSet.getName()) || !fInfo.getVersion().equals(featureSet.getVersion()) && !fInfo.getOriginalVersion().equals(featureSet.getVersion())) continue;
                targetDistInfo = distInfo;
                distributionTargetToReplace = new DistributionTarget(DistributionHelper.getInstance().getDistribution(this.getHome().getMetaDataHome(), distInfo.getName(), distInfo.getVersion()), featuresets);
                for (DistributionTarget distTarget : featureDistributions) {
                    if (distTarget.getDistributionName().equals(targetDistInfo.getName()) && (targetDistInfo.getOriginalVersion().equals(distTarget.getDistributionVersion()) || targetDistInfo.getVersion().equals(distTarget.getDistributionVersion()))) {
                        featureDistributions.add(distributionTargetToReplace);
                    }
                    featureDistributions.remove(distTarget);
                }
            }
        }
        if (featureDistributions != null && !featureDistributions.isEmpty()) {
            for (DistributionTarget featureDistribution : featureDistributions) {
                FeatureSet actualFeatureSet = featureDistribution.getFeatureSet(featureSet.getName(), featureSet.getVersion());
                ComponentLoader componentLoader = this._distributionsMap.get(featureDistribution);
                if (componentLoader == null) {
                    componentLoader = new ComponentLoader(this.getMetaDataHome(), this.getServiceHolder(), Mode.DEINSTALL, actualFeatureSet, featureDistribution.getDirectoryMap(), this.getDeInstallInfo(), componentFilter);
                    this._distributionsMap.put(featureDistribution, componentLoader);
                    continue;
                }
                componentLoader.loadFeature(actualFeatureSet, componentFilter);
            }
        } else {
            GdrException ex = new GdrException("The FeatureSet " + featureSet + " is not a member of any distribution in the home directory " + this._homePath);
            _log.throwing(this.getClass().getName(), "init", ex);
            throw ex;
        }
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return new LinkedHashSet<FeatureSet>(this.getComponentsMap().keySet());
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap() {
        LinkedHashMap<FeatureSet, Collection<Component>> componentMap = new LinkedHashMap<FeatureSet, Collection<Component>>();
        for (ComponentLoader componentLoader : this._distributionsMap.values()) {
            Map<FeatureSet, Collection<Component>> compMap = componentLoader.getComponentsMap();
            for (FeatureSet feature : compMap.keySet()) {
                if (componentMap.containsKey(feature)) {
                    Collection components = (Collection)componentMap.get(feature);
                    for (Component component : compMap.get(feature)) {
                        if (components.contains(component)) continue;
                        components.add(component);
                    }
                    continue;
                }
                componentMap.put(feature, new LinkedHashSet<Component>(compMap.get(feature)));
            }
        }
        return componentMap;
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap(Distribution distribution) {
        HashMap<FeatureSet, Collection<Component>> componentsMap = new HashMap<FeatureSet, Collection<Component>>();
        ComponentLoader componentLoader = null;
        for (DistributionTarget distTarget : this._distributionsMap.keySet()) {
            if (!distTarget.getDistribution().equals(distribution)) continue;
            componentLoader = this._distributionsMap.get(distTarget);
        }
        if (componentLoader != null) {
            Map<FeatureSet, Collection<Component>> compMap = componentLoader.getComponentsMap();
            for (FeatureSet feature : compMap.keySet()) {
                if (componentsMap.containsKey(feature)) {
                    Collection components = (Collection)componentsMap.get(feature);
                    for (Component component : compMap.get(feature)) {
                        if (components.contains(component)) continue;
                        components.add(component);
                    }
                    continue;
                }
                componentsMap.put(feature, new LinkedHashSet<Component>(compMap.get(feature)));
            }
        }
        return componentsMap;
    }

    @Override
    public Map<Distribution, Set<FeatureSet>> getFeatureSetsMap() {
        HashMap<Distribution, Set<FeatureSet>> featureSetsMap = new HashMap<Distribution, Set<FeatureSet>>();
        for (Map.Entry<DistributionTarget, ComponentLoader> entry : this._distributionsMap.entrySet()) {
            DistributionTarget distributionTarget = entry.getKey();
            ComponentLoader componentLoader = entry.getValue();
            featureSetsMap.put(distributionTarget.getDistribution(), componentLoader.getComponentsMap().keySet());
        }
        return featureSetsMap;
    }

    @Override
    public Set<Component> getComponents() {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        for (ComponentLoader componentLoader : this._distributionsMap.values()) {
            components.addAll(componentLoader.getComponents());
        }
        return components;
    }

    @Override
    public Set<Distribution> getDistributions() {
        LinkedHashSet<Distribution> distributions = new LinkedHashSet<Distribution>();
        for (DistributionTarget distribution : this._distributionsMap.keySet()) {
            distributions.add(distribution.getDistribution());
        }
        return distributions;
    }

    @Override
    int getFeatureRemainingRefCount(FeatureSet feature) {
        return 0;
    }

    @Override
    Collection<DistributionTarget> getAffectedDistributions() {
        return new HashSet<DistributionTarget>(this._distributionsMap.keySet());
    }

    @Override
    public List<Component> getSelectedComponents(FeatureSet featureSet) {
        return new ArrayList<Component>(this.getComponentsMap().get(featureSet));
    }

    @Override
    protected void updateRegistry(Registry registry, SessionInfo session) {
    }

    @Override
    protected SessionInfo getRegistrySession(Registry preRegistry) throws GdrException {
        return this._registrySession;
    }

    @Override
    protected Registry getLockedRegistry() throws IOException, DataHandlerException, GdrException {
        return this._lockedRegistry;
    }

    @Override
    protected void unlockRegistry() throws IOException, DataHandlerException, GdrException {
    }

    @Override
    protected void deleteRemovedComponentsMetadata(Path dir) {
    }
}

