/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.deinstallation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.deinstallation.DeInstallationSession;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.external.DeInstallerSession;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.session.DistributionSession;
import com.oracle.cie.gdr.session.DistributionSessionImpl;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureSetDeInstallationSession
extends DeInstallationSession
implements DeInstallerSession,
DistributionSession {
    private Map<Distribution, Set<FeatureSet>> _sessionMap;
    private Map<DistributionTarget, FeatureSelectionTarget> _targetsMap;
    private List<DistributionSession> _distributionSessions;
    private List<DistributionLoader> _distributionLoaders;

    public FeatureSetDeInstallationSession(File homeDir) throws GdrException, IOException, DataHandlerException {
        super(homeDir);
    }

    public FeatureSetDeInstallationSession(File homeDir, Map<Distribution, Set<FeatureSet>> mixedReferencesMap) throws GdrException, IOException, DataHandlerException {
        super(homeDir);
        this._sessionMap = mixedReferencesMap;
        this.init();
    }

    private void init() throws GdrException, IOException, DataHandlerException {
        this._distributionSessions = new ArrayList<DistributionSession>();
        for (Map.Entry<Distribution, Set<FeatureSet>> entry : this._sessionMap.entrySet()) {
            Distribution distributionReference = entry.getKey();
            DistributionSessionImpl distributionSession = new DistributionSessionImpl(this.getHome(), this.getMetaDataHome(), distributionReference, Mode.DEINSTALL);
            this._distributionSessions.add(distributionSession);
        }
        List<DistributionLoader> distributionLoaders = this.getDistributionLoaders();
        for (DistributionLoader distributionLoader : distributionLoaders) {
            Set<FeatureSet> featuresToUninstall = this._sessionMap.get(distributionLoader.getDistribution());
            Set<FeatureSet> installedFeatures = distributionLoader.getInstalledFeatureSets();
            Set<FeatureSet> normalizedFeatures = this.normalizeFeatureSet(featuresToUninstall, installedFeatures);
            this._sessionMap.put(distributionLoader.getDistribution(), normalizedFeatures);
        }
        this._targetsMap = this.initTargetsMap();
    }

    private Map<DistributionTarget, FeatureSelectionTarget> initTargetsMap() {
        HashMap<DistributionTarget, FeatureSelectionTarget> targetsMap = new HashMap<DistributionTarget, FeatureSelectionTarget>();
        for (DistributionSession session : this._distributionSessions) {
            targetsMap.put(session.getDistributionLoader().getDistributionTarget(), session.getFeatureSelectionTarget());
        }
        return targetsMap;
    }

    private Set<FeatureSet> normalizeFeatureSet(Set<FeatureSet> featuresToUninstall, Set<FeatureSet> installedFeatures) {
        List<FeatureSet> partialFeatures = FeatureSetHelper.getInstance().swapSupersededFeatureSets(installedFeatures);
        List<FeatureSet> normalizedFeatures = FeatureSetHelper.getInstance().swapUpgradedFeatureSets(partialFeatures);
        LinkedHashSet<FeatureSet> normalizedSet = new LinkedHashSet<FeatureSet>();
        for (FeatureSet featureset : normalizedFeatures) {
            if (!featuresToUninstall.contains(featureset)) continue;
            normalizedSet.add(featureset);
        }
        return normalizedSet;
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        HashSet<FeatureSet> selected = new HashSet<FeatureSet>();
        if (this._sessionMap != null) {
            for (Map.Entry<Distribution, Set<FeatureSet>> entry : this._sessionMap.entrySet()) {
                selected.addAll((Collection<FeatureSet>)entry.getValue());
            }
        }
        return selected;
    }

    public List<DistributionLoader> getDistributionLoaders() {
        if (this._distributionLoaders == null) {
            this._distributionLoaders = new ArrayList<DistributionLoader>();
            for (DistributionSession session : this._distributionSessions) {
                this._distributionLoaders.add(session.getDistributionLoader());
            }
        }
        return this._distributionLoaders;
    }

    public Map<Distribution, Set<FeatureSet>> getFeatureSetSessionMap() {
        return this._sessionMap;
    }

    public List<FeatureSelectionTarget> getFeatureSelectionTargets() {
        ArrayList<FeatureSelectionTarget> featuresetSelectionTargets = new ArrayList<FeatureSelectionTarget>();
        for (DistributionSession session : this._distributionSessions) {
            featuresetSelectionTargets.add(session.getFeatureSelectionTarget());
        }
        return featuresetSelectionTargets;
    }
}

