/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.rgy;

import com.oracle.cie.common.dao.DataHandlerHelper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.dao.pch.Patch;
import com.oracle.cie.gdr.dao.rgy.BaseInfoReference;
import com.oracle.cie.gdr.dao.rgy.PatchInfo;
import com.oracle.cie.gdr.dao.rgy.TargetInfo;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.selection.Status;
import java.util.List;

public class ComponentInfo
extends BaseInfoReference {
    public ComponentInfo(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public ComponentInfo(ClassLoader classLoader) {
        this(RegistryHelper.getInstance(classLoader).create("component-info"));
    }

    public ComponentInfo(ClassLoader classLoader, String name, String version) {
        this(classLoader, name, version, null);
    }

    public ComponentInfo(ClassLoader classLoader, String name, String version, String patchLevel) {
        this(classLoader);
        this.setName(name);
        this.setVersion(version);
        if (!StringUtil.isNullOrEmpty((String)patchLevel, (boolean)true)) {
            this.setPatchLevel(patchLevel);
        }
    }

    public boolean isSingleton() {
        return this.getBooleanAttribute("singleton");
    }

    public void setSingleton(boolean singleton) {
        this.setAttribute("singleton", singleton);
    }

    public String getPatchLevel() {
        return this.getStringAttribute("patch-level");
    }

    public void setPatchLevel(String patchLevel) {
        this.setAttribute("patch-level", patchLevel);
    }

    public List<PatchInfo> getPatches() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("patches"), (String)"patch", PatchInfo.class);
    }

    public void setPatches(List<PatchInfo> patches) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("patches", true), (String)"patch", patches);
    }

    public void addPatch(PatchInfo patch) {
        this.getSingleOccuranceComplexValue("patches", true).addComplexValue("patch", patch.getDataHandler());
    }

    public void addPatch(Patch patch) {
        PatchInfo ref = new PatchInfo(this.getObjectClassLoader(), patch.getPatchId());
        ref.setInstallDate(patch.getInstallDate());
        ref.setStatus(Status.installed);
        this.addPatch(ref);
    }

    public void addPatches(List<Patch> patches, boolean excludeDups) {
        if (excludeDups) {
            List<PatchInfo> current = this.getPatches();
            for (Patch patch : patches) {
                PatchInfo ref = new PatchInfo(this.getObjectClassLoader(), patch.getPatchId());
                if (current != null && current.contains(ref)) continue;
                this.addPatch(ref);
            }
        } else {
            for (Patch patch : patches) {
                this.addPatch(patch);
            }
        }
    }

    public void removePatches(List<Patch> patches) {
        List<PatchInfo> current;
        if (patches != null && !patches.isEmpty() && (current = this.getPatches()) != null && !current.isEmpty()) {
            int origSize = current.size();
            for (Patch patch : patches) {
                current.remove(new PatchInfo(this.getObjectClassLoader(), patch.getPatchId()));
            }
            if (current.size() < origSize) {
                this.setPatches(current);
            }
        }
    }

    public List<TargetInfo> getTargets() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("targets"), (String)"target", TargetInfo.class);
    }

    public void setTargets(List<TargetInfo> targets) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("targets", true), (String)"target", targets);
    }

    public void addTarget(TargetInfo target) {
        this.getSingleOccuranceComplexValue("targets", true).addComplexValue("target", target.getDataHandler());
    }

    public void addTarget(ComponentTarget componentTarget) {
        TargetInfo targetInfo = new TargetInfo(this.getObjectClassLoader(), componentTarget);
        targetInfo.setSymbol(componentTarget.getSymbol());
        targetInfo.setLocation(componentTarget.getLocation());
        this.addTarget(targetInfo);
    }

    public void addTargets(List<ComponentTarget> componentTargets, boolean excludeDups) {
        block4: {
            if (componentTargets == null || componentTargets.isEmpty()) break block4;
            if (excludeDups) {
                List<TargetInfo> current = this.getTargets();
                for (ComponentTarget componentTarget : componentTargets) {
                    TargetInfo targetInfo = new TargetInfo(this.getObjectClassLoader(), componentTarget);
                    targetInfo.setSymbol(componentTarget.getSymbol());
                    targetInfo.setLocation(componentTarget.getLocation());
                    if (current != null && current.contains(targetInfo)) continue;
                    this.addTarget(targetInfo);
                }
            } else {
                for (ComponentTarget componentTarget : componentTargets) {
                    this.addTarget(componentTarget);
                }
            }
        }
    }

    public void removeTargets(List<ComponentTarget> componentTargets) {
        List<TargetInfo> current;
        if (componentTargets != null && !componentTargets.isEmpty() && (current = this.getTargets()) != null && !current.isEmpty()) {
            int origSize = current.size();
            for (ComponentTarget componentTarget : componentTargets) {
                current.remove(new TargetInfo(this.getObjectClassLoader(), componentTarget));
            }
            if (current.size() < origSize) {
                this.setTargets(current);
            }
        }
    }

    @Override
    public String toString() {
        String patchLevel = this.getPatchLevel();
        return super.toString() + (!StringUtil.isNullOrEmpty((String)patchLevel, (boolean)true) ? " (patch-level " + patchLevel + ")" : "");
    }
}

