/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.pom;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.pom.PomLibraryRef;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.services.RepositoryArtifact;

public class PomArtifact
extends AbstractDataHandlerWrapper
implements RepositoryArtifact {
    String type;

    public PomArtifact(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public PomArtifact(String groupID, String artifact, String version, String type) {
        super(FeatureSetHelper.getInstance().create("pom"));
        this.setGroup(groupID);
        this.setArtifact(artifact);
        this.setVersion(version);
        this.setType(type);
    }

    @Override
    public String getGroup() {
        return this.getStringAttribute("groupId");
    }

    @Override
    public void setGroup(String group) {
        this.setAttribute("groupId", group);
    }

    @Override
    public String getArtifact() {
        return this.getStringAttribute("artifactId");
    }

    @Override
    public void setArtifact(String artifact) {
        this.setAttribute("artifactId", artifact);
    }

    @Override
    public String getVersion() {
        return this.getStringAttribute("version");
    }

    @Override
    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    @Override
    public boolean isIgnoreVersionKeywords() {
        return this.getBooleanAttribute("ignore-version-keywords");
    }

    @Override
    public void setIgnoreVersionKeywords(boolean ignore) {
        this.setAttribute("ignore-version-keywords", ignore);
    }

    @Override
    public String getClassifier() {
        return this.getStringAttribute("classifier");
    }

    @Override
    public void setClassifier(String classifier) {
        this.setAttribute("classifier", classifier);
    }

    @Override
    public String getType() {
        if (StringUtil.isNullOrEmpty((String)this.type)) {
            return this.getStringAttribute("type");
        }
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getBaseVersion() {
        return this.getStringAttribute("baseVersion");
    }

    @Override
    public void setBaseVersion(String baseVersion) {
        this.setAttribute("baseVersion", baseVersion);
    }

    public PomLibraryRef getLibraryRef() {
        return (PomLibraryRef)((Object)this.getSingleOccuranceComplexValueWrapped("lib-ref", PomLibraryRef.class));
    }

    public String getDependencyVersion() {
        return this.getStringAttribute("dependency-version");
    }

    public void setDependencyVersion(String dependencyVersion) {
        this.setAttribute("dependency-version", dependencyVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().isAssignableFrom(this.getClass())) {
            return false;
        }
        PomArtifact artifact = (PomArtifact)o;
        String thisType = this.getType();
        String theirType = artifact.getType();
        String thisArtifact = this.getArtifact();
        String theirArtifact = artifact.getArtifact();
        String thisGroup = this.getGroup();
        String theirGroup = artifact.getGroup();
        String thisVersion = this.getVersion();
        String theirVersion = artifact.getVersion();
        String thisDependencyVersion = this.getDependencyVersion();
        String theirDependencyVersion = artifact.getDependencyVersion();
        return !((thisType == null ? theirType != null : !thisType.equals(theirType)) || (thisArtifact == null ? theirArtifact != null : !thisArtifact.equals(theirArtifact)) || (thisGroup == null ? theirGroup != null : !thisGroup.equals(theirGroup)) || (thisVersion == null ? theirVersion != null : !thisVersion.equals(theirVersion)) || (thisDependencyVersion == null ? theirDependencyVersion != null : !thisDependencyVersion.equals(theirDependencyVersion)));
    }

    public int hashCode() {
        String thisType = this.getType();
        String thisArtifact = this.getArtifact();
        String thisGroup = this.getGroup();
        String thisVersion = this.getVersion();
        String thisDependencyVersion = this.getDependencyVersion();
        int result = thisType != null ? thisType.hashCode() : 0;
        result = 31 * result + (thisArtifact != null ? thisArtifact.hashCode() : 0);
        result = 31 * result + (thisGroup != null ? thisGroup.hashCode() : 0);
        result = 31 * result + (thisVersion != null ? thisVersion.hashCode() : 0);
        result = 31 * result + (thisDependencyVersion != null ? thisDependencyVersion.hashCode() : 0);
        return result;
    }
}

