/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.pch;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.DataHandlerHelper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.pch.BugList;
import com.oracle.cie.gdr.dao.pch.Locale;
import com.oracle.cie.gdr.dao.pch.PatchDependencies;
import com.oracle.cie.gdr.helpers.PatchHelper;
import com.oracle.cie.gdr.selection.Status;
import java.util.Calendar;
import java.util.List;

public class Patch
extends AbstractDataHandlerWrapper {
    private Status _status = Status.notinstalled;
    private Calendar _installDate;
    private List<ComponentReference> _cachedComponentWrappers;

    public Patch(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public Patch() {
        this((ClassLoader)null);
    }

    public Patch(ClassLoader classloader) {
        this(PatchHelper.getInstance(classloader).create("patch-def"));
    }

    public Patch(String patchId) {
        this(patchId, null);
    }

    public Patch(String patchId, ClassLoader classloader) {
        this(classloader);
        this.setPatchId(patchId);
    }

    public String getUniquePatchId() {
        return this.getStringAttribute("unique-patch-id");
    }

    public void setUniquePatchId(String uniquePatchId) {
        this.setAttribute("unique-patch-id", uniquePatchId);
    }

    public void setPatchId(String patchId) {
        this.setAttribute("patch-id", patchId);
    }

    public String getPatchId() {
        return this.getStringAttribute("patch-id");
    }

    public String getDescription() {
        return this.getStringAttribute("description");
    }

    public void setDescription(String description) {
        this.setAttribute("description", description);
    }

    public String getInstallerVersion() {
        return this.getStringAttribute("installer-version");
    }

    public void setInstallerVersion(String installerVersion) {
        this.setAttribute("installer-version", installerVersion);
    }

    public boolean isRollbackable() {
        return Boolean.valueOf(this.getStringAttribute("rollbackable"));
    }

    public void setRollbackable(boolean rollbackable) {
        this.setAttribute("rollbackable", rollbackable);
    }

    public BugList getBugList() {
        return (BugList)((Object)this.getSingleOccuranceComplexValueWrapped("buglist", BugList.class));
    }

    public void setBugList(BugList bugList) {
        this.setSingleOccuranceComplexValueWrapped("buglist", (IDataHandlerWrapper)bugList);
    }

    public PatchDependencies getPatchDependencies() {
        return (PatchDependencies)((Object)this.getSingleOccuranceComplexValueWrapped("patch-dependencies", PatchDependencies.class));
    }

    public void setPatchDependencies(PatchDependencies PatchDependencies2) {
        this.setSingleOccuranceComplexValueWrapped("patch-dependencies", (IDataHandlerWrapper)PatchDependencies2);
    }

    public List<ComponentReference> getComponents() {
        if (this._cachedComponentWrappers == null) {
            this._cachedComponentWrappers = DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("components"), (String)"component", ComponentReference.class);
        }
        return this._cachedComponentWrappers;
    }

    public void setComponents(List<ComponentReference> components) {
        this._cachedComponentWrappers = null;
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("components", true), (String)"component", components);
    }

    public List<Locale> getLocales() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("locales"), (String)"locale", Locale.class);
    }

    public void setLocales(List<Locale> locales) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("locales", true), (String)"locale", locales);
    }

    public void setLocation(String location) {
        this.setAttribute("location", location);
    }

    public String getLocation() {
        return this.getStringAttribute("location");
    }

    public Status getStatus() {
        return this._status;
    }

    public void setStatus(Status status) {
        this._status = status;
    }

    public Calendar getInstallDate() {
        return this._installDate;
    }

    public void setInstallDate(Calendar installDate) {
        this._installDate = installDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Patch that = (Patch)((Object)o);
        String thisPatchId = this.getPatchId();
        String thatPatchId = that.getPatchId();
        return !(thisPatchId == null ? thatPatchId != null : !thisPatchId.equals(thatPatchId));
    }

    public int hashCode() {
        String thisPatchId = this.getPatchId();
        int result = thisPatchId != null ? thisPatchId.hashCode() : 0;
        result = 31 * result;
        return result;
    }

    public String toString() {
        return this.getPatchId();
    }
}

