/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.inv;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.gdr.dao.inv.BugInfo;
import com.oracle.cie.gdr.dao.inv.PatchGroupReference;
import com.oracle.cie.gdr.helpers.InventoryHelper;

public class ComponentReference
extends AbstractDataHandlerWrapper {
    public ComponentReference(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public ComponentReference(String name, String version) {
        this(InventoryHelper.getInstance().create("component"));
        this.setName(name);
        this.setVersion(version);
    }

    public ComponentReference(String name, String version, PatchGroupReference patchGroup) {
        this(InventoryHelper.getInstance().create("component"));
        this.setName(name);
        this.setVersion(version);
        this.setPatchGroup(patchGroup);
    }

    public ComponentReference(String name, String version, PatchGroupReference patchGroup, BugInfo bugInfo) {
        this(InventoryHelper.getInstance().create("component"));
        this.setName(name);
        this.setVersion(version);
        this.setPatchGroup(patchGroup);
        this.setBugInfo(bugInfo);
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public String getVersion() {
        return this.getStringAttribute("version");
    }

    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    public void setOracleHomeDiff(String oracleHomeDiff) {
        this.setAttribute("oh-diff", oracleHomeDiff);
    }

    public String getOracleHomeDiff() {
        return this.getStringAttribute("oh-diff");
    }

    public PatchGroupReference getPatchGroup() {
        return (PatchGroupReference)((Object)this.getSingleOccuranceComplexValueWrapped("patches", PatchGroupReference.class));
    }

    public void setPatchGroup(PatchGroupReference patchGroup) {
        this.setSingleOccuranceComplexValueWrapped("patches", (IDataHandlerWrapper)patchGroup);
    }

    public void setBugInfo(BugInfo bugInfo) {
        this.setSingleOccuranceComplexValueWrapped("bug-info", (IDataHandlerWrapper)bugInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !ComponentReference.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        ComponentReference reference = (ComponentReference)((Object)o);
        String name = this.getName();
        String version = this.getVersion();
        String otherName = reference.getName();
        String otherVersion = reference.getVersion();
        return !(name == null ? otherName != null : !name.equals(otherName)) && !(version == null ? otherVersion != null : !version.equals(otherVersion));
    }

    public int hashCode() {
        String name = this.getName();
        String version = this.getVersion();
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (version != null ? version.hashCode() : 0);
        return result;
    }

    public String toString() {
        String version = this.getVersion();
        if (version == null) {
            return this.getName();
        }
        return this.getName() + " " + version;
    }
}

