/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.ftr;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.ftr.FeatureSetDependency;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;

public class FeatureSetDependencies
extends AbstractDataHandlerWrapper {
    private Path _featureSetDependenciesPathLocation;
    private URL _featureSetDependenciesLocation;

    public FeatureSetDependencies(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public FeatureSetDependencies() {
        this(FeatureSetHelper.getInstance().create("feature-set-dependencies"));
    }

    public FeatureSetDependencies(ClassLoader classLoader) {
        this(FeatureSetHelper.getInstance(classLoader).create("feature-set-dependencies"));
    }

    public FeatureSetDependencies(String name, String version) {
        this();
        this.setName(name);
        this.setVersion(version);
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    private void setName(String name) {
        this.setAttribute("name", name);
    }

    public String getVersion() {
        return this.getStringAttribute("version");
    }

    private void setVersion(String version) {
        this.setAttribute("version", version);
    }

    public List<FeatureSetDependency> getFeatureSetDependencies() {
        return this.getComplexValueWrappedList("feature-set-dependency", FeatureSetDependency.class);
    }

    public void setFeatureSetDependencies(List<FeatureSetDependency> dependencies) {
        this.setComplexValueWrappedList("feature-set-dependency", dependencies);
    }

    public Path getFeatureSetDependenciesPathLocation() {
        return this._featureSetDependenciesPathLocation;
    }

    public File getFeatureSetDependenciesFileLocation() {
        return this._featureSetDependenciesPathLocation != null ? this._featureSetDependenciesPathLocation.toFile() : null;
    }

    public URL getFeatureSetDependenciesLocation() {
        return this._featureSetDependenciesLocation;
    }

    public void setFeatureSetDependenciesLocation(URL featureSetDependenciesLocation) throws GdrException {
        this._featureSetDependenciesLocation = featureSetDependenciesLocation;
        try {
            if ("jar".equals(featureSetDependenciesLocation.getProtocol())) {
                String path = featureSetDependenciesLocation.getPath();
                int index = path.indexOf("!");
                if (index != -1) {
                    path = path.substring(0, index);
                }
                this._featureSetDependenciesPathLocation = NioHelper.getInstance().getPath(new URI(path));
            } else {
                if (!"file".equals(featureSetDependenciesLocation.getProtocol())) {
                    throw new GdrException("Unsupported feature set dependencies location URL protocol " + featureSetDependenciesLocation);
                }
                this._featureSetDependenciesPathLocation = NioHelper.getInstance().getPath(featureSetDependenciesLocation.toURI());
            }
        }
        catch (URISyntaxException e) {
            throw new GdrException("Failed to convert URL to File " + featureSetDependenciesLocation, (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FeatureSetDependencies that = (FeatureSetDependencies)((Object)o);
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        String thatName = that.getName();
        String thatVersion = that.getVersion();
        return !(thisName == null ? thatName != null : !thisName.equals(thatName)) && !(thisVersion == null ? thatVersion != null : !thisVersion.equals(thatVersion));
    }

    public int hashCode() {
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        int result = thisName != null ? thisName.hashCode() : 0;
        result = 31 * result + (thisVersion != null ? thisVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getName() + " " + this.getVersion();
    }
}

