/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.ftr;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.DataHandlerHelper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyHolder;
import com.oracle.cie.dependency.dao.Dependency;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfo;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfoHolder;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.Components;
import com.oracle.cie.gdr.dao.ftr.FeatureLibrary;
import com.oracle.cie.gdr.dao.ftr.FeatureReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSetDependency;
import com.oracle.cie.gdr.dao.inv.DistributionReference;
import com.oracle.cie.gdr.dao.pom.PomArtifact;
import com.oracle.cie.gdr.dao.pom.PomFeaturesetDefinition;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureSet
extends AbstractDataHandlerWrapper
implements DependencyHolder,
ResourceBundleInfoHolder {
    private boolean _dummy;
    private Status _status = Status.notinstalled;
    private List<Components> _cachedComponentWrappers;
    private Path _featureSetPathLocation;
    private URL _featureSetLocation;
    private FeatureSet _superseded;
    private Collection<FeatureSet> _replaces;
    private Collection<Component> _removedComponents;
    private Map<DistributionReference, Collection<FeatureSet>> _removedDependencies;
    private Collection<FeatureSet> _upgrades;
    private Collection<FeatureSet> _upgradesInHome;
    private FeatureSet _originalFeatureSet;
    private FeatureSetDependency _featureSetDependency;
    private List<FeatureLibrary> _cachedFeatureLibraryWrappers;
    private Set<FeatureSet> _replacesDependencies;
    private Set<FeatureSet> _supersedingDependencies;
    private int _initialRefCount = 0;
    private boolean _external;
    private boolean _visible;
    private boolean _required;
    private boolean _selected;
    private boolean _generic = true;
    private boolean _upgradeInstalled;
    private boolean _isFullyInstalled;
    private ResourceBundleInfo _resourceBundleInfo;
    private Artifact _featureSetArtifact;

    public FeatureSet(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public FeatureSet() {
        this(FeatureSetHelper.getInstance().create("feature-set-def"));
    }

    public FeatureSet(ClassLoader classLoader) {
        this(FeatureSetHelper.getInstance(classLoader).create("feature-set-def"));
    }

    public FeatureSet(String name, String version) {
        this();
        this.setName(name);
        this.setVersion(version);
        this.setDisplayName(name);
    }

    public FeatureSet(String name, String version, ClassLoader classLoader) {
        this(classLoader);
        this.setName(name);
        this.setVersion(version);
        this.setDisplayName(name);
    }

    public void setFeatureRefAttributes(FeatureSetReference ref) {
        if (ref != null) {
            this.setVisible(ref.isVisible());
            this.setRequired(ref.isRequired());
            this.setExternal(ref.isExternal());
            this.setSelected(ref.isSelected());
            this.setGeneric(ref.isGeneric());
            this.setUpgradeInstalled(ref.isUpgradeInstalled());
        }
    }

    public File getFeatureSetFileLocation() {
        return this._featureSetPathLocation != null ? this._featureSetPathLocation.toFile() : null;
    }

    public Path getFeatureSetFileLocationPath() {
        return this._featureSetPathLocation;
    }

    public URL getFeatureSetLocation() {
        return this._featureSetLocation;
    }

    public void setFeatureSetLocation(URL featureSetLocation) throws GdrException {
        this._featureSetLocation = featureSetLocation;
        try {
            if ("jar".equals(featureSetLocation.getProtocol())) {
                String path = featureSetLocation.getPath();
                int index = path.indexOf("!");
                if (index != -1) {
                    path = path.substring(0, index);
                }
                this._featureSetPathLocation = NioHelper.getInstance().getPath(new URI(path));
            } else {
                if (!"file".equals(featureSetLocation.getProtocol())) {
                    throw new GdrException("Unsupported feature set location URL protocol " + featureSetLocation);
                }
                this._featureSetPathLocation = NioHelper.getInstance().getPath(featureSetLocation.toURI());
            }
        }
        catch (URISyntaxException e) {
            throw new GdrException("Failed to convert URL to File " + featureSetLocation, (Throwable)e);
        }
    }

    public List<Components> getComponents() {
        if (this._cachedComponentWrappers == null) {
            this._cachedComponentWrappers = this.getComplexValueWrappedList("components", Components.class);
        }
        return this._cachedComponentWrappers;
    }

    public void setComponents(List<Components> components) {
        this._cachedComponentWrappers = null;
        this.setComplexValueWrappedList("components", components);
    }

    public List<ComponentReference> getComponentReferences() {
        ArrayList<ComponentReference> componentReferences = new ArrayList<ComponentReference>();
        List<Components> components = this.getComponents();
        if (components != null && !components.isEmpty()) {
            for (Components comps : components) {
                List<ComponentReference> compRefs = comps.getComponentReferences();
                if (compRefs == null || compRefs.isEmpty()) continue;
                componentReferences.addAll(compRefs);
            }
        }
        return componentReferences;
    }

    public void setComponentReferences(List<ComponentReference> componentReferences) {
        ArrayList<Components> components = new ArrayList<Components>();
        Components comps = new Components(componentReferences);
        components.add(comps);
        this.setComponents(components);
    }

    public List<FeatureReference> getCompatibleFeatures() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("compatibility"), (String)"feature", FeatureReference.class);
    }

    public void setCompatibleFeatures(List<FeatureReference> featureReferences) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("compatibility", true), (String)"feature", featureReferences);
    }

    public void setFeatureSetDependency(FeatureSetDependency featureSetDependency) {
        this._featureSetDependency = featureSetDependency;
    }

    public FeatureSetDependency getFeatureSetDependency() {
        return this._featureSetDependency;
    }

    public boolean hasFeatureDependency() {
        return this._featureSetDependency != null;
    }

    public Dependency getDependency() {
        return this._featureSetDependency != null ? this._featureSetDependency.getDependency(false) : this.getDependency(false);
    }

    public Dependency getDependency(boolean create) {
        return (Dependency)this.getSingleOccuranceComplexValueWrapped("dependencies", Dependency.class, create);
    }

    public List<PomFeaturesetDefinition> getPoms() {
        return this.getComplexValueWrappedList("pom", PomFeaturesetDefinition.class);
    }

    public PomArtifact getDefaultPomOverride() {
        return (PomArtifact)this.getSingleOccuranceComplexValueWrapped("default-pom-override", PomArtifact.class);
    }

    public List<FeatureLibrary> getLibraries() {
        if (this._cachedFeatureLibraryWrappers == null) {
            this._cachedFeatureLibraryWrappers = DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("libraries"), (String)"library", FeatureLibrary.class);
        }
        return this._cachedFeatureLibraryWrappers;
    }

    public void setLibraries(List<FeatureLibrary> library) {
        this._cachedFeatureLibraryWrappers = null;
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("libraries", true), (String)"library", library);
    }

    @Override
    public String getName() {
        return this.getStringAttribute("name");
    }

    private void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public String getVersion() {
        return this.getStringAttribute("version");
    }

    private void setVersion(String version) {
        this.setAttribute("version", version);
    }

    public String getDisplayName() {
        return this.getStringAttribute("display-name");
    }

    public void setDisplayName(String displayName) {
        this.setAttribute("display-name", displayName);
    }

    public String getDisplayNameKey() {
        return this.getStringAttribute("display-name-key");
    }

    public void setDisplayNameKey(String displayNameKey) {
        this.setAttribute("display-name-key", displayNameKey);
    }

    public String getLocalizedDisplayName() {
        return ResourceBundleInfo.getLocalizedString(this.getResourceBundleInfo(), this.getDisplayNameKey(), this.getDisplayName());
    }

    public String getDescription() {
        return this.getStringAttribute("description");
    }

    public void setDescription(String description) {
        this.setAttribute("description", description);
    }

    public String getDescriptionKey() {
        return this.getStringAttribute("description-key");
    }

    public void setDescriptionKey(String descriptionKey) {
        this.setAttribute("description-key", descriptionKey);
    }

    public String getLocalizedDescription() {
        return ResourceBundleInfo.getLocalizedString(this.getResourceBundleInfo(), this.getDescriptionKey(), this.getDescription());
    }

    public boolean isMultiVersion() {
        return this.getBooleanAttribute("multi-version");
    }

    public void setMultiVersion(boolean multiVersion) {
        this.setAttribute("multi-version", multiVersion);
    }

    public String getRmProd() {
        return this.getStringAttribute("rm-prod");
    }

    public String getConsumptionType() {
        return this.getStringAttribute("consumption-type");
    }

    public void setConsumptionType(String consumptionType) {
        this.setAttribute("consumption-type", consumptionType);
    }

    public boolean isThirdParty() {
        return this.getBooleanAttribute("third-party");
    }

    public void setThirdParty(boolean thirdParty) {
        this.setAttribute("third-party", thirdParty);
    }

    public String getType() {
        return this.getStringAttribute("type");
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public String getSubType() {
        return this.getStringAttribute("sub-type");
    }

    public void setSubType(String subType) {
        this.setAttribute("sub-type", subType);
    }

    public boolean isSingleton() {
        return this.getBooleanAttribute("singleton");
    }

    public void setSingleton(boolean singleton) {
        this.setAttribute("singleton", singleton);
    }

    public boolean hasPomGen() {
        return this.getBooleanAttribute("pom-gen");
    }

    public void setPomGen(boolean pomGen) {
        this.setAttribute("pom-gen", pomGen);
    }

    public Artifact getFeatureSetArtifact() {
        return this._featureSetArtifact;
    }

    public void setFeatureSetArtifact(Artifact featureSetArtifact) {
        this._featureSetArtifact = featureSetArtifact;
    }

    public FeatureSet getSuperseded() {
        return this._superseded;
    }

    public void setSuperseded(FeatureSet superseded) {
        this._superseded = superseded;
    }

    public boolean isSuperseded() {
        return this._superseded != null;
    }

    public Set<FeatureSet> getSupersedingDependencies() {
        return this._supersedingDependencies;
    }

    public void setSupersedingDependencies(Set<FeatureSet> supersedingDependencies) {
        this._supersedingDependencies = supersedingDependencies;
    }

    public boolean hasSupersedingDependencies() {
        return this._supersedingDependencies != null && !this._supersedingDependencies.isEmpty();
    }

    public String getSupersededVersion() {
        return this._superseded != null ? this._superseded.getVersion() : null;
    }

    public Collection<FeatureSet> getReplaces() {
        return this._replaces;
    }

    public void setReplaces(Collection<FeatureSet> replaces) {
        this._replaces = replaces;
    }

    public void addReplaces(FeatureSet replaces) {
        if (this._replaces == null) {
            this._replaces = new HashSet<FeatureSet>();
        }
        this._replaces.add(replaces);
    }

    public Set<FeatureSet> getReplacesDependencies() {
        return this._replacesDependencies;
    }

    public void setReplacesDependencies(Set<FeatureSet> replacesDependencies) {
        this._replacesDependencies = replacesDependencies;
    }

    public boolean hasReplacesDependencies() {
        return this._replacesDependencies != null && !this._replacesDependencies.isEmpty();
    }

    public int getInitialRefCount() {
        return this._initialRefCount;
    }

    public void setInitialRefCount(int initialRefCount) {
        this._initialRefCount = initialRefCount;
    }

    public void incrementInitialRefCount() {
        ++this._initialRefCount;
    }

    public boolean hasReplaces() {
        return this._replaces != null && !this._replaces.isEmpty();
    }

    public Collection<Component> getRemovedComponents() {
        return this._removedComponents;
    }

    public void setRemovedComponents(Collection<Component> removedComponents) {
        this._removedComponents = removedComponents;
    }

    public void addRemovedComponent(Component removedComponent) {
        if (this._removedComponents == null) {
            this._removedComponents = new HashSet<Component>();
        }
        this._removedComponents.add(removedComponent);
    }

    public boolean hasRemovedComponents() {
        return this._removedComponents != null && !this._removedComponents.isEmpty();
    }

    public Collection<FeatureSet> getRemovedDependencies(DistributionReference distReference) {
        return this._removedDependencies.get((Object)distReference);
    }

    public void addRemovedDependency(DistributionReference distReference, FeatureSet removedDependency) {
        Collection<FeatureSet> dependencySet;
        if (this._removedDependencies == null) {
            this._removedDependencies = new HashMap<DistributionReference, Collection<FeatureSet>>();
        }
        if ((dependencySet = this._removedDependencies.get((Object)distReference)) == null) {
            dependencySet = new HashSet<FeatureSet>();
            this._removedDependencies.put(distReference, dependencySet);
        }
        dependencySet.add(removedDependency);
    }

    public boolean hasRemovedDependencies() {
        return this._removedDependencies != null && !this._removedDependencies.isEmpty();
    }

    public Collection<FeatureSet> getUpgrades() {
        if ((this._upgrades == null || this._upgrades.isEmpty()) && this.isUpgradesInHome()) {
            return this.getUpgradesInHome();
        }
        return this._upgrades;
    }

    public void setUpgrades(Collection<FeatureSet> upgrades) {
        this._upgrades = upgrades;
    }

    public void addUpgrades(FeatureSet upgrades) {
        if (this._upgrades == null) {
            this._upgrades = new HashSet<FeatureSet>();
        }
        this._upgrades.add(upgrades);
    }

    public boolean isUpgrades() {
        return this._upgrades != null && !this._upgrades.isEmpty() || this.isUpgradesInHome();
    }

    public FeatureSet getOriginalFeatureSet() {
        return this._originalFeatureSet;
    }

    public void setOriginalFeatureSet(FeatureSet original) {
        this._originalFeatureSet = original;
    }

    public boolean isOriginalSet() {
        return this._originalFeatureSet != null;
    }

    public Collection<FeatureSet> getUpgradesInHome() {
        return this._upgradesInHome;
    }

    public void setUpgradesInHome(Collection<FeatureSet> upgradesInHome) {
        this._upgradesInHome = upgradesInHome;
    }

    public void addUpgradesInHome(FeatureSet upgradesInHome) {
        if (this._upgradesInHome == null) {
            this._upgradesInHome = new HashSet<FeatureSet>();
        }
        this._upgradesInHome.add(upgradesInHome);
    }

    public boolean isUpgradesInHome() {
        return this._upgradesInHome != null && !this._upgradesInHome.isEmpty();
    }

    public void setExternal(boolean external) {
        this._external = external;
    }

    public boolean isExternal() {
        return this._external;
    }

    public boolean isDummy() {
        return this._dummy;
    }

    public void setDummy(boolean dummy) {
        this._dummy = dummy;
    }

    public void setSelected(boolean selected) {
        this._selected = selected;
    }

    public boolean isSelected() {
        return this._selected;
    }

    public boolean isRequired() {
        return this._required;
    }

    void setRequired(boolean required) {
        this._required = required;
    }

    public boolean isVisible() {
        return this._visible;
    }

    void setVisible(boolean visible) {
        this._visible = visible;
    }

    public Status getStatus() {
        return this._status;
    }

    public void setStatus(Status status) {
        this._status = status;
    }

    public boolean isGeneric() {
        return this._generic;
    }

    public void setGeneric(boolean generic) {
        this._generic = generic;
    }

    public boolean isUpgradeInstalled() {
        return this._upgradeInstalled;
    }

    public void setUpgradeInstalled(boolean upgradeInstalled) {
        this._upgradeInstalled = upgradeInstalled;
    }

    public boolean isFullyInstalled() {
        return this._isFullyInstalled;
    }

    public void setFullyInstalled(boolean fullyInstalled) {
        this._isFullyInstalled = fullyInstalled;
    }

    @Override
    public ResourceBundleInfo getResourceBundleInfo() {
        return this._resourceBundleInfo;
    }

    @Override
    public void setResourceBundleInfo(ResourceBundleInfo resourceBundleInfo) {
        this._resourceBundleInfo = resourceBundleInfo;
    }

    public boolean matchesReference(Reference ref) {
        return ref != null && ref.getName().equals(this.getName()) && ref.getVersion().equals(this.getVersion());
    }

    public FeatureSet copy() throws GdrException {
        FeatureSet copy = new FeatureSet(this.getDataHandler().copy());
        copy.setDummy(this.isDummy());
        copy.setStatus(this.getStatus());
        copy.setFeatureSetLocation(this.getFeatureSetLocation());
        copy.setSuperseded(this.getSuperseded());
        copy.setReplaces(this.getReplaces());
        copy.setUpgrades(this.getUpgrades());
        copy.setFeatureSetDependency(this.getFeatureSetDependency());
        copy.setExternal(this.isExternal());
        copy.setVisible(this.isVisible());
        copy.setRequired(this.isRequired());
        copy.setSelected(this.isSelected());
        copy.setGeneric(this.isGeneric());
        copy.setUpgradeInstalled(this.isUpgradeInstalled());
        copy.setFullyInstalled(this.isFullyInstalled());
        copy.setResourceBundleInfo(this.getResourceBundleInfo());
        copy._cachedComponentWrappers = this._cachedComponentWrappers;
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureSet that = (FeatureSet)o;
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        String thatName = that.getName();
        String thatVersion = that.getVersion();
        return !(thisName == null ? thatName != null : !thisName.equals(thatName)) && !(thisVersion == null ? thatVersion != null : !thisVersion.equals(thatVersion));
    }

    public int hashCode() {
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        int result = thisName != null ? thisName.hashCode() : 0;
        result = 31 * result + (thisVersion != null ? thisVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean useDisplayName) {
        String name;
        String string = name = useDisplayName ? this.getDisplayName() : null;
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            name = this.getName();
        }
        return name + " " + this.getVersion();
    }
}

