/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.dbd;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfo;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import java.util.List;

public class FeatureSetGroup
extends AbstractDataHandlerWrapper {
    private ResourceBundleInfo _resourceBundleInfo;

    public FeatureSetGroup(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public FeatureSetGroup() {
        this(DistributionHelper.getInstance().create("feature-set-group"));
    }

    public FeatureSetGroup(String name) {
        this();
        this.setName(name);
        this.setDisplayName(name);
    }

    public List<FeatureSetGroup> getFeatureSetGroups() {
        List featureSetGroups = this.getComplexValueWrappedList("feature-set-group", FeatureSetGroup.class);
        ResourceBundleInfo rbi = this.getResourceBundleInfo();
        if (rbi != null && featureSetGroups != null && !featureSetGroups.isEmpty()) {
            for (FeatureSetGroup featureSetGroup : featureSetGroups) {
                featureSetGroup.setResourceBundleInfo(rbi);
            }
        }
        return featureSetGroups;
    }

    public void setFeatureSetGroups(List<FeatureSetGroup> groups) {
        this.setComplexValueWrappedList("feature-set-group", groups);
    }

    public List<FeatureSetReference> getFeatures() {
        return this.getComplexValueWrappedList("feature-set", FeatureSetReference.class);
    }

    public void setFeatures(List<FeatureSetReference> features) {
        this.setComplexValueWrappedList("feature-set", features);
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public boolean isVisible() {
        return this.getBooleanAttribute("visible");
    }

    public String getDisplayName() {
        return this.getStringAttribute("display-name");
    }

    public void setDisplayName(String displayName) {
        this.setAttribute("display-name", displayName);
    }

    public String getDisplayNameKey() {
        return this.getStringAttribute("display-name-key");
    }

    public void setDisplayNameKey(String displayNameKey) {
        this.setAttribute("display-name-key", displayNameKey);
    }

    public String getLocalizedDisplayName() {
        return ResourceBundleInfo.getLocalizedString(this.getResourceBundleInfo(), this.getDisplayNameKey(), this.getDisplayName());
    }

    public String getDescription() {
        return this.getStringAttribute("description");
    }

    public void setDescription(String description) {
        this.setAttribute("description", description);
    }

    public String getDescriptionKey() {
        return this.getStringAttribute("description-key");
    }

    public void setDescriptionKey(String descriptionKey) {
        this.setAttribute("description-key", descriptionKey);
    }

    public String getLocalizedDescription() {
        return ResourceBundleInfo.getLocalizedString(this.getResourceBundleInfo(), this.getDescriptionKey(), this.getDescription());
    }

    public ResourceBundleInfo getResourceBundleInfo() {
        return this._resourceBundleInfo;
    }

    public void setResourceBundleInfo(ResourceBundleInfo resourceBundleInfo) {
        this._resourceBundleInfo = resourceBundleInfo;
    }

    public String toString() {
        String name = this.getDisplayName();
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            name = this.getName();
        }
        return name;
    }
}

