/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.dbd;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfo;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfoHolder;
import com.oracle.cie.gdr.dao.dbd.AuxiliaryDirectoryMap;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.dbd.InstallType;
import com.oracle.cie.gdr.dao.dbd.Mapping;
import com.oracle.cie.gdr.dao.dbd.RootMapping;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Distribution
extends AbstractDataHandlerWrapper
implements ResourceBundleInfoHolder {
    private ResourceBundleInfo _resourceBundleInfo;
    private Path _distributionFileLocation;
    private List<AuxiliaryDirectoryMap> _auxiliaryDirectoryMaps;
    private DirectoryMap _overrideDirectoryMap;
    private List<InstallType> _installTypes;
    private List<String> _productFamilies;
    private Artifact _distributionArtifact;

    public Distribution(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public Distribution() {
        this(DistributionHelper.getInstance().create("distribution"));
    }

    public Distribution(String name, String version) {
        this();
        this.setName(name);
        this.setVersion(version);
    }

    public List<String> getProductFamilies() {
        return this._productFamilies != null ? this._productFamilies : new ArrayList<String>();
    }

    public void setProductFamilies(List<String> productFamilies) {
        this._productFamilies = productFamilies;
    }

    public List<FeatureSetGroup> getFeatureSetGroups() {
        List featureSetGroups = this.getComplexValueWrappedList("feature-set-group", FeatureSetGroup.class);
        ResourceBundleInfo rbi = this.getResourceBundleInfo();
        if (rbi != null && featureSetGroups != null && !featureSetGroups.isEmpty()) {
            for (FeatureSetGroup featureSetGroup : featureSetGroups) {
                featureSetGroup.setResourceBundleInfo(rbi);
            }
        }
        return featureSetGroups;
    }

    public void setFeatureSetGroups(List<FeatureSetGroup> groups) {
        this.setComplexValueWrappedList("feature-set-group", groups);
    }

    public List<InstallType> getInstallType() {
        ResourceBundleInfo rbi;
        if (this._installTypes == null) {
            this._installTypes = this.getComplexValueWrappedList("install-type", InstallType.class);
            if (this._installTypes != null && !this._installTypes.isEmpty()) {
                for (InstallType installType : this._installTypes) {
                    LinkedHashSet<FeatureSetReference> fullFeatures = new LinkedHashSet<FeatureSetReference>();
                    Set<FeatureSetReference> distFeatures = DistributionHelper.getInstance().getFeatureSetReferences(this, true);
                    List<FeatureSetReference> installTypeFeatures = installType.getFeatures();
                    for (FeatureSetReference distFeature : distFeatures) {
                        int index = installTypeFeatures.indexOf((Object)distFeature);
                        if (index > -1) {
                            FeatureSetReference ref = new FeatureSetReference(distFeature.getDataHandler().copy());
                            ref.setSelected(installTypeFeatures.get(index).isSelected());
                            fullFeatures.add(ref);
                            continue;
                        }
                        fullFeatures.add(distFeature);
                    }
                    installType.setFullFeatures(fullFeatures);
                }
            }
        }
        if ((rbi = this.getResourceBundleInfo()) != null) {
            for (InstallType installType : this._installTypes) {
                installType.setResourceBundleInfo(rbi);
            }
        }
        return this._installTypes;
    }

    public DirectoryMap getDirectoryMap() {
        if (this._overrideDirectoryMap != null) {
            return this._overrideDirectoryMap;
        }
        return (DirectoryMap)((Object)this.getSingleOccuranceComplexValueWrapped("directory-map", DirectoryMap.class));
    }

    public void setOverrideDirectoryMap(DirectoryMap directoryMap) {
        this._overrideDirectoryMap = directoryMap;
    }

    public void setDirectoryMap(DirectoryMap dirMap) {
        this.setSingleOccuranceComplexValueWrapped("directory-map", (IDataHandlerWrapper)dirMap);
    }

    public List<AuxiliaryDirectoryMap> getAuxiliaryDirectoryMaps() {
        if (this._auxiliaryDirectoryMaps == null) {
            DirectoryMap directoryMap;
            this._auxiliaryDirectoryMaps = this.getComplexValueWrappedList("auxiliary-directory-map", AuxiliaryDirectoryMap.class);
            if (this._auxiliaryDirectoryMaps != null && !this._auxiliaryDirectoryMaps.isEmpty() && (directoryMap = this.getDirectoryMap()) != null) {
                List<Mapping> mappings = directoryMap.getMappings();
                for (AuxiliaryDirectoryMap auxiliaryDirectoryMap : this._auxiliaryDirectoryMaps) {
                    RootMapping auxiliaryRootMapping;
                    if (mappings != null && !mappings.isEmpty()) {
                        List<Mapping> auxiliaryMappings = auxiliaryDirectoryMap.getMappings();
                        if (auxiliaryMappings == null || auxiliaryMappings.isEmpty()) {
                            auxiliaryDirectoryMap.setMappings(mappings);
                        } else {
                            for (Mapping auxiliaryMapping : auxiliaryMappings) {
                                auxiliaryMapping.setDirectoryMapName(auxiliaryDirectoryMap.getName());
                            }
                            for (Mapping mapping : mappings) {
                                boolean found = false;
                                String directory = mapping.getDirectory();
                                for (Mapping auxiliaryMapping : auxiliaryMappings) {
                                    if (!auxiliaryMapping.getDirectory().equalsIgnoreCase(directory)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                auxiliaryDirectoryMap.addMapping(mapping);
                            }
                        }
                    }
                    if ((auxiliaryRootMapping = auxiliaryDirectoryMap.getRootMapping()) == null) {
                        RootMapping rootMapping = directoryMap.getRootMapping();
                        if (rootMapping == null) continue;
                        auxiliaryDirectoryMap.setRootMapping(rootMapping);
                        continue;
                    }
                    auxiliaryRootMapping.setDirectoryMapName(auxiliaryDirectoryMap.getName());
                }
            }
        }
        return this._auxiliaryDirectoryMaps;
    }

    @Override
    public String getName() {
        return this.getStringAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public String getVersion() {
        return this.getStringAttribute("version");
    }

    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    public String getExternalName() {
        return this.getStringAttribute("external-name");
    }

    public void setExternalName(String value) {
        this.setAttribute("external-name", value);
    }

    public String getExternalNameKey() {
        return this.getStringAttribute("external-name-key");
    }

    public void setExternalNameKey(String value) {
        this.setAttribute("external-name-key", value);
    }

    public String getLocalizedExternalName() {
        return ResourceBundleInfo.getLocalizedString(this.getResourceBundleInfo(), this.getExternalNameKey(), this.getExternalName());
    }

    public String getDescriptionKey() {
        return this.getStringAttribute("description-key");
    }

    public void setDescriptionKey(String value) {
        this.setAttribute("description-key", value);
    }

    public String getLocalizedDescription() {
        return ResourceBundleInfo.getLocalizedString(this.getResourceBundleInfo(), this.getDescriptionKey(), this.getName());
    }

    public String getExternalShortName() {
        return this.getStringAttribute("external-shortname");
    }

    public void setExternalShortName(String value) {
        this.setAttribute("external-shortname", value);
    }

    public String getExternalShortNameKey() {
        return this.getStringAttribute("external-shortname-key");
    }

    public void setExternalShortNameKey(String value) {
        this.setAttribute("external-shortname-key", value);
    }

    public String getLocalizedExternalShortName() {
        return ResourceBundleInfo.getLocalizedString(this.getResourceBundleInfo(), this.getExternalShortNameKey(), this.getExternalShortName());
    }

    public String getExternalVersion() {
        return this.getStringAttribute("external-version");
    }

    public void setExternalVersion(String value) {
        this.setAttribute("external-version", value);
    }

    public Artifact getDistributionArtifact() {
        return this._distributionArtifact;
    }

    public void setDistributionArtifact(Artifact distributionArtifact) {
        this._distributionArtifact = distributionArtifact;
    }

    @Override
    public ResourceBundleInfo getResourceBundleInfo() {
        return this._resourceBundleInfo;
    }

    @Override
    public void setResourceBundleInfo(ResourceBundleInfo resourceBundleInfo) {
        this._resourceBundleInfo = resourceBundleInfo;
    }

    public boolean hasPomGen() {
        return this.getBooleanAttribute("pom-gen", true);
    }

    public void setPomGen(boolean pomGen) {
        this.setAttribute("pom-gen", pomGen);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Distribution that = (Distribution)o;
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        String thatName = that.getName();
        String thatVersion = that.getVersion();
        return !(thisName == null ? thatName != null : !thisName.equals(thatName)) && !(thisVersion == null ? thatVersion != null : !thisVersion.equals(thatVersion));
    }

    public int hashCode() {
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        int result = thisName != null ? thisName.hashCode() : 0;
        result = 31 * result + (thisVersion != null ? thisVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean useDisplayValues) {
        String version;
        String name;
        String string = name = useDisplayValues ? this.getExternalName() : null;
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            name = this.getName();
        }
        String string2 = version = useDisplayValues ? this.getExternalVersion() : null;
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            version = this.getVersion();
        }
        return name + " " + version;
    }

    public File getDistributionFileLocation() {
        return this._distributionFileLocation != null ? this._distributionFileLocation.toFile() : null;
    }

    public Path getDistributionFileLocationPath() {
        return this._distributionFileLocation;
    }

    public void setDistributionFileLocation(File distributionFileLocation) {
        this._distributionFileLocation = NioHelper.getInstance().getPath(distributionFileLocation);
    }

    public void setDistributionFileLocation(Path distributionFileLocation) {
        this._distributionFileLocation = distributionFileLocation;
    }
}

