/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cpd;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.DataHandlerHelper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.dao.cpd.Directory;
import com.oracle.cie.gdr.dao.cpd.File;
import com.oracle.cie.gdr.dao.cpd.FileModifier;
import com.oracle.cie.gdr.dao.cpd.IncludeExclude;
import com.oracle.cie.gdr.dao.cpd.Modifier;
import com.oracle.cie.gdr.dao.cpd.Permission;
import com.oracle.cie.gdr.dao.cpd.RepoDirectory;
import com.oracle.cie.gdr.dao.cpd.RepoFile;
import com.oracle.cie.gdr.dao.cpd.RepoFileSet;
import com.oracle.cie.gdr.dao.cpd.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class FileGroup
extends AbstractDataHandlerWrapper {
    public FileGroup(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public List<File> getFiles() {
        return this.getComplexValueWrappedList("file", File.class);
    }

    public void setFiles(List<File> files) {
        this.setComplexValueWrappedList("file", files);
    }

    public File addFile() {
        return new File(this.getDataHandler().addComplexValue("file"));
    }

    public void addFile(File file) {
        this.getDataHandler().addComplexValue("file", file.getDataHandler());
    }

    public List<RepoFile> getRepoFiles() {
        return this.getComplexValueWrappedList("repo-file", RepoFile.class);
    }

    public void setRepoFiles(List<RepoFile> files) {
        this.setComplexValueWrappedList("repo-file", files);
    }

    public List<RepoFileSet> getRepoFileSet() {
        return this.getComplexValueWrappedList("repo-file-set", RepoFileSet.class);
    }

    public void setRepoFileSets(List<RepoFileSet> repoFileSets) {
        this.setComplexValueWrappedList("repo-file-set", repoFileSets);
    }

    public List<RepoDirectory> getRepoDirectories() {
        return this.getComplexValueWrappedList("repo-directory", RepoDirectory.class);
    }

    public void setRepoDirectories(List<RepoDirectory> directories) {
        this.setComplexValueWrappedList("repo-directory", directories);
    }

    public List<Directory> getDirectories() {
        return this.getComplexValueWrappedList("directory", Directory.class);
    }

    public void setDirectories(List<Directory> directories) {
        this.setComplexValueWrappedList("directory", directories);
    }

    public Directory addDirectory() {
        return new Directory(this.getDataHandler().addComplexValue("directory"));
    }

    public void addDirectory(Directory directory) {
        this.getDataHandler().addComplexValue("directory", directory.getDataHandler());
    }

    public List<Rule> getRules() {
        return this.getComplexValueWrappedList("rule", Rule.class);
    }

    public void setRules(List<Rule> rules) {
        this.setComplexValueWrappedList("rule", rules);
    }

    public List<Permission> getPermissions() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("file-perms"), (String)"permission", Permission.class);
    }

    public void setPermissions(List<Permission> permissions) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("file-perms", true), (String)"permission", permissions);
    }

    public List<IncludeExclude> getIncludes() {
        return this.getComplexValueWrappedList("include", IncludeExclude.class);
    }

    public void setIncludes(List<IncludeExclude> includes) {
        this.setComplexValueWrappedList("include", includes);
    }

    public List<IncludeExclude> getExcludes() {
        return this.getComplexValueWrappedList("exclude", IncludeExclude.class);
    }

    public void setExcludes(List<IncludeExclude> excludes) {
        this.setComplexValueWrappedList("exclude", excludes);
    }

    public List<Modifier> getModifiers() {
        return this.getComplexValueWrappedList("modifier", Modifier.class);
    }

    public void setModifiers(List<Modifier> modifiers) {
        this.setComplexValueWrappedList("modifier", modifiers);
    }

    public void setFileModifiers(List<FileModifier> fileModifiers) {
        ArrayList<Modifier> modifiers = null;
        if (fileModifiers != null && !fileModifiers.isEmpty()) {
            modifiers = new ArrayList<Modifier>();
            for (FileModifier fileModifier : fileModifiers) {
                Modifier modifier = new Modifier(this.getDataHandler().createComplexValue("modifier"));
                modifier.setType(fileModifier.getType());
                modifiers.add(modifier);
            }
        }
        this.setModifiers(modifiers);
    }

    public void setFileTargets(Collection<FileTarget> fileTargets) {
        if (fileTargets != null && !fileTargets.isEmpty()) {
            ArrayList<Directory> directories = new ArrayList<Directory>();
            ArrayList<File> files = new ArrayList<File>();
            for (FileTarget fileTarget : fileTargets) {
                AbstractDataHandlerWrapper m;
                Set<String> modifiers;
                if (fileTarget.isDirectory()) {
                    Directory directory = new Directory();
                    directory.setSource(fileTarget.getSource());
                    directory.setDest(fileTarget.getDest());
                    directory.setMode(fileTarget.getMode());
                    directory.setArtifact(fileTarget.getArtifact());
                    directory.setGroup(fileTarget.getGroup());
                    directory.setType(fileTarget.getType());
                    directory.setId(fileTarget.getId());
                    directory.setClassifier(fileTarget.getClassifier());
                    directory.setBaseVersion(fileTarget.getBaseVersion());
                    directory.setVersion(fileTarget.getVersion());
                    modifiers = fileTarget.getModifiers();
                    if (modifiers != null && !modifiers.isEmpty()) {
                        ArrayList<Modifier> directoryModifiers = new ArrayList<Modifier>();
                        for (String modifier : modifiers) {
                            m = new Modifier(directory.getDataHandler().createComplexValue("modifier"));
                            m.setType(modifier);
                            directoryModifiers.add((Modifier)m);
                        }
                        directory.setModifiers(directoryModifiers);
                    }
                    directories.add(directory);
                    continue;
                }
                File file = new File();
                file.setAction(fileTarget.getAction());
                if (fileTarget.isSymlink()) {
                    file.setSymlink(fileTarget.getSource());
                } else {
                    file.setSource(fileTarget.getSource());
                }
                file.setDest(fileTarget.getDest());
                file.setMode(fileTarget.getMode());
                file.setArtifact(fileTarget.getArtifact());
                file.setGroup(fileTarget.getGroup());
                file.setType(fileTarget.getType());
                file.setId(fileTarget.getId());
                file.setClassifier(fileTarget.getClassifier());
                file.setBaseVersion(fileTarget.getBaseVersion());
                file.setVersion(fileTarget.getVersion());
                modifiers = fileTarget.getModifiers();
                if (modifiers != null && !modifiers.isEmpty()) {
                    ArrayList<FileModifier> fileModifiers = new ArrayList<FileModifier>();
                    for (String modifier : modifiers) {
                        m = new FileModifier(file.getDataHandler().createComplexValue("modifier"));
                        m.setType(modifier);
                        fileModifiers.add((FileModifier)m);
                    }
                    file.setModifiers(fileModifiers);
                }
                files.add(file);
            }
            this.setDirectories(directories);
            this.setFiles(files);
        }
    }

    public void clear() {
        this.setDirectories(null);
        this.setFiles(null);
        this.setRules(null);
    }
}

