/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cpd;

import com.oracle.cie.common.Version;
import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.DataHandlerHelper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfo;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfoHolder;
import com.oracle.cie.gdr.dao.cpd.ArtifactFile;
import com.oracle.cie.gdr.dao.cpd.BugInfo;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.cpd.Library;
import com.oracle.cie.gdr.dao.cpd.LocationFile;
import com.oracle.cie.gdr.dao.cpd.Permission;
import com.oracle.cie.gdr.dao.cpd.PomReference;
import com.oracle.cie.gdr.dao.cpd.Stringsubs;
import com.oracle.cie.gdr.dao.cpd.Variable;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.pch.Patch;
import com.oracle.cie.gdr.dao.pom.PomArtifact;
import com.oracle.cie.gdr.dao.pom.PomGroup;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.services.RepositoryService;
import com.oracle.cie.gdr.services.VariableResolverService;
import com.oracle.cie.nextgen.common.inputs.dao.variables.VariableDao;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Component
extends AbstractDataHandlerWrapper
implements ResourceBundleInfoHolder {
    private Collection<ComponentTarget> _targets;
    private Collection<Component> _componentExtensions;
    private List<Patch> _cachedPatchWrappers;
    private List<Variable> _cachedVariables;
    private Path _compDefLocation;
    private Path _archiveLocation;
    private ComponentReference _componentReference;
    private int _disk = 1;
    private boolean isFullyInstalled;
    private ResourceBundleInfo _resourceBundleInfo;
    private boolean _extension;
    private ComponentReference _superseded;
    private Collection<Component> _replaces;
    private boolean _omitted;
    private boolean _carb;
    private boolean _flattenedCarb;
    private boolean _unstaged;
    private Artifact _carbArtifact;
    private Artifact _componentInfoArtifact;
    private Path _componentInfoFile;
    private RepositoryService _repositoryService;

    public Component(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public Component(String name, String version) {
        this(ComponentHelper.getInstance().create("component-def"));
        this.setName(name);
        this.setVersion(version);
    }

    public Component(String name, String version, ClassLoader classLoader) {
        this(ComponentHelper.getInstance(classLoader).create("component-def"));
        this.setName(name);
        this.setVersion(version);
    }

    public List<FileMap> getFileMaps() {
        return this.getComplexValueWrappedList("file-map", FileMap.class);
    }

    public void setFileMaps(List<FileMap> fileMaps) {
        this.setComplexValueWrappedList("file-map", fileMaps);
    }

    public void addFileMap(FileMap filemap) {
        this.getDataHandler().addComplexValue("file-map", filemap.getDataHandler());
    }

    public List<Patch> getPatches() {
        return this._cachedPatchWrappers;
    }

    public void setPatches(List<Patch> patches) {
        this._cachedPatchWrappers = patches;
    }

    public List<Permission> getPermissions() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("file-perms"), (String)"permission", Permission.class);
    }

    public void setPermissions(List<Permission> permissions) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("file-perms", true), (String)"permission", permissions);
    }

    public List<Variable> getVariables() {
        if (this._cachedVariables == null) {
            this._cachedVariables = DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("variables"), (String)"variable", Variable.class);
        }
        return this._cachedVariables;
    }

    public List<VariableDao> getProductVariables() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("variables"), (String)"product-variable", VariableDao.class);
    }

    public void setVariables(List<Variable> variables) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("variables", true), (String)"variable", variables);
        this._cachedVariables = null;
    }

    public List<PomGroup> getPomGroups() {
        return this.getComplexValueWrappedList("pom-group", PomGroup.class);
    }

    public List<LocationFile> getLocationFiles() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("artifact-pom-overrides"), (String)"location-file", LocationFile.class);
    }

    public List<PomReference> getSuppressPoms() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("artifact-pom-overrides"), (String)"suppress-pom", PomReference.class);
    }

    public List<PomReference> getStaticPoms() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("artifact-pom-overrides"), (String)"static-pom", PomReference.class);
    }

    public PomArtifact getDefaultPomOverride() {
        return (PomArtifact)this.getSingleOccuranceComplexValueWrapped("default-pom-override", PomArtifact.class);
    }

    public List<Library> getLibraries() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("libraries"), (String)"library", Library.class);
    }

    public void setLibraries(List<Library> library) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("libraries", true), (String)"library", library);
    }

    public Stringsubs getStringsubs() {
        return (Stringsubs)((Object)this.getSingleOccuranceComplexValueWrapped("stringsubs", Stringsubs.class));
    }

    public void setStringsubs(Stringsubs stringsubs) {
        this.setSingleOccuranceComplexValueWrapped("stringsubs", (IDataHandlerWrapper)stringsubs);
    }

    public boolean hasStringsubs() {
        return this.getStringsubs() != null;
    }

    @Override
    public String getName() {
        return this.getStringAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public String getVersion() {
        return this.getStringAttribute("version");
    }

    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    public String getPatchLevel() {
        return this.getStringAttribute("patch-level");
    }

    public void setPatchLevel(String patchLevel) {
        this.setAttribute("patch-level", patchLevel);
    }

    public Version getGdrVersion() {
        String version = this.getStringAttribute("gdr-version");
        return StringUtil.isNullOrEmpty((String)version, (boolean)true) ? null : new Version(version);
    }

    public void setGdrVersion(String version) {
        this.setAttribute("gdr-version", version);
    }

    public String getGroupId() {
        return this.getStringAttribute("groupId");
    }

    public void setGroupId(String groupId) {
        this.setAttribute("groupId", groupId);
    }

    public String getDescription() {
        return this.getStringAttribute("description");
    }

    public void setDescription(String description) {
        this.setAttribute("description", description);
    }

    public String getDescriptionKey() {
        return this.getStringAttribute("description-key");
    }

    public void setDescriptionKey(String descriptionKey) {
        this.setAttribute("description-key", descriptionKey);
    }

    public String getLocalizedDescription() {
        return ResourceBundleInfo.getLocalizedString(this.getResourceBundleInfo(), this.getDescriptionKey(), this.getDescription());
    }

    public boolean isReplicable() {
        return this.getBooleanAttribute("replicable");
    }

    public void setReplicable(boolean replicable) {
        this.setAttribute("replicable", replicable);
    }

    public String getType() {
        return this.getStringAttribute("type");
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public boolean isSingleton() {
        return this.getBooleanAttribute("singleton");
    }

    public void setSingleton(boolean singleton) {
        this.setAttribute("singleton", singleton);
    }

    public String getPomGen() {
        return this.getStringAttribute("pom-gen");
    }

    public void setPomGen(String pomGen) {
        this.setAttribute("pom-gen", pomGen);
    }

    public Collection<ComponentTarget> getComponentTargets() {
        return this._targets;
    }

    public void setComponentTargets(Collection<ComponentTarget> targets) {
        this._targets = targets;
        this.initComponentObjectStore();
    }

    public Collection<Component> getComponentExtensions() {
        return this._componentExtensions;
    }

    public void setComponentExtensions(Collection<Component> componentExtensions) {
        this._componentExtensions = componentExtensions;
    }

    public boolean hasComponentExtensions() {
        return this._componentExtensions != null && !this._componentExtensions.isEmpty();
    }

    public File getArchiveLocation() {
        Path archiveLocation = this.getArchiveLocationPath();
        return archiveLocation != null ? archiveLocation.toFile() : null;
    }

    public Path getArchiveLocationPath() {
        Collection<ComponentTarget> targets;
        Path archiveLocation = null;
        if (this.isExtension() && (targets = this.getComponentTargets()) != null && !targets.isEmpty()) {
            Iterator<ComponentTarget> it = targets.iterator();
            while (it.hasNext() && archiveLocation == null) {
                archiveLocation = it.next().getArchiveLocationPath(false);
            }
        }
        return archiveLocation == null ? this._archiveLocation : archiveLocation;
    }

    public void setArchiveLocation(File archiveLocation) {
        this.setArchiveLocation(NioHelper.getInstance().getPath(archiveLocation));
    }

    public void setArchiveLocation(Path archiveLocation) {
        this._archiveLocation = archiveLocation;
    }

    public boolean isComponentArchive() {
        return this._archiveLocation != null;
    }

    public File getCompDefLocation() {
        return this._compDefLocation != null ? this._compDefLocation.toFile() : null;
    }

    public Path getCompDefLocationPath() {
        return this._compDefLocation;
    }

    public void setCompDefLocation(File compDefLocation) {
        this.setCompDefLocation(NioHelper.getInstance().getPath(compDefLocation));
    }

    public void setCompDefLocation(Path compDefLocation) {
        this._compDefLocation = compDefLocation;
    }

    public ComponentReference getComponentReference() {
        return this._componentReference;
    }

    public void setComponentReference(ComponentReference componentReference) {
        this._componentReference = componentReference;
    }

    public Status getStatus() {
        return this._componentReference != null ? this._componentReference.getStatus() : Status.notinstalled;
    }

    public ComponentReference getSuperseded() {
        return this._superseded;
    }

    public void setSuperseded(ComponentReference superseded) {
        this._superseded = superseded;
    }

    public boolean isSuperseded() {
        return this._superseded != null;
    }

    public String getSupersededVersion() {
        return this._superseded != null ? this._superseded.getVersion() : null;
    }

    public Collection<Component> getReplaces() {
        return this._replaces;
    }

    public void setReplaces(Collection<Component> replaces) {
        this._replaces = replaces;
    }

    public void addReplaces(Component replaces) {
        if (this._replaces == null) {
            this._replaces = new HashSet<Component>();
        }
        this._replaces.add(replaces);
    }

    public boolean hasReplaces() {
        return this._replaces != null && !this._replaces.isEmpty();
    }

    public boolean isOmitted() {
        return this._omitted;
    }

    public void setOmitted(boolean omitted) {
        this._omitted = omitted;
    }

    public int getDisk() {
        return this._disk;
    }

    public void setDisk(int disk) {
        this._disk = disk;
    }

    public boolean isFullyInstalled() {
        return this.isFullyInstalled;
    }

    public void setFullyInstalled(boolean fullyInstalled) {
        this.isFullyInstalled = fullyInstalled;
    }

    public boolean isExtension() {
        return this._extension;
    }

    public void setExtension(boolean extension) {
        this._extension = extension;
    }

    public boolean isCarb() {
        return this._carb;
    }

    public void setCarb(boolean carb) {
        this._carb = carb;
    }

    public boolean isFlattenedCarb() {
        return this._flattenedCarb;
    }

    public void setFlattenedCarb(boolean flattenedCarb) {
        this._flattenedCarb = flattenedCarb;
    }

    public boolean isUnstaged() {
        return this._unstaged;
    }

    public void setUnstaged(boolean unstaged) {
        this._unstaged = unstaged;
    }

    public void setCarbArtifact(Artifact carb) {
        this._carb = this._carb || carb != null;
        this._carbArtifact = carb;
    }

    public Artifact getCarbArtifact() {
        return this._carbArtifact;
    }

    public Artifact getComponentInfoArtifact() {
        return this._componentInfoArtifact;
    }

    public void setComponentInfoArtifact(Artifact componentInfoArtifact) {
        this._componentInfoArtifact = componentInfoArtifact;
    }

    public File getComponentInfoFile() {
        return this._componentInfoFile != null ? this._componentInfoFile.toFile() : null;
    }

    public Path getComponentInfoFilePath() {
        return this._componentInfoFile;
    }

    public void setComponentInfoFile(File componentInfoFile) {
        this.setComponentInfoFile(NioHelper.getInstance().getPath(componentInfoFile));
    }

    public void setComponentInfoFile(Path componentInfoFile) {
        this._componentInfoFile = componentInfoFile;
    }

    @Override
    public ResourceBundleInfo getResourceBundleInfo() {
        return this._resourceBundleInfo;
    }

    @Override
    public void setResourceBundleInfo(ResourceBundleInfo resourceBundleInfo) {
        this._resourceBundleInfo = resourceBundleInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component that = (Component)o;
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        String thatName = that.getName();
        String thatVersion = that.getVersion();
        return !(thisName == null ? thatName != null : !thisName.equals(thatName)) && !(thisVersion == null ? thatVersion != null : !thisVersion.equals(thatVersion));
    }

    public int hashCode() {
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        int result = thisName != null ? thisName.hashCode() : 0;
        result = 31 * result + (thisVersion != null ? thisVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getName() + " " + this.getVersion();
    }

    public String getNamespace() {
        return this.getName() + "_" + this.getVersion();
    }

    public BugInfo getBugInfo() {
        return (BugInfo)((Object)this.getSingleOccuranceComplexValueWrapped("bug-info", BugInfo.class));
    }

    public void setBugInfo(BugInfo bugInfo) {
        this.setSingleOccuranceComplexValueWrapped("bug-info", (IDataHandlerWrapper)bugInfo);
    }

    protected void initComponentObjectStore() {
        VariableResolverService varService = VariableResolverService.getVariableResolverService();
        IObjectStore objectStore = varService.getObjectStore(this.getNamespace());
        Map<String, String> variables = ComponentHelper.getInstance().getComponentVariables(this, varService);
        if (variables != null && !variables.isEmpty()) {
            objectStore.storeAll(variables);
        }
        objectStore.removeObject((Object)"SRCHOME");
    }

    public Component copy() {
        Component copy = new Component(this.getDataHandler().copy());
        copy.setComponentTargets(this.getComponentTargets());
        copy.setComponentExtensions(this.getComponentExtensions());
        copy.setCompDefLocation(this.getCompDefLocationPath());
        copy.setArchiveLocation(this.getArchiveLocationPath());
        copy.setComponentReference(this.getComponentReference());
        copy.setDisk(this.getDisk());
        copy.setResourceBundleInfo(this.getResourceBundleInfo());
        copy.setRepositoryService(this.getRepositoryService());
        copy.setExtension(this.isExtension());
        copy.setSuperseded(this.getSuperseded());
        copy.setReplaces(this.getReplaces());
        copy.setOmitted(this.isOmitted());
        copy.setCarb(this.isCarb());
        copy.setFlattenedCarb(this.isFlattenedCarb());
        copy.setCarbArtifact(this.getCarbArtifact());
        copy.setComponentInfoArtifact(this.getComponentInfoArtifact());
        copy.setComponentInfoFile(this.getComponentInfoFilePath());
        copy.setUnstaged(this.isUnstaged());
        return copy;
    }

    public RepositoryService getRepositoryService() {
        return this._repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this._repositoryService = repositoryService;
    }

    public List<ArtifactFile> getFileTypeMapping() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("file-type-map"), (String)"file-type", ArtifactFile.class);
    }

    public void setFileTypeMapping(List<ArtifactFile> artifactFiles) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("file-type-map", true), (String)"file-type", artifactFiles);
    }
}

