/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cin;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.DataHandlerHelper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.cin.Home;
import com.oracle.cie.gdr.helpers.CentralInventoryHelper;
import java.util.List;

public class CentralInventory
extends AbstractDataHandlerWrapper {
    public CentralInventory(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public CentralInventory() {
        this(CentralInventoryHelper.getInstance().create("INVENTORY"));
        this.setCompositeHomeList();
    }

    public void setSavedWith(String savedWith) {
        this.setSingleOccurrenceChildSimpleValue("VERSION_INFO", "SAVED_WITH", savedWith);
    }

    public void setMinimumVer(String minimumVer) {
        this.setSingleOccurrenceChildSimpleValue("VERSION_INFO", "MINIMUM_VER", minimumVer);
    }

    public void setCompositeHomeList() {
        this.setSimpleValue("COMPOSITEHOME_LIST", "");
    }

    public void setVersionInfo(String savedWith, String minimumVer) {
        this.setSavedWith(savedWith);
        this.setMinimumVer(minimumVer);
    }

    public List<Home> getHomes() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("HOME_LIST"), (String)"HOME", Home.class);
    }

    private void setHomes(List<Home> homes) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("HOME_LIST", true), (String)"HOME", homes);
    }

    public void addHome(Home newHome) {
        List<Home> homes = this.getHomes();
        int idx = this.getHighestIdx(homes);
        newHome.setIdx(idx + 1 + "");
        homes.add(newHome);
        this.setHomes(homes);
    }

    public void removeHome(Home home) {
        List<Home> homes = this.getHomes();
        homes.remove((Object)home);
        this.setHomes(homes);
    }

    public int getHighestIdx() {
        return this.getHighestIdx(this.getHomes());
    }

    private int getHighestIdx(List<Home> homes) {
        int idx = 0;
        for (Home home : homes) {
            if (home == null || home.isRemoved() || Integer.parseInt(home.getIdx()) <= idx) continue;
            idx = Integer.parseInt(home.getIdx());
        }
        return idx;
    }
}

