/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff.integrity;

import com.oracle.cie.common.util.DiffReport;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.JarUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.carbdiff.CarbDiffException;
import com.oracle.cie.gdr.carbdiff.FileDiffResolver;
import com.oracle.cie.gdr.carbdiff.ReplacementResolver;
import com.oracle.cie.gdr.dao.bic.BuildIntegrity;
import com.oracle.cie.gdr.dao.pad.TextFileDiffFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class BuildIntegrityResolver
implements FileDiffResolver {
    private static Logger _logger = Logger.getLogger(ReplacementResolver.class.getName());
    private BuildIntegrity _buildIntegrity;

    public BuildIntegrityResolver(BuildIntegrity buildIntegrity) {
        this._buildIntegrity = buildIntegrity;
    }

    private boolean isSmaller(long originalSize, long modifiedSize) {
        return originalSize > 0L && modifiedSize < originalSize - originalSize * Long.valueOf(this._buildIntegrity.getSizeReduction()) / 100L;
    }

    @Override
    public Collection<FileTarget> diffFiles(Map<String, FileTarget> releaseFileTargets, Map<String, FileTarget> patchFileTargets) throws CarbDiffException {
        ArrayList<FileTarget> diffTargets = new ArrayList<FileTarget>();
        try {
            for (Map.Entry<String, FileTarget> entry : patchFileTargets.entrySet()) {
                String dest = entry.getKey();
                FileTarget patchFileTarget = entry.getValue();
                FileTarget releaseFileTarget = releaseFileTargets.get(dest);
                if (!patchFileTarget.isDirectory() && (releaseFileTarget == null || this.isSmaller(releaseFileTarget.getSize(), patchFileTarget.getSize()))) {
                    if (releaseFileTarget == null) {
                        if (this.isEmpty(patchFileTarget.getSource())) continue;
                        patchFileTarget.setStatus(FileTarget.STATUS_ADDED);
                        diffTargets.add(patchFileTarget);
                        continue;
                    }
                    if (!this.isSmaller(releaseFileTarget.getSize(), patchFileTarget.getSize()) || this.isEmpty(patchFileTarget.getSource())) continue;
                    patchFileTarget.setStatus(FileTarget.STATUS_REDUCED);
                    _logger.finest("File " + patchFileTarget.getDest() + " is reduced.");
                    diffTargets.add(patchFileTarget);
                    continue;
                }
                releaseFileTargets.remove(releaseFileTarget.getDest());
            }
            if (!releaseFileTargets.isEmpty()) {
                String deletedName = null;
                String newName = null;
                for (FileTarget deletedFileTarget : releaseFileTargets.values()) {
                    deletedName = !StringUtil.isNullOrEmpty((String)deletedFileTarget.getSource()) ? this.getName(deletedFileTarget.getSource()) : this.getName(deletedFileTarget.getDest());
                    for (FileTarget newTarget : diffTargets) {
                        if (!newTarget.getStatus().equals(FileTarget.STATUS_ADDED)) continue;
                        newName = !StringUtil.isNullOrEmpty((String)newTarget.getSource()) ? this.getName(newTarget.getSource()) : this.getName(newTarget.getDest());
                        if (deletedName.equals(newName)) {
                            releaseFileTargets.remove(deletedFileTarget.getDest());
                            _logger.finest("File " + newTarget.getDest() + " is moved.");
                            newTarget.setStatus(FileTarget.STATUS_MOVED);
                            continue;
                        }
                        _logger.finest("File " + newTarget.getDest() + " is added.");
                    }
                }
                for (FileTarget deletedFileTarget : releaseFileTargets.values()) {
                    deletedFileTarget.setStatus(FileTarget.STATUS_DELETED);
                    _logger.finest("File " + deletedFileTarget.getDest() + " is deleted.");
                    diffTargets.add(deletedFileTarget);
                }
            }
        }
        catch (Exception exception) {
            throw new CarbDiffException(exception);
        }
        return diffTargets;
    }

    private String getName(String fullPath) {
        int nameIndex = fullPath.lastIndexOf("/") + 1;
        String name = fullPath.substring(nameIndex);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmpty(String source) throws IOException {
        if (StringUtil.isNullOrEmpty((String)source)) {
            return true;
        }
        if (!JarUtils.isArchive((File)new File(source))) {
            return false;
        }
        boolean isEmpty = true;
        try (JarHelper jarHelper = new JarHelper(source);){
            for (String entry : jarHelper.getEntries()) {
                if (jarHelper.getJarEntry(entry).isDirectory()) continue;
                if (JarUtils.isArchive((JarHelper)jarHelper, (String)entry)) {
                    File innerJar = JarUtils.extractIntoTempFile((JarHelper)jarHelper, (String)entry);
                    innerJar.deleteOnExit();
                    isEmpty = this.isEmpty(innerJar.getCanonicalPath());
                    continue;
                }
                isEmpty = false;
            }
        }
        return isEmpty;
    }

    @Override
    public void setTextFileDiffFilter(TextFileDiffFilter textFileDiffFilter) {
    }

    @Override
    public void setReleaseDataFile(File releaseDataFile) {
    }

    @Override
    public void setPatchDataFile(File carbDataFile) {
    }

    @Override
    public void setBaseFilteredArchives(Map<String, File> filteredArchives) {
    }

    @Override
    public void setPatchedFilteredArchives(Map<String, File> filteredArchives) {
    }

    @Override
    public void setDiffReport(DiffReport report) {
    }

    @Override
    public void setIncludeParentClass(boolean includeParentClass) {
    }

    @Override
    public void setIncludedManifest(List<String> includedManifest) {
    }

    @Override
    public List<FileTarget> getFileTargetsToDelete() {
        return null;
    }

    @Override
    public boolean hasFilesToDelete() {
        return false;
    }
}

