/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.dependency.mgmt.impl.VersionImpl;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.pad.Artifact;
import com.oracle.cie.gdr.dao.pad.ArtifactInfoOverride;
import com.oracle.cie.gdr.dao.pad.FeatureInfoOverride;
import com.oracle.cie.gdr.dao.pad.PatchArtifactDefinition;
import com.oracle.cie.gdr.helpers.PatchArtifactDefinitionHelper;
import com.oracle.cie.gdr.utils.ComponentArchiveUtils;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class PatchArtifactDefinitionProcessor {
    private static final PatchArtifactDefinitionProcessor _instance = new PatchArtifactDefinitionProcessor();
    private static final Logger _logger = Logger.getLogger(PatchArtifactDefinitionProcessor.class.getName());

    private PatchArtifactDefinitionProcessor() {
    }

    public static PatchArtifactDefinitionProcessor getInstance() {
        return _instance;
    }

    public PatchArtifactDefinition mergeIntoPartialPatchArtifactDefinition(Map<Component, Collection<PatchArtifactDefinition>> compPadMap) throws GdrException {
        HashMap<Reference, Collection<PatchArtifactDefinition>> compRefPadMap = null;
        if (compPadMap != null && !compPadMap.isEmpty()) {
            compRefPadMap = new HashMap<Reference, Collection<PatchArtifactDefinition>>();
            for (Map.Entry<Component, Collection<PatchArtifactDefinition>> entry : compPadMap.entrySet()) {
                compRefPadMap.put(new Reference(entry.getKey().getName(), entry.getKey().getVersion()), entry.getValue());
            }
        }
        return this.mergeIntoPartialPatchArtifactDefinition(compRefPadMap, true);
    }

    public PatchArtifactDefinition mergeIntoPartialPatchArtifactDefinition(Map<Reference, Collection<PatchArtifactDefinition>> compRefPadMap, boolean addMissingEntries) throws GdrException {
        PatchArtifactDefinition patchDef = null;
        _logger.finest("Merging pad into a partial pad with only rules.");
        if (compRefPadMap != null && !compRefPadMap.isEmpty()) {
            patchDef = new PatchArtifactDefinition();
            patchDef.setCarbInfos(new ArrayList());
            for (Map.Entry<Reference, Collection<PatchArtifactDefinition>> entry : compRefPadMap.entrySet()) {
                for (PatchArtifactDefinition pad : entry.getValue()) {
                    if (StringUtil.isNullOrEmpty((String)patchDef.getBaseBug()) && !StringUtil.isNullOrEmpty((String)pad.getBaseBug())) {
                        _logger.finest("Overriding base bug with " + pad.getBaseBug());
                        patchDef.setBaseBug(pad.getBaseBug());
                    }
                    if (StringUtil.isNullOrEmpty((String)patchDef.getRelease()) && !StringUtil.isNullOrEmpty((String)pad.getRelease())) {
                        _logger.finest("Overriding release with " + pad.getRelease());
                        patchDef.setRelease(pad.getRelease());
                    }
                    if (StringUtil.isNullOrEmpty((String)patchDef.getPlatform()) && !StringUtil.isNullOrEmpty((String)pad.getPlatform())) {
                        _logger.finest("Overriding platform with " + pad.getPlatform());
                        patchDef.setPlatform(pad.getPlatform());
                    }
                    for (ArtifactInfoOverride carbInfo : pad.getCarbInfos()) {
                        _logger.finest("Merging details of " + entry.getKey().toString());
                        Artifact patchedArtifact = carbInfo.getPatchedArtifact();
                        Artifact baseArtifact = carbInfo.getBaseArtifact();
                        if (!addMissingEntries) continue;
                        if (carbInfo.getBaseArtifact() == null) {
                            _logger.finest("Adding details of component to base artifact: " + entry.getKey().toString());
                            baseArtifact = new Artifact();
                            baseArtifact.setArtifactId(entry.getKey().getName());
                            baseArtifact.setVersion(entry.getKey().getVersion());
                            carbInfo.setBaseArtifact(baseArtifact);
                        } else {
                            _logger.finest("Using existing base carb as " + baseArtifact.getGroupId() + ":" + baseArtifact.getArtifactId() + ":" + baseArtifact.getVersion());
                        }
                        if (carbInfo.getPatchedArtifact() == null) {
                            _logger.finest("Adding details of component to patched artifact: " + entry.getKey().toString());
                            patchedArtifact = new Artifact();
                            patchedArtifact.setArtifactId(entry.getKey().getName());
                            patchedArtifact.setVersion(entry.getKey().getVersion());
                            patchedArtifact.setGroupId(carbInfo.getBaseArtifact().getGroupId());
                            carbInfo.setPatchedArtifact(patchedArtifact);
                            continue;
                        }
                        _logger.finest("Using existing patched carb as " + patchedArtifact.getGroupId() + ":" + patchedArtifact.getArtifactId() + ":" + patchedArtifact.getVersion());
                    }
                    List<ArtifactInfoOverride> carbInfos = patchDef.getCarbInfos();
                    List<FeatureInfoOverride> featureInfos = patchDef.getFeatureSetInfos();
                    carbInfos.addAll(pad.getCarbInfos());
                    if (featureInfos == null) {
                        featureInfos = new ArrayList<FeatureInfoOverride>();
                    }
                    if (pad.getFeatureSetInfos() != null) {
                        featureInfos.addAll(pad.getFeatureSetInfos());
                    }
                    patchDef.setCarbInfos(carbInfos);
                    patchDef.setFeatureSetInfos(featureInfos);
                }
            }
        }
        _logger.fine("Created partial pad with the following content:" + (Object)((Object)patchDef));
        return patchDef;
    }

    private void validatePatchArtifactDefinitions(Map<Component, Collection<PatchArtifactDefinition>> compPadMap) throws GdrException {
        String baseBug = null;
        String release = null;
        _logger.info("Validating patch artifact definitions.");
        for (Map.Entry<Component, Collection<PatchArtifactDefinition>> entry : compPadMap.entrySet()) {
            for (PatchArtifactDefinition pad : entry.getValue()) {
                if (StringUtil.isNullOrEmpty((String)pad.getBaseBug())) {
                    throw new GdrException("The base bug for carb " + entry.getKey() + " can not be empty.");
                }
                if (StringUtil.isNullOrEmpty((String)pad.getRelease())) {
                    throw new GdrException("The release for carb " + entry.getKey() + " can not be empty.");
                }
                if (StringUtil.isNullOrEmpty(baseBug)) {
                    baseBug = pad.getBaseBug();
                }
                if (StringUtil.isNullOrEmpty(release)) {
                    release = pad.getRelease();
                }
                if (!baseBug.equals(pad.getBaseBug())) {
                    throw new GdrException("The base bug for carb " + entry.getKey() + " does not match.");
                }
                if (release.equals(pad.getRelease())) continue;
                throw new GdrException("The release for carb " + entry.getKey() + " does not match.");
            }
        }
    }

    private PatchArtifactDefinition getPatchArtifactDefinition(Component component) throws IOException, DataHandlerException, GdrException {
        File pad;
        _logger.finest("Searching for patch artifact def in component " + component.toString());
        if (component.getCompDefLocation() != null && (pad = new File(component.getCompDefLocation().getParentFile(), "patch-artifact-def.xml")) != null && pad.exists()) {
            _logger.finest("Patch artifact definition found in :" + pad.getAbsolutePath());
            return this.mergePad(component, (PatchArtifactDefinition)PatchArtifactDefinitionHelper.getInstance().getRootWrapper(pad));
        }
        return this.generateDefaultPad(component);
    }

    private PatchArtifactDefinition mergePad(Component component, PatchArtifactDefinition pad) throws GdrException {
        _logger.fine("Merging rules for pad.");
        LinkedHashMap idToFileMap = new LinkedHashMap();
        for (ArtifactInfoOverride carbInfo : pad.getCarbInfos()) {
            if (carbInfo.getBaseArtifact() != null) continue;
            Artifact artifact = new Artifact();
            if (component.isExtension()) {
                FileMap fileMap = component.getFileMaps().iterator().next();
                Set<String> locales = fileMap.getLocales();
                String id = ComponentArchiveUtils.getTargetIdentifier(fileMap.getPlatforms(true, false), locales);
                artifact.setGroupId("com.oracle.cie.gdr.carb." + id);
            } else {
                artifact.setGroupId("com.oracle.cie.gdr.carb");
            }
            artifact.setArtifactId(component.getName());
            carbInfo.setBaseArtifact(artifact);
        }
        return pad;
    }

    private PatchArtifactDefinition generateDefaultPad(Component component) throws GdrException {
        _logger.fine("Generating default pad.");
        PatchArtifactDefinition defaultPad = new PatchArtifactDefinition();
        ArrayList<ArtifactInfoOverride> artifacts = new ArrayList<ArtifactInfoOverride>();
        ArtifactInfoOverride defaultCarbInfo = new ArtifactInfoOverride();
        Artifact baseArtifact = new Artifact();
        baseArtifact.setArtifactId(component.getName());
        baseArtifact.setVersion(component.getVersion());
        if (component.isExtension()) {
            FileMap fileMap = component.getFileMaps().iterator().next();
            Set<String> locales = fileMap.getLocales();
            String id = ComponentArchiveUtils.getTargetIdentifier(fileMap.getPlatforms(true, false), locales);
            baseArtifact.setGroupId("com.oracle.cie.gdr.carb." + id);
        } else {
            baseArtifact.setGroupId("com.oracle.cie.gdr.carb");
        }
        defaultCarbInfo.setBaseArtifact(baseArtifact);
        artifacts.add(defaultCarbInfo);
        defaultPad.setCarbInfos(artifacts);
        return defaultPad;
    }

    protected com.oracle.cie.dependency.mgmt.Artifact retrieveLatestArtifact(String groupId, String artifactId, String version, String type) throws RestException {
        Object repoCommonConfig = null;
        RestHandler restHandler = RestFactory.getRestHandler();
        List<Repository> repositories = Arrays.asList(repoCommonConfig.getRepositories());
        Version latestVersion = restHandler.latestVersionSearch(groupId, artifactId, version + "-*", repositories);
        return DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.version", "release-version-def", latestVersion, "xml");
    }

    public Map<Component, Collection<PatchArtifactDefinition>> getComponentPadMap(File dir, Collection<Component> comps) throws GdrException, IOException, DataHandlerException {
        HashMap<Component, Collection<PatchArtifactDefinition>> compPadMap = new HashMap<Component, Collection<PatchArtifactDefinition>>();
        if (comps != null && !comps.isEmpty()) {
            _logger.finest("Searching for pads next to component definition.");
            for (Component component : comps) {
                component = component.copy();
                PatchArtifactDefinition pad = this.getPatchArtifactDefinition(component);
                this.addPad(component, pad, compPadMap);
                if (component.getComponentExtensions() == null) continue;
                _logger.finest("The component " + component.toString() + " has extensions, searching for pads.");
                for (Component compExt : component.getComponentExtensions()) {
                    pad = this.getPatchArtifactDefinition(compExt);
                    this.addPad(component, pad, compPadMap);
                }
            }
        }
        return compPadMap;
    }

    private void addPad(Component component, PatchArtifactDefinition pad, Map<Component, Collection<PatchArtifactDefinition>> compPadMap) {
        if (pad != null) {
            Collection<Object> pads = null;
            if (!compPadMap.containsKey(component)) {
                pads = new LinkedHashSet();
                compPadMap.put(component, pads);
            } else {
                pads = compPadMap.get(component);
            }
            _logger.finest("Found pad for component: " + component.toString() + " with the following content: " + pad.toString());
            pads.add((Object)pad);
        }
    }

    public void processPatchArtifactDefinitions(File dir, Collection<Component> comps) throws GdrException, IOException, DataHandlerException {
        Map<Component, Collection<PatchArtifactDefinition>> compPadMap = this.getComponentPadMap(dir, comps);
        PatchArtifactDefinition partiallyMergedPatchDef = PatchArtifactDefinitionProcessor.getInstance().mergeIntoPartialPatchArtifactDefinition(compPadMap);
        if (null != partiallyMergedPatchDef) {
            if (!dir.exists() && !dir.mkdirs()) {
                GdrException ex = new GdrException("Directory specified did not exist and could not be created: " + dir);
                _logger.throwing(PatchArtifactDefinitionProcessor.class.getName(), "processPatchArtifactDefinitions", ex);
                throw ex;
            }
            if (!dir.isDirectory()) {
                GdrException ex = new GdrException("Directory specified was not a directory: " + dir);
                _logger.throwing(PatchArtifactDefinitionProcessor.class.getName(), "processPatchArtifactDefinitions", ex);
                throw ex;
            }
            File pad = new File(dir, "patch-artifact-def.xml");
            _logger.info("Generating partial merged patch artifact definition: " + pad.getAbsolutePath());
            PatchArtifactDefinitionHelper.getInstance().save((IDataHandlerWrapper)partiallyMergedPatchDef, pad);
        } else {
            _logger.info("No partial patch artifact definition was generated.");
        }
    }

    public PatchArtifactDefinition generateFinalPatchArtifactDefinition(String stageLocation, String versionQualifier, String baseBug, String release, String platform, Collection<com.oracle.cie.dependency.mgmt.Artifact> baseCarbs, String componentsIncluded, String componentsExcluded) throws DataHandlerException, IOException {
        _logger.info("Generating final patch artifact definition.");
        PatchArtifactDefinition stagedPatchDef = this.getStagedPatchArtifactDefinition(stageLocation);
        if (stagedPatchDef != null) {
            if (!StringUtil.isNullOrEmpty((String)baseBug) && StringUtil.isNullOrEmpty((String)stagedPatchDef.getBaseBug())) {
                stagedPatchDef.setBaseBug(baseBug);
            }
            if (!StringUtil.isNullOrEmpty((String)release) && StringUtil.isNullOrEmpty((String)stagedPatchDef.getRelease())) {
                stagedPatchDef.setRelease(release);
            }
            if (!StringUtil.isNullOrEmpty((String)platform) && StringUtil.isNullOrEmpty((String)stagedPatchDef.getPlatform())) {
                stagedPatchDef.setPlatform(platform);
            }
            List<ArtifactInfoOverride> carbInfos = stagedPatchDef.getCarbInfos();
            int carbInfosSize = carbInfos.size();
            Iterator<ArtifactInfoOverride> it = stagedPatchDef.getCarbInfos().iterator();
            while (it.hasNext()) {
                ArtifactInfoOverride carbInfo = it.next();
                if (!this.isIncluded(componentsIncluded, componentsExcluded, false, carbInfo)) {
                    it.remove();
                    continue;
                }
                Artifact patchedArtifact = new Artifact();
                if (baseCarbs != null) {
                    for (com.oracle.cie.dependency.mgmt.Artifact baseCarb : baseCarbs) {
                        VersionImpl version = new VersionImpl(carbInfo.getBaseArtifact().getVersion());
                        if (version.getQualifierCount() != 0 || !baseCarb.getName().equals(carbInfo.getBaseArtifact().getArtifactId()) || !baseCarb.getGroup().equals(carbInfo.getBaseArtifact().getGroupId()) || !baseCarb.getVersion().getBaseVersion().equals(version.getBaseVersion())) continue;
                        carbInfo.getBaseArtifact().setVersion(baseCarb.getVersion().toString());
                    }
                }
                patchedArtifact.setGroupId(carbInfo.getBaseArtifact().getGroupId());
                patchedArtifact.setArtifactId(carbInfo.getBaseArtifact().getArtifactId());
                VersionImpl baseVersion = new VersionImpl(carbInfo.getBaseArtifact().getVersion());
                VersionImpl patchedVersion = new VersionImpl(baseVersion.getBaseVersion(), new String[]{versionQualifier});
                patchedArtifact.setVersion(patchedVersion.toString());
                carbInfo.setPatchedArtifact(patchedArtifact);
            }
            if (carbInfosSize != carbInfos.size()) {
                stagedPatchDef.setCarbInfos(carbInfos);
            }
        }
        _logger.fine("Created final pad with the following content: " + (Object)((Object)stagedPatchDef));
        return stagedPatchDef;
    }

    private boolean isIncluded(String componentsIncluded, String componentsExcluded, boolean reverse, ArtifactInfoOverride carbInfo) {
        boolean emptyIncludes = StringUtil.isNullOrEmpty((String)componentsIncluded);
        boolean emptyExcludes = StringUtil.isNullOrEmpty((String)componentsExcluded);
        if (emptyIncludes && emptyExcludes) {
            return true;
        }
        boolean included = new Boolean(emptyIncludes);
        String componentName = carbInfo.getBaseArtifact().getArtifactId();
        String componentVersion = new VersionImpl(carbInfo.getBaseArtifact().getVersion()).getBaseVersion();
        if (reverse) {
            if (this.hasComponent(componentsExcluded, componentName, componentVersion)) {
                included = false;
            }
            if (emptyIncludes || this.hasComponent(componentsIncluded, componentName, componentVersion)) {
                included = true;
            }
        } else {
            if (emptyIncludes || this.hasComponent(componentsIncluded, componentName, componentVersion)) {
                included = true;
            }
            if (this.hasComponent(componentsExcluded, componentName, componentVersion)) {
                included = false;
            }
        }
        return included;
    }

    private boolean hasComponent(String componentsList, String componentName, String componentVersion) {
        if (StringUtil.isNullOrEmpty((String)componentsList)) {
            return false;
        }
        String[] components = componentsList.split(",");
        String[] compNameVer = null;
        for (String component : components) {
            compNameVer = component.split(":");
            if (!compNameVer[0].equals(componentName) || !compNameVer[1].equals(componentVersion)) continue;
            return true;
        }
        return false;
    }

    public PatchArtifactDefinition getStagedPatchArtifactDefinition(String stageLocation) throws IOException, DataHandlerException {
        File mergedPatchDef;
        if (!StringUtil.isNullOrEmpty((String)stageLocation) && (mergedPatchDef = new File(stageLocation, "patch-artifact-def.xml")).exists()) {
            return (PatchArtifactDefinition)PatchArtifactDefinitionHelper.getInstance().getRootWrapper(mergedPatchDef);
        }
        return null;
    }
}

