/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff;

import com.oracle.cie.common.util.JarDiff;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.JarUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.carbdiff.CarbDiffException;
import com.oracle.cie.gdr.carbdiff.CarbDiffUtils;
import com.oracle.cie.gdr.carbdiff.DefaultCarbDiffHandler;
import com.oracle.cie.gdr.carbdiff.FileMapFilterer;
import com.oracle.cie.gdr.carbdiff.Strategy;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.Directory;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class FilteredCarbDiffHandler
extends DefaultCarbDiffHandler {
    private static final Logger _log = Logger.getLogger(FilteredCarbDiffHandler.class.getName());
    private FileMapFilterer _fileMapFilterer;
    private Map<String, FileTarget> _baseFileTargets = new HashMap<String, FileTarget>();
    private Map<String, FileTarget> _deltaFileTargets = new HashMap<String, FileTarget>();

    public FilteredCarbDiffHandler(Strategy strategy, File deltaCarbDestination, String platform, boolean excludeGeneric, Map<String, File> releaseDataFiles, Map<String, File> patchedDataFiles) {
        super(strategy, deltaCarbDestination, platform, excludeGeneric, releaseDataFiles, patchedDataFiles);
    }

    @Override
    public boolean diff(Component releaseComponent, Component patchComponent) throws CarbDiffException {
        if (this._fileMapFilterer == null) {
            return false;
        }
        this._fileMapFilterer.setDataFilesMap(this._patchedDataFiles);
        try {
            this._deltaFileMaps = this._fileMapFilterer.apply(patchComponent, CarbDiffUtils.filterFileMaps(patchComponent.getFileMaps(), this.getPlatform(), this.excludeGeneric()), this._deltaCarbDestination);
            if (this._deltaFileMaps.isEmpty()) {
                _log.info("There was no file map in the component " + releaseComponent + " that match the platform " + this._platform + " or the filters defined in this component.");
            }
        }
        catch (IOException e) {
            throw new CarbDiffException(e);
        }
        if (this._deltaFileMaps.isEmpty()) {
            return false;
        }
        this.extractSources(this._deltaFileMaps);
        this.loadFileTargets(releaseComponent, patchComponent, this._deltaFileMaps);
        this.configureFileMaps(this._deltaFileMaps);
        return true;
    }

    private void configureFileMaps(List<FileMap> filtered) throws CarbDiffException {
        for (FileMap fileMap : filtered) {
            File dataFile = (File)this._patchedDataFiles.get(fileMap.getSource());
            JarHelper dataFileArchiveHelper = null;
            try {
                dataFileArchiveHelper = new JarHelper(dataFile);
                this.configureFiles(dataFileArchiveHelper, fileMap.getFiles(), FileUtils.formatPath(this._deltaCarbDestination.getAbsolutePath(), "/"));
                this.configureDirectories(dataFileArchiveHelper, fileMap.getDirectories(), FileUtils.formatPath(this._deltaCarbDestination.getAbsolutePath(), "/"));
            }
            catch (IOException ioException) {
                CarbDiffException exception = new CarbDiffException("Error while configuring file maps ", ioException);
                _log.throwing(this.getClass().getCanonicalName(), "configureFileMaps", (Throwable)((Object)exception));
                throw exception;
            }
            finally {
                if (dataFileArchiveHelper == null) continue;
                dataFileArchiveHelper.close();
            }
        }
    }

    protected void extractSources(List<FileMap> filtered) throws CarbDiffException {
        JarHelper jarHelper = null;
        for (FileMap fileMap : filtered) {
            try {
                jarHelper = new JarHelper((File)this._patchedDataFiles.get(fileMap.getSource()));
                for (String entry : jarHelper.getEntries()) {
                    if (!this._strategy.isReplacement() && !this._strategy.isReplacementInUse() && (!this._strategy.isInjection() || this._fileMapFilterer.getFilteredArchives().containsKey(entry))) continue;
                    _log.finest("Extracting " + this._deltaCarbDestination + File.separator + entry);
                    jarHelper.extract(entry, this._deltaCarbDestination + File.separator + entry);
                }
            }
            catch (IOException ioException) {
                throw new CarbDiffException(ioException);
            }
            finally {
                if (jarHelper == null) continue;
                jarHelper.close();
            }
        }
    }

    private void configureFiles(JarHelper dataFileArchiveHelper, List<com.oracle.cie.gdr.dao.cpd.File> files, String source) throws CarbDiffException {
        for (com.oracle.cie.gdr.dao.cpd.File file : files) {
            try {
                Strategy strategy = this.getStrategy();
                if (this.isNew(file, source)) {
                    _log.finest("Entry " + file.getDest() + " is a newly added file so marking as replacement.");
                    strategy = Strategy.Replacement;
                } else if (strategy.isInjection()) {
                    if (!JarUtils.isArchive((JarHelper)dataFileArchiveHelper, (String)file.getDest())) {
                        _log.finest("Entry " + file.getDest() + " has changed so marking as replacement.");
                        strategy = Strategy.Replacement;
                    } else {
                        JarDiff jarDiff = new JarDiff(new File(source, file.getDest()));
                        String dest = source.replace("//", "/");
                        File tmpReleaseJar = JarUtils.extractIntoTempFile((JarHelper)dataFileArchiveHelper, (String)((dest = dest.replace(FileUtils.formatPath(this._deltaCarbDestination.getAbsolutePath(), "/") + "/", "")) + "/" + file.getDest()));
                        if (tmpReleaseJar != null) {
                            jarDiff.setReplacementFlag(strategy.isReplacement());
                            jarDiff.diff(true, new File[]{tmpReleaseJar});
                            tmpReleaseJar.deleteOnExit();
                            if (jarDiff.isCompleteReplacement() || jarDiff.isSignedJar()) {
                                strategy = Strategy.Replacement;
                            }
                        }
                    }
                }
                file.setAction(strategy.getXmlName());
                if (!StringUtil.isNullOrEmpty((String)file.getJarEntry())) {
                    file.setSource(this.getDestination().getCanonicalPath() + File.separator + file.getJarEntry());
                    continue;
                }
                file.setSource(source + File.separator + file.getDest());
            }
            catch (IOException ioException) {
                throw new CarbDiffException(ioException);
            }
            catch (Exception exception) {
                throw new CarbDiffException(exception);
            }
        }
    }

    private void configureFiles(JarHelper dataFileArchiveHelper, Directory directory, String source) throws CarbDiffException {
        if (directory.getFiles() == null) {
            return;
        }
        this.configureFiles(dataFileArchiveHelper, directory.getFiles(), source + "/" + directory.getDest());
    }

    private void configureDirectories(JarHelper dataFileArchiveHelper, List<Directory> directories, String source) throws CarbDiffException {
        for (Directory directory : directories) {
            this.configureFiles(dataFileArchiveHelper, directory, source);
            this.configureDirectories(dataFileArchiveHelper, directory.getDirectories(), source + "/" + directory.getDest());
        }
    }

    private boolean isNew(com.oracle.cie.gdr.dao.cpd.File file, String dest) {
        String key = "";
        dest = dest.replace("//", "/");
        key = (dest = dest.replace(FileUtils.formatPath(this._deltaCarbDestination.getAbsolutePath(), "/") + "/", "")) + "/" + file.getDest();
        return !this._baseFileTargets.containsKey(key);
    }

    @Override
    public FileMapFilterer getFileMapFilterer() {
        return this._fileMapFilterer;
    }

    @Override
    public void setFileMapFilterer(FileMapFilterer _fileMapFilterer) {
        this._fileMapFilterer = _fileMapFilterer;
    }

    private void loadFileTargets(Component baseComponent, Component patchComponent, List<FileMap> deltaFileMaps) throws CarbDiffException {
        Component deltaComponent = patchComponent.copy();
        deltaComponent.setFileMaps(deltaFileMaps);
        for (FileMap fileMap : deltaComponent.getFileMaps()) {
            this._deltaFileTargets.putAll(ComponentHelper.getInstance().getCarbDiffFileTargets(deltaComponent, fileMap));
        }
        for (FileMap fileMap : baseComponent.getFileMaps()) {
            this._baseFileTargets.putAll(ComponentHelper.getInstance().getCarbDiffFileTargets(baseComponent, fileMap));
        }
    }
}

