/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff;

import com.oracle.cie.common.util.ArchiveFilter;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.JarUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.carbdiff.CarbDiffException;
import com.oracle.cie.gdr.carbdiff.CarbDiffUtils;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.Directory;
import com.oracle.cie.gdr.dao.cpd.FileGroup;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.pad.FileBase;
import com.oracle.cie.gdr.dao.pad.IncludeExclude;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class FileMapFilterer {
    private static Logger _logger = Logger.getLogger(FileMapFilterer.class.getName());
    private IncludeExclude _include;
    private IncludeExclude _exclude;
    private Map<String, File> _dataFilesMap;
    private File _destination;
    private Map<String, File> _filteredArchives;
    private static Map<String, List<com.oracle.cie.gdr.dao.pad.File>> _appliedRules;
    private static Map<String, List<com.oracle.cie.gdr.dao.pad.File>> _matchedRules;
    private List<com.oracle.cie.gdr.dao.pad.File> _allRules;
    private List<String> _forcedFiles;
    private List<String> _includedManifest;
    private boolean _isExplicitInclude = false;
    private boolean _isReversed = false;
    private static String ALL_CONTENT_REGEX;

    public boolean isReversed() {
        return this._isReversed;
    }

    public void setReversed(boolean isReversed) {
        this._isReversed = isReversed;
    }

    public FileMapFilterer(IncludeExclude include, IncludeExclude exclude) {
        this._include = include;
        this._exclude = exclude;
        if (this._include != null && (this._include.getFiles() != null && !this._include.getFiles().isEmpty() || this._include.getDirectories() != null && !this._include.getDirectories().isEmpty())) {
            this._isExplicitInclude = true;
        }
    }

    public List<FileMap> apply(Component component, List<FileMap> fileMaps, File destination) throws IOException, CarbDiffException {
        _logger.info("Applying file map filter using as destination " + destination.getCanonicalPath() + " for filtered content.");
        if (fileMaps == null || this._dataFilesMap == null) {
            _logger.info("There is no content to filter.");
            return null;
        }
        this._destination = destination;
        this._filteredArchives = new HashMap<String, File>();
        this._includedManifest = new ArrayList<String>();
        ArrayList<FileMap> filtered = new ArrayList<FileMap>();
        this._forcedFiles = new ArrayList<String>();
        if (this._exclude != null || this._include != null) {
            _appliedRules = new TreeMap<String, List<com.oracle.cie.gdr.dao.pad.File>>();
            _matchedRules = new TreeMap<String, List<com.oracle.cie.gdr.dao.pad.File>>();
            this._allRules = new ArrayList<com.oracle.cie.gdr.dao.pad.File>();
        }
        _logger.finest("Filtering file maps.");
        for (FileMap fileMap : fileMaps) {
            FileMap tempFileMap = this.filterSingleFileMap(component, fileMap);
            if (tempFileMap == null) continue;
            _logger.finest("Adding filtering file map " + fileMap.toString());
            filtered.add(tempFileMap);
        }
        this.clearPendingRules();
        _logger.finest("Finished filtering file maps.");
        if (filtered.isEmpty()) {
            _logger.finest("All file map content has been filtered out. There are no file maps to process for component: " + component);
        }
        return filtered;
    }

    private StringBuilder buildIncludeRegex(IncludeExclude _include) throws CarbDiffException {
        StringBuilder regex = new StringBuilder();
        if (_include != null) {
            ArrayList<com.oracle.cie.gdr.dao.pad.File> files = new ArrayList<com.oracle.cie.gdr.dao.pad.File>();
            Stack<com.oracle.cie.gdr.dao.pad.Directory> directoryPaths = new Stack<com.oracle.cie.gdr.dao.pad.Directory>();
            for (com.oracle.cie.gdr.dao.pad.Directory directory : _include.getDirectories()) {
                directoryPaths.push(directory);
            }
            while (!directoryPaths.isEmpty()) {
                com.oracle.cie.gdr.dao.pad.Directory directory = (com.oracle.cie.gdr.dao.pad.Directory)((Object)directoryPaths.pop());
                String dest = null;
                if (!StringUtil.isNullOrEmpty((String)directory.getWildcard()) && (dest = directory.getWildcard()).contains("*")) {
                    dest = dest.replace("*", ".*");
                }
                if (!StringUtil.isNullOrEmpty((String)directory.getRegex())) {
                    dest = directory.getRegex();
                }
                if (!StringUtil.isNullOrEmpty((String)directory.getDest())) {
                    dest = directory.getDest();
                }
                if (dest == null) {
                    dest = ".*";
                }
                if (directory.getFiles().isEmpty() && directory.getDirectories().isEmpty()) {
                    com.oracle.cie.gdr.dao.pad.File file = new com.oracle.cie.gdr.dao.pad.File();
                    file.setRegex(dest + ALL_CONTENT_REGEX);
                    file.setForce(directory.isForce());
                    files.add(file);
                    continue;
                }
                for (com.oracle.cie.gdr.dao.pad.File file : directory.getFiles()) {
                    if (!StringUtil.isNullOrEmpty((String)file.getRegex())) {
                        String rgx = file.getRegex();
                        if (rgx.contains(".*")) {
                            rgx = rgx.replace(".*", "[^/].*");
                        }
                        file.setRegex(dest + "/" + rgx);
                    } else if (!StringUtil.isNullOrEmpty((String)file.getWildcard())) {
                        file.setRegex(dest + "/" + file.getWildcard());
                        file.setWildcard(null);
                    } else {
                        file.setRegex(dest + "/" + file.getDest());
                        file.setDest(null);
                    }
                    if (!file.isForce()) {
                        file.setForce(directory.isForce());
                    }
                    files.add(file);
                }
                for (com.oracle.cie.gdr.dao.pad.Directory innerDir : directory.getDirectories()) {
                    if (!StringUtil.isNullOrEmpty((String)innerDir.getRegex())) {
                        innerDir.setRegex(dest + "/" + innerDir.getRegex());
                    } else if (!StringUtil.isNullOrEmpty((String)innerDir.getWildcard())) {
                        innerDir.setRegex(dest + "/" + innerDir.getWildcard());
                        innerDir.setWildcard(null);
                    } else if (!StringUtil.isNullOrEmpty((String)innerDir.getDest())) {
                        innerDir.setRegex(dest + "/" + innerDir.getDest());
                        innerDir.setDest(null);
                    } else {
                        innerDir.setRegex(dest + ALL_CONTENT_REGEX);
                    }
                    if (!innerDir.isForce()) {
                        innerDir.setForce(directory.isForce());
                    }
                    directoryPaths.push(innerDir);
                }
            }
            if (_include.getFiles() != null) {
                files.addAll(_include.getFiles());
            }
            for (com.oracle.cie.gdr.dao.pad.File file : files) {
                String dest = null;
                if (!StringUtil.isNullOrEmpty((String)file.getWildcard()) && (dest = file.getWildcard()).contains("*")) {
                    dest = dest.replace("*", ".*");
                }
                if (!StringUtil.isNullOrEmpty((String)file.getRegex())) {
                    dest = file.getRegex();
                }
                if (!StringUtil.isNullOrEmpty((String)file.getDest())) {
                    dest = Pattern.quote(file.getDest());
                }
                if (dest == null) {
                    throw new CarbDiffException("Undefined file filter, must define either dest, regex or wildcard attribute: " + (Object)((Object)file));
                }
                if (dest.contains("**")) {
                    dest = dest.replaceAll(Pattern.quote("**"), ".*");
                }
                if ((dest = "/" + dest).contains("//")) {
                    dest = dest.replaceAll("//", "/");
                }
                file.setRegex(dest);
                file.setDest(null);
                file.setWildcard(null);
                regex.append("(" + dest + ")|");
            }
            _include.setDirectories(null);
            _include.setFiles(files);
        }
        return regex;
    }

    public List<com.oracle.cie.gdr.dao.cpd.File> filterFiles(JarHelper dataFileArchiveHelper, List<com.oracle.cie.gdr.dao.cpd.File> files, List<String> filteredPaths, String parentDir, FileGroup fileGroup) throws IOException, CarbDiffException {
        ArrayList<com.oracle.cie.gdr.dao.cpd.File> filtered = new ArrayList<com.oracle.cie.gdr.dao.cpd.File>();
        List<com.oracle.cie.gdr.dao.pad.File> includes = null;
        List<com.oracle.cie.gdr.dao.pad.File> excludes = null;
        String entryPath = null;
        String currentDir = parentDir;
        if (this._include != null) {
            includes = this._include.getFiles();
        }
        if (this._exclude != null) {
            excludes = this._exclude.getFiles();
        }
        if (_matchedRules != null) {
            if (StringUtil.isNullOrEmpty((String)parentDir)) {
                currentDir = "/";
            }
            while (currentDir.contains("//")) {
                currentDir = currentDir.replace("//", "/");
            }
            if (this._allRules != null) {
                _appliedRules.put(currentDir, new ArrayList());
                _matchedRules.put(currentDir, new ArrayList());
                for (com.oracle.cie.gdr.dao.pad.File exclude : this._allRules) {
                    String targetDir = FileMapFilterer.buildParentDir(exclude.getRegex());
                    if (!currentDir.equals(targetDir)) continue;
                    _matchedRules.get(currentDir).add(exclude);
                }
            }
        }
        for (com.oracle.cie.gdr.dao.cpd.File file : files) {
            File filteredArchive;
            String dest = parentDir + "/" + file.getDest();
            while (dest.contains("//")) {
                dest = dest.replace("//", "/");
            }
            if (!ComponentHelper.getInstance().isPatchable(fileGroup, file.getPatchable()) || !FileMapFilterer.accept(dest, includes, excludes, this._isReversed, parentDir)) continue;
            com.oracle.cie.gdr.dao.pad.File include = (com.oracle.cie.gdr.dao.pad.File)this.getMatch(dest, includes);
            com.oracle.cie.gdr.dao.pad.File exclude = (com.oracle.cie.gdr.dao.pad.File)this.getMatch(dest, excludes);
            filteredPaths.remove(dest);
            entryPath = StringUtil.isNullOrEmpty((String)parentDir) ? file.getDest() : parentDir + "/" + file.getDest();
            if (entryPath.startsWith("/")) {
                entryPath = entryPath.substring(1);
            }
            if (!JarUtils.isArchive((JarHelper)dataFileArchiveHelper, (String)entryPath)) {
                _logger.finest("Adding filtered file " + (StringUtil.isNullOrEmpty((String)file.getSource()) ? file.getDest() : file.getSource()));
                if (include != null && include.isForce()) {
                    this._forcedFiles.add(entryPath);
                }
                filtered.add(file);
                continue;
            }
            if (StringUtil.isNullOrEmpty((String)file.getJarEntry()) && (FileMapFilterer.hasInnerFiltering(include) || FileMapFilterer.hasInnerFiltering(exclude))) {
                _logger.finest("Filtering inner content of archive " + entryPath);
                filteredArchive = new File(this._destination, entryPath);
                File innerArchive = JarUtils.extractIntoTempFile((JarHelper)dataFileArchiveHelper, (String)entryPath);
                ArchiveFilter filter = CarbDiffUtils.convert(innerArchive, filteredArchive, include != null ? include.getArchiveFilter() : null, exclude != null ? exclude.getArchiveFilter() : null);
                filter.setReversed(this._isReversed);
                if (filter.apply() != null) {
                    this._filteredArchives.put(entryPath, filteredArchive);
                }
                if (filter.isManifestIncluded() || filter.getIncludedManifest() != null && !filter.getIncludedManifest().isEmpty()) {
                    if (filter.isManifestIncluded()) {
                        this._includedManifest.add(entryPath);
                    }
                    if (filter.getIncludedManifest() != null && !filter.getIncludedManifest().isEmpty()) {
                        this._includedManifest.add(entryPath + "!");
                        for (String innerJar : filter.getIncludedManifest()) {
                            this._includedManifest.add(entryPath + "!" + innerJar);
                        }
                    }
                }
                innerArchive.deleteOnExit();
            } else if (StringUtil.isNullOrEmpty((String)file.getJarEntry())) {
                _logger.finest("Filtering complete archive " + entryPath);
                filteredArchive = new File(this._destination, entryPath);
                File tmpArchive = JarUtils.extractIntoTempFile((JarHelper)dataFileArchiveHelper, (String)entryPath);
                tmpArchive.deleteOnExit();
                FileCopy.copy((File)tmpArchive, (File)filteredArchive);
                this._filteredArchives.put(entryPath, filteredArchive);
            }
            if (!this._filteredArchives.containsKey(entryPath)) continue;
            _logger.finest("Adding filtered file " + (StringUtil.isNullOrEmpty((String)file.getSource()) ? file.getDest() : file.getSource()));
            if (include != null && include.isForce()) {
                this._forcedFiles.add(entryPath);
            }
            filtered.add(file);
        }
        _logger.finest("Finished filtering files for " + (StringUtil.isNullOrEmpty((String)parentDir) ? "/" : parentDir));
        return filtered;
    }

    public List<Directory> filterDirs(JarHelper dataFileArchiveHelper, List<Directory> dirs, List<String> filteredPaths, String parentDir) throws IOException, CarbDiffException {
        ArrayList<Directory> filtered = new ArrayList<Directory>();
        String innerParentDir = null;
        String rules = null;
        for (Directory dir : dirs) {
            String dest = parentDir + "/" + dir.getDest();
            if (!this.accept(filteredPaths, dest)) continue;
            innerParentDir = parentDir.equals("/") ? parentDir + dir.getDest() : parentDir + "/" + dir.getDest();
            _logger.finest("Filtering directories for directory " + innerParentDir);
            List<Directory> filteredDirs = this.filterDirs(dataFileArchiveHelper, dir.getDirectories(), filteredPaths, innerParentDir);
            _logger.finest("Filtering files for directory " + dir.getDest());
            List<com.oracle.cie.gdr.dao.cpd.File> filteredFiles = this.filterFiles(dataFileArchiveHelper, dir.getFiles(), filteredPaths, innerParentDir, dir);
            dir.setDirectories(filteredDirs);
            dir.setFiles(filteredFiles);
            if (!((dir.getDirectories() == null || dir.getDirectories().isEmpty()) && (dir.getFiles() == null || dir.getFiles().isEmpty()) || filteredFiles.isEmpty() && filteredDirs.isEmpty())) {
                _logger.finest("Adding filtered dir " + dir.getDest());
                filtered.add(dir);
            }
            if (_matchedRules == null || _matchedRules.get(innerParentDir.replaceFirst("//", "/")) == null || _matchedRules.get(innerParentDir.replaceFirst("//", "/")).isEmpty()) continue;
            rules = this.replaceAppliedRules(innerParentDir.replaceFirst("//", "/"));
        }
        _logger.finest("Finished filtering directories for " + (StringUtil.isNullOrEmpty((String)parentDir) ? "/" : parentDir));
        if (!StringUtil.isNullOrEmpty(rules)) {
            _logger.finest("The following rules were not applied: \n" + rules);
            rules = null;
        }
        return filtered;
    }

    private boolean accept(List<String> filteredPaths, String path) {
        return null != this.matchedFilteredPath(filteredPaths, path);
    }

    private String matchedFilteredPath(List<String> filteredPaths, String path) {
        for (String filtered : filteredPaths) {
            while (path.contains("//")) {
                path = path.replace("//", "/");
            }
            if (!filtered.startsWith(path)) continue;
            if (filtered.equals(path)) {
                filteredPaths.remove(path);
            }
            return filtered;
        }
        return null;
    }

    private FileBase getMatch(String dest, List<? extends FileBase> includeExcludes) {
        if (includeExcludes == null) {
            return null;
        }
        for (FileBase fileBase : includeExcludes) {
            if (fileBase.getDest() != null && fileBase.getDest().equals(dest)) {
                return fileBase;
            }
            if (fileBase.getRegex() == null || !fileBase.getRegex().equals(dest)) continue;
            return fileBase;
        }
        for (FileBase fileBase : includeExcludes) {
            if (!fileBase.matches(dest)) continue;
            return fileBase;
        }
        return null;
    }

    public boolean isExplicitInclude() {
        return this._isExplicitInclude;
    }

    public static boolean accept(String dest, List<? extends FileBase> includes, List<? extends FileBase> excludes, boolean reverse, String parentDir) throws IOException {
        boolean emptyExcludes;
        boolean emptyIncludes = includes == null || includes.isEmpty();
        boolean bl = emptyExcludes = excludes == null || excludes.isEmpty();
        if (emptyIncludes && emptyExcludes) {
            return true;
        }
        boolean included = new Boolean(emptyIncludes);
        if (reverse) {
            included = FileMapFilterer.isIncluded(included, emptyIncludes, dest, includes, parentDir);
            included = FileMapFilterer.isExcluded(included, emptyExcludes, dest, excludes, parentDir);
        } else {
            included = FileMapFilterer.isExcluded(included, emptyExcludes, dest, excludes, parentDir);
            included = FileMapFilterer.isIncluded(included, emptyIncludes, dest, includes, parentDir);
        }
        return included;
    }

    private static boolean isIncluded(boolean included, boolean emptyIncludes, String dest, List<? extends FileBase> includes, String parentDir) {
        if (!emptyIncludes) {
            for (FileBase fileBase : includes) {
                if (!fileBase.matches(dest)) continue;
                if (_appliedRules != null) {
                    while (parentDir.contains("//")) {
                        parentDir = parentDir.replace("//", "/");
                    }
                    if (_appliedRules.get(parentDir) == null) {
                        _appliedRules.put(parentDir, new ArrayList());
                    }
                    _appliedRules.get(parentDir).add((com.oracle.cie.gdr.dao.pad.File)fileBase);
                }
                included = true;
                break;
            }
        }
        return included;
    }

    private static boolean isExcluded(boolean included, boolean emptyExcludes, String dest, List<? extends FileBase> excludes, String parentDir) {
        if (included && !emptyExcludes) {
            for (FileBase fileBase : excludes) {
                if (!fileBase.matches(dest) || FileMapFilterer.hasInnerFiltering(fileBase)) continue;
                if (StringUtil.isNullOrEmpty((String)parentDir)) {
                    parentDir = "/";
                }
                if (_appliedRules != null) {
                    while (parentDir.contains("//")) {
                        parentDir = parentDir.replace("//", "/");
                    }
                    if (_appliedRules.get(parentDir) == null) {
                        _appliedRules.put(parentDir, new ArrayList());
                    }
                    _appliedRules.get(parentDir).add((com.oracle.cie.gdr.dao.pad.File)fileBase);
                }
                included = false;
                break;
            }
        }
        return included;
    }

    private static boolean hasInnerFiltering(FileBase includeExclude) {
        boolean hasInnerFiltering = false;
        if (includeExclude instanceof com.oracle.cie.gdr.dao.pad.File) {
            com.oracle.cie.gdr.dao.pad.File file = (com.oracle.cie.gdr.dao.pad.File)includeExclude;
            hasInnerFiltering = file.getArchiveFilter() != null && (file.getArchiveFilter().getFiles() != null && !file.getArchiveFilter().getFiles().isEmpty() || file.getArchiveFilter().getDirectories() != null && !file.getArchiveFilter().getDirectories().isEmpty());
        } else if (includeExclude instanceof com.oracle.cie.gdr.dao.pad.Directory) {
            com.oracle.cie.gdr.dao.pad.Directory dir = (com.oracle.cie.gdr.dao.pad.Directory)includeExclude;
            hasInnerFiltering = dir.getFiles() != null && !dir.getFiles().isEmpty() || dir.getDirectories() != null && !dir.getDirectories().isEmpty();
        }
        return hasInnerFiltering;
    }

    public Map<String, File> getDataFilesMap() {
        return this._dataFilesMap;
    }

    public void setDataFilesMap(Map<String, File> dataFilesMap) {
        this._dataFilesMap = dataFilesMap;
    }

    public Map<String, File> getFilteredArchives() {
        return this._filteredArchives;
    }

    public void clearPendingRules() {
        if (_appliedRules != null && !_appliedRules.isEmpty()) {
            _appliedRules.clear();
        }
        if (_matchedRules != null && !_matchedRules.isEmpty()) {
            _matchedRules.clear();
        }
    }

    private String replaceAppliedRules(String directory) {
        StringBuilder rulesNotApplied = new StringBuilder();
        if (_appliedRules != null && !_appliedRules.isEmpty() && _appliedRules.get(directory) != null) {
            List<com.oracle.cie.gdr.dao.pad.File> rules = _matchedRules.get(directory);
            for (com.oracle.cie.gdr.dao.pad.File includeExcludeFile : _appliedRules.get(directory)) {
                rules.remove((Object)includeExcludeFile);
                this._allRules.remove((Object)includeExcludeFile);
            }
            if (!rules.isEmpty()) {
                com.oracle.cie.gdr.dao.pad.Directory tempDir = new com.oracle.cie.gdr.dao.pad.Directory(directory, null, null, false);
                tempDir.setFiles(rules);
                tempDir.setDirectories(null);
                rulesNotApplied.append(tempDir.toString());
            }
            this._allRules.removeAll(rules);
        }
        return rulesNotApplied.toString();
    }

    public static String buildParentDir(String regex) {
        StringBuilder matchedPath = new StringBuilder();
        String[] dirs = regex.split("/");
        String previousDir = "";
        String pattern = "";
        int pendingDirs = dirs.length;
        for (String dir : dirs) {
            --pendingDirs;
            if (dir.length() == 0) {
                matchedPath.append("/");
                continue;
            }
            if (dir.matches("\\w+\\-*\\w*") && pendingDirs > 0) {
                matchedPath.append("/" + dir);
                previousDir = dir;
                continue;
            }
            pattern = pattern + dir;
        }
        if (pattern.matches("\\.\\w+")) {
            matchedPath.delete(matchedPath.length() - previousDir.length() - 1, matchedPath.length());
        }
        if (matchedPath.length() == 1) {
            return matchedPath.toString();
        }
        return matchedPath.toString().substring(1);
    }

    public List<String> getForcedFiles() {
        return this._forcedFiles;
    }

    public FileMap filterSingleFileMap(Component component, FileMap fileMap) throws IOException, CarbDiffException {
        FileMap filtered = null;
        JarHelper dataFileArchiveHelper = new JarHelper(this._dataFilesMap.get(fileMap.getSource()));
        StringBuilder includePattern = this.buildIncludeRegex(this._include);
        StringBuilder excludePattern = this.buildIncludeRegex(this._exclude);
        ArrayList<String> filteredPaths = new ArrayList<String>();
        Map<String, FileTarget> filetargets = ComponentHelper.getInstance().getCarbDiffFileTargets(component, fileMap);
        for (Map.Entry<String, FileTarget> target : filetargets.entrySet()) {
            if (includePattern.length() == 0 && !("/" + target.getKey()).matches(excludePattern.toString())) {
                filteredPaths.add("/" + target.getKey());
            }
            if (!("/" + target.getKey()).matches(includePattern.toString())) continue;
            filteredPaths.add("/" + target.getKey());
        }
        if (this._include != null) {
            this._allRules.addAll(this._include.getFiles());
        }
        if (this._exclude != null) {
            this._allRules.addAll(this._exclude.getFiles());
        }
        List<com.oracle.cie.gdr.dao.cpd.File> files = this.filterFiles(dataFileArchiveHelper, fileMap.getFiles(), filteredPaths, "", fileMap);
        List<Directory> dirs = this.filterDirs(dataFileArchiveHelper, fileMap.getDirectories(), filteredPaths, "");
        if (!files.isEmpty() || !dirs.isEmpty()) {
            filtered = new FileMap(fileMap.getDataHandler().copy());
            filtered.setFiles(files);
            filtered.setDirectories(dirs);
        }
        _logger.finest("Filtering rules applied: " + _appliedRules);
        if (this._allRules != null && !this._allRules.isEmpty()) {
            StringBuilder notMatchedRules = new StringBuilder();
            for (com.oracle.cie.gdr.dao.pad.File rule : this._allRules) {
                notMatchedRules.append((Object)((Object)rule) + "\n");
            }
            _logger.finest("The following rules did not match any entry: \n" + notMatchedRules.toString());
        }
        _logger.finest("Finished filtering file map");
        return filtered;
    }

    public List<String> getIncludedManifest() {
        return this._includedManifest;
    }

    static {
        ALL_CONTENT_REGEX = "/[^/].*";
    }
}

