/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff;

import com.oracle.cie.common.xmldiff.XmlDiff;
import com.oracle.cie.common.xmldiff.XmlDiffAspect;
import com.oracle.cie.common.xmldiff.XmlDiffTree;
import com.oracle.cie.common.xmldiff.XmlDiffTreeFilter;
import com.oracle.cie.gdr.carbdiff.CarbDiffException;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import java.io.File;
import java.util.logging.Logger;

public class FeatureSetDiff {
    private XmlDiffTree _featureXmlDiffTree;
    private File _featureXDiff;
    private XmlDiffTreeFilter _xmlDiffTreeFilter;
    private static final Logger _logger = Logger.getLogger(FeatureSetDiff.class.getName());
    private String _featureName;
    private String _featureVersion;
    private String _associatedComponent;
    private File _patchedFeatureDef;
    private String _action;

    public FeatureSetDiff() {
    }

    public FeatureSetDiff(String featureName, String featureVersion) {
        this._featureName = featureName;
        this._featureVersion = featureVersion;
    }

    public boolean diff(File baseFeatureFile, File patchedFeatureFile, File deltaDestination) throws CarbDiffException {
        if (!baseFeatureFile.exists() | !patchedFeatureFile.exists()) {
            throw new CarbDiffException("The features " + baseFeatureFile + " and " + patchedFeatureFile + " should exist.");
        }
        _logger.info("Starting feature set diff for feature " + baseFeatureFile + " and " + patchedFeatureFile);
        try {
            _logger.fine("Loading feature set " + baseFeatureFile.getCanonicalPath());
            FeatureSet baseFeature = (FeatureSet)FeatureSetHelper.getInstance().getRootWrapper(baseFeatureFile);
            _logger.fine("Loading feature set " + patchedFeatureFile.getCanonicalPath());
            FeatureSet patchedFeature = (FeatureSet)FeatureSetHelper.getInstance().getRootWrapper(patchedFeatureFile);
            this._featureName = patchedFeature.getName();
            this._featureVersion = patchedFeature.getVersion();
            _logger.fine("Starting xml diff on features.");
            this._featureXmlDiffTree = XmlDiff.diffAspects((XmlDiffAspect)baseFeature.getDataHandler(), (XmlDiffAspect)patchedFeature.getDataHandler(), (XmlDiffTreeFilter)this._xmlDiffTreeFilter);
            this._patchedFeatureDef = patchedFeatureFile;
            if (this._featureXmlDiffTree.hasChange()) {
                _logger.info("Features have changes, saving xml diff tree.");
                this._featureXDiff = new File(deltaDestination, patchedFeature.getName() + "_" + patchedFeature.getVersion() + "." + "xdiff");
                this._featureXmlDiffTree.save(this._featureXDiff);
            }
        }
        catch (Exception anyException) {
            throw new CarbDiffException(anyException);
        }
        if (this._featureXmlDiffTree != null) {
            return this._featureXmlDiffTree.hasChange();
        }
        return false;
    }

    public File getFeatureXDiff() {
        return this._featureXDiff;
    }

    public void setXmlDiffTreeFilter(XmlDiffTreeFilter diffTreeFilter) {
        this._xmlDiffTreeFilter = diffTreeFilter;
    }

    public String getFeatureName() {
        return this._featureName;
    }

    public String getFeatureVersion() {
        return this._featureVersion;
    }

    public String getAssociatedComponent() {
        return this._associatedComponent;
    }

    public void setAssociatedComponent(String associatedComponent) {
        this._associatedComponent = associatedComponent;
    }

    public File getPatchedFeatureSetDef() {
        return this._patchedFeatureDef;
    }

    public void setPatchedFeatureDef(File patchedFeatureDef) {
        this._patchedFeatureDef = patchedFeatureDef;
    }

    public void setAction(String action) {
        this._action = action;
    }

    public String getAction() {
        return this._action;
    }
}

