/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dependency.FeatureDependencyManager;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.RepositoryService;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetaDataHome {
    private static final Logger _log = Logger.getLogger(MetaDataHome.class.getName());
    public static final String SRCHOME_OVERRIDE_PROPERTY = "MetaDataHome.srchome.override";
    protected Path _gdrMetaDataHome;
    protected Path _componentMetaDataHome;
    protected Path _srchome;
    protected Path _installDir;
    protected Path _stageDir;
    private boolean _shiphome = true;
    private boolean _archive = false;
    private boolean _patch = false;
    private RepositoryService _repositoryService;
    private ClassLoader _classLoader;
    private FeatureDependencyManager _featureDependencyManager;

    public MetaDataHome(File metaDataHome) throws GdrException {
        this(NioHelper.getInstance().getPath(metaDataHome), NioHelper.getInstance().getPath(metaDataHome), null);
    }

    public MetaDataHome(Path metaDataHome) throws GdrException {
        this(metaDataHome, metaDataHome, null);
    }

    public MetaDataHome(File metaDataHome, boolean shiphome) throws GdrException {
        this(NioHelper.getInstance().getPath(metaDataHome), NioHelper.getInstance().getPath(metaDataHome), null, shiphome);
    }

    public MetaDataHome(Path metaDataHome, boolean shiphome) throws GdrException {
        this(metaDataHome, metaDataHome, null, shiphome);
    }

    public MetaDataHome(File metaDataHome, boolean shiphome, boolean archive) throws GdrException {
        this(NioHelper.getInstance().getPath(metaDataHome), shiphome, archive);
    }

    public MetaDataHome(Path metaDataHome, boolean shiphome, boolean archive) throws GdrException {
        this(metaDataHome, metaDataHome, null, null, null, shiphome, archive);
    }

    public MetaDataHome(Path metaDataHome, boolean shiphome, boolean archive, boolean patch) throws GdrException {
        this(metaDataHome, metaDataHome, null, null, null, shiphome, archive, patch);
    }

    public MetaDataHome(Path gdrMetaDataHome, Path componentMetaDataHome) throws GdrException {
        this(gdrMetaDataHome, componentMetaDataHome, null);
    }

    public MetaDataHome(File gdrMetaDataHome, File componentMetaDataHome, boolean shiphome) throws GdrException {
        this(NioHelper.getInstance().getPath(gdrMetaDataHome), NioHelper.getInstance().getPath(componentMetaDataHome), null, shiphome);
    }

    public MetaDataHome(Path gdrMetaDataHome, Path componentMetaDataHome, boolean shiphome) throws GdrException {
        this(gdrMetaDataHome, componentMetaDataHome, null, shiphome);
    }

    public MetaDataHome(Path gdrMetaDataHome, Path componentMetaDataHome, Path srchome) throws GdrException {
        this(gdrMetaDataHome, componentMetaDataHome, srchome, true);
    }

    public MetaDataHome(Path gdrMetaDataHome, Path componentMetaDataHome, Path srchome, boolean shiphome) throws GdrException {
        this(gdrMetaDataHome, componentMetaDataHome, srchome, null, null, shiphome);
    }

    public MetaDataHome(File gdrMetaDataHome, File componentMetaDataHome, File srchome, File installDir, File stageDir, boolean shiphome) throws GdrException {
        this(NioHelper.getInstance().getPath(gdrMetaDataHome), NioHelper.getInstance().getPath(componentMetaDataHome), NioHelper.getInstance().getPath(srchome), NioHelper.getInstance().getPath(installDir), NioHelper.getInstance().getPath(stageDir), shiphome);
    }

    public MetaDataHome(Path gdrMetaDataHome, Path componentMetaDataHome, Path srchome, Path installDir, Path stageDir, boolean shiphome) throws GdrException {
        this(gdrMetaDataHome, componentMetaDataHome, srchome, installDir, stageDir, shiphome, false);
    }

    public MetaDataHome(Path gdrMetaDataHome, Path componentMetaDataHome, Path srchome, Path installDir, Path stageDir, boolean shiphome, boolean archive) throws GdrException {
        this(gdrMetaDataHome, componentMetaDataHome, srchome, installDir, stageDir, shiphome, archive, false);
    }

    public MetaDataHome(Path gdrMetaDataHome, Path componentMetaDataHome, Path srchome, Path installDir, Path stageDir, boolean shiphome, boolean archive, boolean patch) throws GdrException {
        this.init(gdrMetaDataHome, componentMetaDataHome, srchome, installDir, stageDir, shiphome, archive, patch);
    }

    public MetaDataHome(RepositoryService repositoryService) throws GdrException {
        if (repositoryService == null) {
            throw new GdrException("The repository service specified was null.");
        }
        if (repositoryService.getLocalCacheRepository() == null) {
            throw new GdrException("The cache repository specified was null.");
        }
        Path auxiliaryMetaDataHome = NioHelper.getInstance().getPath(repositoryService.getLocalCacheRepository().getCacheLocation());
        this._repositoryService = repositoryService;
        this.init(auxiliaryMetaDataHome, auxiliaryMetaDataHome, null, null, null, false, false, false);
    }

    protected void init(Path gdrMetaDataHome, Path componentMetaDataHome, Path srchome, Path installDir, Path stageDir, boolean shiphome, boolean archive, boolean patch) throws GdrException {
        if (gdrMetaDataHome == null || !archive && !Files.isDirectory(gdrMetaDataHome, new LinkOption[0]) || archive && !Files.isRegularFile(gdrMetaDataHome, new LinkOption[0])) {
            GdrException ex = new GdrException("The gdr meta-data directory " + gdrMetaDataHome + " is invalid or does not exist.");
            _log.throwing(MetaDataHome.class.getName(), "init", (Throwable)ex);
            throw ex;
        }
        this._gdrMetaDataHome = this.isRepository() ? gdrMetaDataHome.toAbsolutePath().resolve("com.oracle.cie.gdr".replace(".", File.separator)) : gdrMetaDataHome.toAbsolutePath();
        if (componentMetaDataHome == null || !archive && !Files.isDirectory(componentMetaDataHome, new LinkOption[0]) || archive && !Files.isRegularFile(componentMetaDataHome, new LinkOption[0])) {
            GdrException ex = new GdrException("The component meta-data directory " + componentMetaDataHome + " is invalid or does not exist.");
            _log.throwing(MetaDataHome.class.getName(), "init", (Throwable)ex);
            throw ex;
        }
        this._componentMetaDataHome = componentMetaDataHome.toAbsolutePath();
        this.setSrchome(srchome == null ? gdrMetaDataHome.getParent() : srchome);
        this.setShiphome(shiphome);
        this.setArchive(archive);
        this.setPatch(patch);
        this._installDir = installDir != null ? installDir : ComponentHelper.getInstallDir(this._componentMetaDataHome);
        Path path = this._stageDir = stageDir != null ? stageDir : ComponentHelper.getStageDir(this._installDir);
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Using meta-data home: " + this.toString());
        }
    }

    public File getGdrMetaDataHome() {
        return this._gdrMetaDataHome.toFile();
    }

    public Path getGdrMetaDataHomePath() {
        return this._gdrMetaDataHome;
    }

    public File getComponentMetaDataHome() {
        return this._componentMetaDataHome.toFile();
    }

    public Path getComponentMetaDataHomePath() {
        return this._componentMetaDataHome;
    }

    public RepositoryService getRepositoryService() {
        return this._repositoryService;
    }

    public boolean isRepository() {
        return this._repositoryService != null;
    }

    private void setSrchome(Path srchome) {
        String srchomeOverride = System.getProperty(SRCHOME_OVERRIDE_PROPERTY);
        this._srchome = !StringUtil.isNullOrEmpty((String)srchomeOverride, (boolean)true) ? NioHelper.getInstance().getPath(srchomeOverride, new String[0]) : srchome;
    }

    public File getSrchome() {
        return this._srchome.toFile();
    }

    public Path getSrchomePath() {
        return this._srchome;
    }

    public File getInstallDir() {
        return this._installDir.toFile();
    }

    public Path getInstallDirPath() {
        return this._installDir;
    }

    public File getStageDir() {
        return this._stageDir.toFile();
    }

    public Path getStageDirPath() {
        return this._stageDir;
    }

    public void setShiphome(boolean shiphome) {
        this._shiphome = shiphome;
    }

    public boolean isShiphome() {
        return this._shiphome;
    }

    public boolean isArchive() {
        return this._archive;
    }

    public void setArchive(boolean archive) {
        this._archive = archive;
    }

    public boolean isPatch() {
        return this._patch;
    }

    public void setPatch(boolean patch) {
        this._patch = patch;
    }

    public FeatureDependencyManager getFeatureDependencyManager() throws GdrException {
        if (this._featureDependencyManager == null) {
            this._featureDependencyManager = new FeatureDependencyManager(this.getClassLoader());
            try {
                this._featureDependencyManager.loadFeatureSetDependencies(this);
            }
            catch (Exception e) {
                GdrException ex = new GdrException((Throwable)e);
                _log.throwing(MetaDataHome.class.getName(), "getFeatureDependencyManager", (Throwable)ex);
                throw ex;
            }
        }
        return this._featureDependencyManager;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public String toString() {
        return this.getGdrMetaDataHomePath() + ":" + this.getComponentMetaDataHomePath() + ":" + this.getSrchomePath() + ":shiphome=" + this.isShiphome();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaDataHome that = (MetaDataHome)o;
        return !((this._gdrMetaDataHome == null ? that._gdrMetaDataHome != null : !this._gdrMetaDataHome.equals(that._gdrMetaDataHome)) || (this._componentMetaDataHome == null ? that._componentMetaDataHome != null : !this._componentMetaDataHome.equals(that._componentMetaDataHome)) || (this._srchome == null ? that._srchome != null : !this._srchome.equals(that._srchome)));
    }

    public int hashCode() {
        int result = this._gdrMetaDataHome != null ? this._gdrMetaDataHome.hashCode() : 0;
        result = 31 * result + (this._componentMetaDataHome != null ? this._componentMetaDataHome.hashCode() : 0);
        result = 31 * result + (this._srchome != null ? this._srchome.hashCode() : 0);
        return result;
    }
}

