/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DistributionTarget {
    private static final Logger _log = Logger.getLogger(DistributionTarget.class.getName());
    private Distribution _distribution;
    private Set<FeatureSet> _featureSets;
    private Set<FeatureSet> _dynamicFeatureSets;
    private Map<FeatureSetReference, FeatureSet> _externalFeatureRefs = new HashMap<FeatureSetReference, FeatureSet>();

    public DistributionTarget(Distribution distribution, Set<FeatureSet> featureSets) {
        this(distribution, featureSets, null);
    }

    public DistributionTarget(Distribution distribution, Set<FeatureSet> featureSets, MetaDataHome metaDataHome) {
        if (distribution == null) {
            NullPointerException ex = new NullPointerException("The distribution provided was null.");
            _log.throwing(DistributionTarget.class.getName(), "DistributionTarget", ex);
            throw ex;
        }
        this._distribution = distribution;
        this._featureSets = featureSets != null ? new LinkedHashSet<FeatureSet>(featureSets) : new LinkedHashSet<FeatureSet>();
        for (FeatureSetReference ref : DistributionHelper.getInstance().getExternalFeatureSetReferences(this._distribution)) {
            FeatureSet fs = new FeatureSet(ref.getName(), ref.getVersion(), metaDataHome != null ? metaDataHome.getClassLoader() : null);
            fs.setDummy(true);
            this._externalFeatureRefs.put(ref, fs);
        }
    }

    public Distribution getDistribution() {
        return this._distribution;
    }

    public String getDistributionName() {
        return this._distribution.getName();
    }

    public String getDistributionVersion() {
        return this._distribution.getVersion();
    }

    public Set<FeatureSet> getFeatureSets() {
        LinkedHashSet<FeatureSet> featureSets = new LinkedHashSet<FeatureSet>(this._featureSets);
        Set<FeatureSet> dynamicFeatureSets = this.getDynamicFeatureSets();
        if (dynamicFeatureSets != null) {
            featureSets.addAll(dynamicFeatureSets);
        }
        return featureSets;
    }

    public Set<FeatureSet> getDynamicFeatureSets() {
        return this._dynamicFeatureSets;
    }

    public void setDynamicFeatureSets(Set<FeatureSet> dynamicFeatureSets) {
        this._dynamicFeatureSets = dynamicFeatureSets;
    }

    public FeatureSet getFeatureSet(String name, String version) {
        if (!StringUtil.isNullOrEmpty((String)name) && !StringUtil.isNullOrEmpty((String)version)) {
            for (FeatureSet feature : this.getFeatureSets()) {
                if (!name.equals(feature.getName()) || !version.equals(feature.getVersion())) continue;
                return feature;
            }
        }
        return null;
    }

    public Set<ComponentReference> getComponents() {
        HashSet<ComponentReference> installed = new HashSet<ComponentReference>();
        Set<FeatureSet> features = this.getFeatureSets();
        if (features != null && !features.isEmpty()) {
            for (FeatureSet feature : features) {
                installed.addAll(feature.getComponentReferences());
            }
        }
        return installed;
    }

    public Set<FeatureSet> getInstalledFeatureSets() {
        HashSet<FeatureSet> installed = new HashSet<FeatureSet>(this.getFeatureSets());
        Iterator it = installed.iterator();
        while (it.hasNext()) {
            if (((FeatureSet)it.next()).getStatus().isInstalled()) continue;
            it.remove();
        }
        return installed;
    }

    public Set<ComponentReference> getInstalledComponents() {
        HashSet<ComponentReference> installed = new HashSet<ComponentReference>();
        Set<FeatureSet> features = this.getInstalledFeatureSets();
        if (features != null && !features.isEmpty()) {
            for (FeatureSet feature : features) {
                installed.addAll(this.getInstalledComponentsInternal(feature));
            }
        }
        return installed;
    }

    public Set<ComponentReference> getInstalledComponents(FeatureSet feature) {
        HashSet<ComponentReference> installed = new HashSet<ComponentReference>();
        if (feature != null) {
            FeatureSet currentFeature = this.getFeatureSet(feature.getName(), feature.getVersion());
            installed.addAll(this.getInstalledComponentsInternal(currentFeature));
        }
        return installed;
    }

    private Set<ComponentReference> getInstalledComponentsInternal(FeatureSet feature) {
        HashSet<ComponentReference> installed = new HashSet<ComponentReference>();
        if (feature != null) {
            List<ComponentReference> components = feature.getComponentReferences();
            for (ComponentReference component : components) {
                if (!component.getStatus().isInstalled()) continue;
                installed.add(component);
            }
        }
        return installed;
    }

    public List<FeatureSetGroup> getFeatureSetGroups() {
        return this._distribution.getFeatureSetGroups();
    }

    public Set<FeatureSetReference> getExternalFeatureRefs() {
        return new HashSet<FeatureSetReference>(this._externalFeatureRefs.keySet());
    }

    public Set<FeatureSet> getDummyExternalFeatureSets() {
        return new HashSet<FeatureSet>(this._externalFeatureRefs.values());
    }

    public Map<FeatureSetReference, FeatureSet> getExternalFeatureSetsMap() {
        return new HashMap<FeatureSetReference, FeatureSet>(this._externalFeatureRefs);
    }

    public DirectoryMap getDirectoryMap() {
        return this._distribution.getDirectoryMap();
    }

    public void setOverrideDirectoryMap(DirectoryMap directoryMap) {
        this._distribution.setOverrideDirectoryMap(directoryMap);
    }

    public void upgradeFeature(FeatureSet feature, FeatureSet upgrade) {
        feature.setSuperseded(upgrade);
        upgrade.addUpgrades(feature);
        upgrade.setOriginalFeatureSet(feature);
        this.replaceFeature(feature, upgrade);
    }

    public void replaceFeature(FeatureSet current, FeatureSet replacement) {
        LinkedHashSet<FeatureSet> featureSets = new LinkedHashSet<FeatureSet>();
        for (FeatureSet featureSet : this._featureSets) {
            if (featureSet.equals(current)) {
                featureSets.add(replacement);
                continue;
            }
            featureSets.add(featureSet);
        }
        this._featureSets = featureSets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().isAssignableFrom(this.getClass())) {
            return false;
        }
        DistributionTarget distTarget = (DistributionTarget)o;
        String name = this.getDistributionName();
        String version = this.getDistributionVersion();
        String otherName = distTarget.getDistributionName();
        String otherVersion = distTarget.getDistributionVersion();
        return !(name == null ? otherName != null : !name.equals(otherName)) && !(version == null ? otherVersion != null : !version.equals(otherVersion));
    }

    public String toString() {
        return this.getDistribution().toString();
    }

    public int hashCode() {
        return this._distribution.hashCode() + this._featureSets.hashCode() + this._externalFeatureRefs.hashCode() + (this._dynamicFeatureSets != null && !this._dynamicFeatureSets.isEmpty() ? this._dynamicFeatureSets.hashCode() : 0);
    }
}

