/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DistributionLoaderFactory {
    private static Map<DistributionLoaderFactoryKey, DistributionLoader> _cache = new HashMap<DistributionLoaderFactoryKey, DistributionLoader>();

    public static DistributionLoader getDistributionLoader(MetaDataHome metaDataHome, String distributionName, String distributionVersion) throws GdrException, IOException, DataHandlerException {
        DistributionLoaderFactoryKey key = new DistributionLoaderFactoryKey(metaDataHome, distributionName, distributionVersion);
        DistributionLoader loader = _cache.get(key);
        if (loader == null) {
            loader = new DistributionLoader(metaDataHome, distributionName, distributionVersion);
            _cache.put(key, loader);
        }
        return loader;
    }

    public static DistributionLoader getDistributionLoader(MetaDataHome metaDataHome, Distribution distribution) throws GdrException, IOException, DataHandlerException {
        return DistributionLoaderFactory.getDistributionLoader(metaDataHome, distribution, true);
    }

    public static DistributionLoader getDistributionLoader(MetaDataHome metaDataHome, Distribution distribution, boolean cached) throws GdrException, IOException, DataHandlerException {
        DistributionLoader loader = null;
        DistributionLoaderFactoryKey key = null;
        if (cached) {
            key = new DistributionLoaderFactoryKey(metaDataHome, distribution.getName(), distribution.getVersion());
            loader = _cache.get(key);
        }
        if (loader == null) {
            loader = new DistributionLoader(metaDataHome, distribution);
        }
        if (cached) {
            _cache.put(key, loader);
        }
        return loader;
    }

    public static void clearCache() {
        _cache.clear();
    }

    public static void clearCache(MetaDataHome metaDataHome) {
        if (metaDataHome != null) {
            for (DistributionLoaderFactoryKey key : new HashSet<DistributionLoaderFactoryKey>(_cache.keySet())) {
                if (!key._metaDataHome.equals(metaDataHome)) continue;
                _cache.remove(key);
            }
        }
    }

    private static class DistributionLoaderFactoryKey {
        MetaDataHome _metaDataHome;
        String _distributionName;
        String _distributionVersion;

        private DistributionLoaderFactoryKey(MetaDataHome metaDataHome, String distributionName, String distributionVersion) {
            this._metaDataHome = metaDataHome;
            this._distributionName = distributionName;
            this._distributionVersion = distributionVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DistributionLoaderFactoryKey that = (DistributionLoaderFactoryKey)o;
            return !((this._distributionName == null ? that._distributionName != null : !this._distributionName.equals(that._distributionName)) || (this._distributionVersion == null ? that._distributionVersion != null : !this._distributionVersion.equals(that._distributionVersion)) || (this._metaDataHome == null ? that._metaDataHome != null : !this._metaDataHome.equals(that._metaDataHome)));
        }

        public int hashCode() {
            int result = this._metaDataHome != null ? this._metaDataHome.hashCode() : 0;
            result = 31 * result + (this._distributionName != null ? this._distributionName.hashCode() : 0);
            result = 31 * result + (this._distributionVersion != null ? this._distributionVersion.hashCode() : 0);
            return result;
        }
    }
}

