/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.opatch.CrsImpl;
import oracle.opatch.LsInventoryRacInfo;
import oracle.opatch.OPatchEnv;
import oracle.opatch.Rac;
import oracle.opatch.RacImpl;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;
import oracle.ops.mgmt.cluster.ClusterCmd;

public class LsInventoryRacInfoImpl
implements LsInventoryRacInfo {
    public String[] probeAndPrintRACInfo(IIPMReadServices readServices) throws RuntimeException {
        StringBuffer buff = new StringBuffer("probeAndPrintRACInfo()");
        String[] retNodes = new String[]{};
        StringBuffer output = new StringBuffer();
        OLogger.debug((StringBuffer)buff);
        Rac.RacType racType = null;
        RacImpl rac = new RacImpl();
        racType = rac.getInstance(readServices);
        buff = new StringBuffer(racType.getDetail());
        String dscr = buff.toString();
        OLogger.debug((StringBuffer)buff);
        String toString = rac.toString(readServices);
        buff = new StringBuffer(toString);
        OLogger.debug((StringBuffer)buff);
        if (racType == Rac.RacType.MULTIPLE_NODE) {
            if (readServices.isDesiredHome()) {
                String oracleHomePath = OPatchEnv.getOracleHome();
                CrsImpl crs = new CrsImpl();
                HashMap patchingLevels = crs.getPatchingLevel(oracleHomePath);
                HashMap levelNodeMap = new HashMap();
                Iterator nodes = patchingLevels.keySet().iterator();
                if (!nodes.hasNext()) {
                    throw new RuntimeException("Failed to get patch level information from CRS home");
                }
                int maxLen = 14;
                while (nodes.hasNext()) {
                    String node = (String)nodes.next();
                    String level = (String)patchingLevels.get(node);
                    int n = maxLen = maxLen < level.length() ? level.length() : maxLen;
                    if (levelNodeMap.get(level) != null) {
                        ((ArrayList)levelNodeMap.get(level)).add(node);
                        continue;
                    }
                    ArrayList<String> nodesInfo = new ArrayList<String>();
                    nodesInfo.add(node);
                    levelNodeMap.put(level, nodesInfo);
                }
                output = new StringBuffer("Patch level status of Cluster nodes :\n\n");
                String gap = OPatchEnv.getSpaceString((int)(maxLen + 4 - 14));
                output.append(" Patching Level " + gap + "\t\t Nodes\n");
                output.append(" -------------- " + gap + "\t\t -----\n");
                for (String level : levelNodeMap.keySet()) {
                    ArrayList nodesInfo = (ArrayList)levelNodeMap.get(level);
                    output.append(" " + level + OPatchEnv.getSpaceString((int)(maxLen + 4 - level.length())) + " \t\t ");
                    for (int i = 0; i < nodesInfo.size(); ++i) {
                        output.append((String)nodesInfo.get(i) + (i != nodesInfo.size() - 1 ? "," : ""));
                    }
                    output.append("\n");
                }
            } else {
                String localNode = racType.getLocalNode();
                String[] nodeList = racType.getRemoteNodes();
                OLogger.println((String)dscr);
                buff = new StringBuffer("  CRS Home = ");
                buff.append(readServices.isCRSHome());
                buff.append("\n");
                OLogger.log((int)OLogger.FINE, (String)buff.toString());
                if (localNode != null) {
                    output = new StringBuffer("  Local node = ");
                    output.append(localNode);
                    output.append("\n");
                }
                OLogger.debug((StringBuffer)output);
                if (nodeList != null && nodeList.length > 0) {
                    int len = nodeList.length;
                    buff = new StringBuffer("  nodeList != null: len= ");
                    buff.append(len);
                    OLogger.debug((StringBuffer)buff);
                    retNodes = new String[len + 1];
                    buff = new StringBuffer("  put ");
                    buff.append(localNode);
                    buff.append(" to retNodes[0]");
                    OLogger.debug((StringBuffer)buff);
                    retNodes[0] = localNode;
                    for (int i = 0; i < len; ++i) {
                        String node = nodeList[i];
                        buff = new StringBuffer("  processing node ");
                        buff.append(node);
                        OLogger.debug((StringBuffer)buff);
                        if (node.equals(localNode)) continue;
                        output.append("  Remote node = ");
                        output.append(node);
                        output.append("\n");
                        retNodes[i + 1] = node;
                        buff = new StringBuffer("  assigning node ");
                        buff.append(node);
                        buff.append(" to retNodes[");
                        buff.append(i + 1);
                        buff.append("]");
                        OLogger.debug((StringBuffer)buff);
                    }
                }
            }
            OLogger.println((String)output.toString());
        } else if (racType != Rac.RacType.NO_RAC && racType == Rac.RacType.SINGLE_NODE) {
            OLogger.println((String)output.toString());
            String localNode = racType.getLocalNode();
            if (localNode != null) {
                retNodes = new String[]{localNode};
            }
        }
        buff = new StringBuffer("probeAndPrintRACInfo() done");
        OLogger.debug((StringBuffer)buff);
        return retNodes;
    }

    public void printAllNodesInfo(String oracleHomePath, IIPMReadServices readServices) throws RuntimeException {
        StringBuffer buff = new StringBuffer("printAllNodesInfo()");
        OLogger.debug((StringBuffer)buff);
        Rac.RacType racType = null;
        RacImpl rac = new RacImpl();
        racType = rac.getInstance(readServices);
        if (racType == Rac.RacType.NO_RAC) {
            throw new RuntimeException(OLogger.getString((String)"OUI-67224"));
        }
        if (racType == Rac.RacType.SINGLE_NODE) {
            OLogger.println((String)OLogger.getString((String)"OUI-67225"));
            return;
        }
        if (racType == Rac.RacType.MULTIPLE_NODE) {
            String warn;
            int count;
            String dstChecksumLogFile;
            String dstPatchLogFile;
            buff = new StringBuffer("Detected as Multiple Node RAC");
            OLogger.debug((StringBuffer)buff);
            boolean cleanUpFailure = false;
            String patchStorageLocation = OPatchEnv.getPatchStorageDirectoryPath((String)oracleHomePath);
            String srcPatchLogFile = patchStorageLocation + File.separator + "patch_info.log";
            String srcChecksumLogFile = patchStorageLocation + File.separator + "checksum_info.log";
            String[] nodeList = racType.getRemoteNodes();
            String localNode = racType.getLocalNode();
            File f = new File(srcPatchLogFile);
            if (f.exists()) {
                f.delete();
            }
            if ((f = new File(srcChecksumLogFile)).exists()) {
                f.delete();
            }
            for (int count2 = 0; count2 < nodeList.length; ++count2) {
                dstPatchLogFile = patchStorageLocation + File.separator + "patch_info_" + nodeList[count2] + ".log";
                dstChecksumLogFile = patchStorageLocation + File.separator + "checksum_info_" + nodeList[count2] + ".log";
                f = new File(dstPatchLogFile);
                if (f.exists()) {
                    f.delete();
                }
                if (!(f = new File(dstChecksumLogFile)).exists()) continue;
                f.delete();
            }
            ClusterCmd clusterCmd = null;
            try {
                clusterCmd = new ClusterCmd();
            }
            catch (Exception e) {
                buff = new StringBuffer("lsinventory::failed for -all_nodes");
                buff.append("\n");
                buff.append(e.getMessage());
                RuntimeException re = new RuntimeException(buff.toString(), e);
                throw re;
            }
            String cmd = oracleHomePath + File.separator + "OPatch" + File.separator + "opatch";
            String invPtrLoc = OPatchEnv.getAbsoluteInvPtrLoc();
            if (invPtrLoc.equals("") || invPtrLoc == null) {
                throw new RuntimeException("OPatch finds invalid oraInst.loc location");
            }
            String[] argString = new String[]{" lsinventory ", "-patch_checksum", "-oh", oracleHomePath, "-invPtrLoc", invPtrLoc};
            String[] lNode = new String[]{localNode};
            buff = new StringBuffer("Command to be run with Arguments:");
            buff.append(cmd);
            buff.append(" ");
            buff.append(argString);
            OLogger.debug((StringBuffer)buff);
            try {
                clusterCmd.runCmd(cmd, argString, null, nodeList);
                clusterCmd.runCmd(cmd, argString, null, lNode);
            }
            catch (Exception e) {
                buff = new StringBuffer("Issue with running commands at remote\n");
                buff.append(e.toString());
                OLogger.debug((StringBuffer)buff);
                RuntimeException re = new RuntimeException(buff.toString(), e);
                throw re;
            }
            for (count = 0; count < nodeList.length; ++count) {
                dstPatchLogFile = patchStorageLocation + File.separator + "patch_info_" + nodeList[count] + ".log";
                dstChecksumLogFile = patchStorageLocation + File.separator + "checksum_info_" + nodeList[count] + ".log";
                try {
                    clusterCmd.copyFileFromNode(nodeList[count], srcPatchLogFile, dstPatchLogFile);
                    clusterCmd.copyFileFromNode(nodeList[count], srcChecksumLogFile, dstChecksumLogFile);
                    continue;
                }
                catch (Exception e) {
                    buff = new StringBuffer("Issue with file propagation\n");
                    buff.append(e.toString());
                    OLogger.debug((StringBuffer)buff);
                    RuntimeException re = new RuntimeException(buff.toString(), e);
                    throw re;
                }
            }
            String[] patchLogFile = new String[nodeList.length + 1];
            String[] checkSumLogFile = new String[nodeList.length + 1];
            String[] binary = new String[nodeList.length + 1];
            String[] checksum = new String[nodeList.length + 1];
            f = new File(srcPatchLogFile);
            patchLogFile[0] = f.exists() && f.canRead() ? srcPatchLogFile : "";
            f = new File(srcChecksumLogFile);
            checkSumLogFile[0] = f.exists() && f.canRead() ? srcChecksumLogFile : "";
            buff = new StringBuffer("start printing of patchlists, binary, checksum information");
            OLogger.debug((StringBuffer)buff);
            for (count = 0; count < nodeList.length; ++count) {
                patchLogFile[count + 1] = patchStorageLocation + File.separator + "patch_info_" + nodeList[count] + ".log";
                checkSumLogFile[count + 1] = patchStorageLocation + File.separator + "checksum_info_" + nodeList[count] + ".log";
                f = new File(patchLogFile[count + 1]);
                if (!f.exists() || !f.canRead()) {
                    patchLogFile[count + 1] = "";
                }
                if ((f = new File(checkSumLogFile[count + 1])).exists() && f.canRead()) continue;
                checkSumLogFile[count + 1] = "";
            }
            StringBuffer warnMsg = new StringBuffer("");
            OLogger.println((String)"\nInstalled Patch List(s)");
            OLogger.println((String)"======================\n");
            for (int count3 = 0; count3 < patchLogFile.length; ++count3) {
                String curNode = "";
                try {
                    String buffer;
                    BufferedReader patchBufferReader = new BufferedReader(new FileReader(patchLogFile[count3]));
                    StringBuffer nodeName = new StringBuffer("Node Name : ");
                    if (count3 == 0) {
                        nodeName.append(lNode[0]);
                        curNode = lNode[0];
                    } else {
                        nodeName.append(nodeList[count3 - 1]);
                        curNode = nodeList[count3 - 1];
                    }
                    nodeName.append("\n");
                    int curLen = nodeName.length();
                    for (int i = 0; i < curLen - 1; ++i) {
                        nodeName.append("-");
                    }
                    nodeName.append("\n");
                    OLogger.println((String)nodeName.toString());
                    while ((buffer = patchBufferReader.readLine()) != null) {
                        OLogger.println((String)buffer);
                    }
                    OLogger.println((String)"");
                }
                catch (FileNotFoundException e) {
                    buff = new StringBuffer("");
                    buff.append("Propagated patch log file " + patchLogFile[count3] + "is not found locally for Node : " + curNode);
                    buff.append("\n");
                    buff.append(e.getMessage());
                    RuntimeException re = new RuntimeException(buff.toString(), e);
                    throw re;
                }
                catch (IOException e) {
                    buff = new StringBuffer("");
                    buff.append("Error in reading propagated patch log " + patchLogFile[count3] + "for Node : " + curNode);
                    buff.append("\n");
                    buff.append(e.getMessage());
                    RuntimeException re = new RuntimeException(buff.toString(), e);
                    throw re;
                }
                try {
                    BufferedReader checksumBufferReader = new BufferedReader(new FileReader(checkSumLogFile[count3]));
                    binary[count3] = checksumBufferReader.readLine();
                    checksum[count3] = checksumBufferReader.readLine();
                    continue;
                }
                catch (FileNotFoundException e) {
                    buff = new StringBuffer("");
                    buff.append("Propagated checksum log file " + checkSumLogFile[count3] + "is not found locally for Node :" + curNode);
                    buff.append("\n");
                    buff.append(e.getMessage());
                    RuntimeException re = new RuntimeException(buff.toString(), e);
                    throw re;
                }
                catch (IOException e) {
                    buff = new StringBuffer("");
                    buff.append("Error in reading propagated checksum log " + checkSumLogFile[count3] + "for Node : " + curNode);
                    buff.append("\n");
                    buff.append(e.getMessage());
                    RuntimeException re = new RuntimeException(buff.toString(), e);
                    throw re;
                }
            }
            OLogger.println((String)"\nBinary & Checksum Information");
            OLogger.println((String)"==============================");
            OLogger.println((String)("\n Binary Location : " + oracleHomePath + File.separator + "bin" + File.separator + "oracle"));
            OLogger.println((String)"\n Node\t\t\tSize\t\t\tChecksum");
            OLogger.println((String)" ----\t\t\t----\t\t\t--------");
            String refChecksum = checksum[0];
            String refBinary = binary[0];
            boolean oneTimeCheck = true;
            for (int count4 = 0; count4 < binary.length; ++count4) {
                String curNode;
                if (count4 == 0) {
                    curNode = lNode[0];
                    OLogger.println((String)(" " + lNode[0] + "\t\t" + binary[count4] + "\t\t" + checksum[count4]));
                } else {
                    curNode = nodeList[count4 - 1];
                    OLogger.println((String)(" " + nodeList[count4 - 1] + "\t\t" + binary[count4] + "\t\t" + checksum[count4]));
                }
                if (refChecksum.equals(checksum[count4]) || refBinary.equals(binary[count4])) continue;
                if (oneTimeCheck) {
                    warnMsg.append("The binary and checksum values of the following nodes does not match with that of " + lNode[0] + " (local node) : \n" + curNode);
                    oneTimeCheck = false;
                    continue;
                }
                warnMsg.append("\n" + curNode);
            }
            cleanUpFailure = this.cleanUpLogFiles(patchLogFile, checkSumLogFile);
            if (cleanUpFailure) {
                buff = new StringBuffer("Clean up operation for 'lsinventory -all_nodes' failed.");
                OLogger.printlnOnLog((int)OLogger.INFO, (String)buff.toString());
            }
            if (!(warn = warnMsg.toString()).equals("")) {
                warnMsg.append("\n");
                OLogger.warn((String)"OUI-67124", (Object[])new Object[]{warnMsg.toString()});
                buff = new StringBuffer("All warnings encountered by printAllNodesInfo()");
                buff.append("\n");
                buff.append(warnMsg.toString());
                OLogger.debug((StringBuffer)buff);
            }
            buff = new StringBuffer("printAllNodesInfo returns");
            OLogger.debug((StringBuffer)buff);
        }
    }

    private boolean cleanUpLogFiles(String[] patchLogFile, String[] checkSumLogFile) {
        int count;
        boolean cleanUpFailure = false;
        StringBuffer logMsg = null;
        File f = null;
        for (count = 0; count < patchLogFile.length; ++count) {
            f = new File(patchLogFile[count]);
            try {
                if (!f.exists()) continue;
                f.delete();
                continue;
            }
            catch (Exception e) {
                cleanUpFailure = true;
                logMsg = new StringBuffer("");
                logMsg.append("OPatch may not have successfully deleted the file '" + patchLogFile[count] + "'");
                logMsg.append("\n");
                OLogger.justlog((int)OLogger.INFO, (String)logMsg.toString());
                OLogger.printStackTrace((Throwable)e);
            }
        }
        for (count = 0; count < checkSumLogFile.length; ++count) {
            f = new File(checkSumLogFile[count]);
            try {
                if (!f.exists()) continue;
                f.delete();
                continue;
            }
            catch (Exception e) {
                cleanUpFailure = true;
                logMsg = new StringBuffer("");
                logMsg.append("OPatch may not have successfully deleted the file '" + checkSumLogFile[count] + "'");
                logMsg.append("\n");
                OLogger.justlog((int)OLogger.INFO, (String)logMsg.toString());
                OLogger.printStackTrace((Throwable)e);
            }
        }
        return cleanUpFailure;
    }
}

