/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.product;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.BinaryPatchAction;
import com.oracle.glcm.patch.auto.action.CloneHomePatchAction;
import com.oracle.glcm.patch.auto.action.ImageHomePatchAction;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchReportAction;
import com.oracle.glcm.patch.auto.action.PushImagePatchAction;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.product.CommonProductSupport;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.opatchauto.core.binary.SessionPatches;

public class DefaultProductSupport
extends CommonProductSupport {
    public String getId() {
        return "default";
    }

    public Set<String> getResourceBundles() {
        LinkedHashSet<String> bundles = new LinkedHashSet<String>();
        bundles.add("resources/opatchauto-actions/opatchauto-actions");
        bundles.add("resources/opatchauto-actions/messages");
        return bundles;
    }

    public String getProductDisplayName() {
        return OPatchAutoHelper.getLocalizedString((String)"DefaultProductSupport.display.name", (Object[])new Object[0]);
    }

    public Set<String> getPatchPlans() {
        LinkedHashSet<String> patchPlans = new LinkedHashSet<String>();
        patchPlans.add("rolling");
        patchPlans.add("parallel");
        patchPlans.add("push-image");
        return patchPlans;
    }

    public String getPatchPlanDescription(String patchPlan) {
        if ("rolling".equals(patchPlan)) {
            return OPatchAutoHelper.getLocalizedString((String)"DefaultProductSupport.rolling.patch.plan.description", (Object[])new Object[0]);
        }
        if ("parallel".equals(patchPlan)) {
            return OPatchAutoHelper.getLocalizedString((String)"DefaultProductSupport.parallel.patch.plan.description", (Object[])new Object[0]);
        }
        return super.getPatchPlanDescription(patchPlan);
    }

    protected Set<ProductType> loadProductTypes() {
        LinkedHashSet<ProductType> productTypes = new LinkedHashSet<ProductType>();
        productTypes.add(ProductSupportManager.getDefaultProductType());
        return productTypes;
    }

    public void validatePatchSession(PatchSession patchSession) throws OPatchAutoException {
        String imageLocation;
        OPatchAutoOption phBaseDirOption;
        super.validatePatchSession(patchSession);
        OPatchAutoOption patchLocationOption = patchSession.getOptions().getOption("patch.location");
        if (patchLocationOption.hasValue()) {
            patchLocationOption.validate();
            if (!SessionPatches.isPatchValid((String)patchLocationOption.getValue())) {
                throw new OPatchAutoException("70018", new Object[]{patchLocationOption.getValue()});
            }
        }
        if ((phBaseDirOption = patchSession.getOptions().getOption("patch.base.directory")).hasValue()) {
            phBaseDirOption.validate();
            File phBaseDir = new File(phBaseDirOption.getValue());
            File[] patchDirs = phBaseDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            if (patchDirs == null || patchDirs.length < 1) {
                throw new OPatchAutoException("70019", new Object[]{phBaseDir});
            }
            for (File patchDir : patchDirs) {
                if (SessionPatches.isPatchValid((String)patchDir.getAbsolutePath())) continue;
                throw new OPatchAutoException("70020", new Object[]{patchDir});
            }
        }
        if (!StringUtil.isNullOrEmpty((String)(imageLocation = patchSession.getImageLocation()), (boolean)true) && !patchSession.isCreateImageEnabled()) {
            File imageLocationFile = new File(imageLocation);
            if (imageLocationFile.exists()) {
                if (!imageLocationFile.isFile()) {
                    throw new OPatchAutoException("70021", new Object[]{imageLocation});
                }
            } else {
                throw new OPatchAutoException("70022", new Object[]{imageLocation});
            }
        }
        if (patchSession.isCreateImageEnabled()) {
            Set defaultPatchTargets = patchSession.getPatchPlanManager().getPatchTargets("default");
            Iterator it = defaultPatchTargets.iterator();
            while (it.hasNext()) {
                if (((PatchTarget)it.next()).isHome()) continue;
                it.remove();
            }
            if (defaultPatchTargets.size() > 1) {
                throw new OPatchAutoException("70023", new Object[0]);
            }
        }
    }

    public boolean isSupportedTopology(File topologyFile, OPatchAutoOptions options, CredentialManager credentialManager) throws OPatchAutoException {
        return false;
    }

    public Set<Class<? extends PatchAction>> getPatchActions(OPatchAutoCommand command, OPatchAutoOptions options) {
        HashSet<Class<? extends PatchAction>> actions = new HashSet<Class<? extends PatchAction>>();
        actions.add(PatchReportAction.class);
        actions.add(BinaryPatchAction.class);
        actions.add(CloneHomePatchAction.class);
        actions.add(ImageHomePatchAction.class);
        actions.add(PushImagePatchAction.class);
        return actions;
    }

    public void updateOptions(OPatchAutoOptions options) throws OPatchAutoException {
        super.updateOptions(options);
        if (this.isPushImagePatchPlan(options)) {
            options.getOption("image.location").setRequired(true);
            options.getOption("remote.image.location").setRequired(true);
        }
    }

    public Set<ProductType> getExternalOPatchAutoProductTypes() {
        LinkedHashSet<ProductType> productTypes = new LinkedHashSet<ProductType>();
        productTypes.add(ProductSupportManager.getDefaultProductType());
        return productTypes;
    }

    private boolean isPushImagePatchPlan(OPatchAutoOptions options) throws OPatchAutoException {
        OPatchAutoOption patchPlanOption = options.getOption("patch.plan");
        String patchPlan = patchPlanOption.getValue();
        return "push-image".equals(patchPlan);
    }
}

