/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import com.oracle.cie.remote.RemoteConnectionManager;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.CommonPatchAction;
import com.oracle.glcm.patch.auto.action.OPatchautoActionUtils;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Host;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;

public class PushImagePatchAction
extends CommonPatchAction {
    public PushImagePatchAction() {
        super(new Goal[]{InitPhase.Goal.init});
    }

    public Set<String> getSupportedProductTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(ProductSupportManager.getDefaultProductType().getType());
        return types;
    }

    public boolean isRemoteExecutionHandled(PatchTarget patchTarget) throws OPatchAutoException {
        return true;
    }

    public String getDisplayName() {
        return OPatchAutoHelper.getLocalizedString((String)"PushImagePatchAction.display.name", (Object[])new Object[0]);
    }

    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        block6: {
            try {
                if (!patchTarget.getHost().isRemote()) break block6;
                if (this.getPatchSession().isPushImage()) {
                    return true;
                }
                if (!this.getPatchSession().isApplyImageEnabled()) break block6;
                String localImagePath = this.getPatchSession().getOptions().getOption("image.location").getValue();
                String remoteImagePath = this.getPatchSession().getOptions().getOption("remote.image.location").getValue();
                try {
                    RemoteConnectionHandler connectionHandler = RemoteConnectionManager.getRemoteConnectionManager().getRemoteConnectionHandler((RemoteConnectionHost)patchTarget.getHost());
                    connectionHandler.connect();
                    if (!OPatchautoActionUtils.isFileExistInRemoteHost(connectionHandler, localImagePath, remoteImagePath)) {
                        return true;
                    }
                }
                catch (RemoteConnectionException e) {
                    throw new PatchActionException((Throwable)e);
                }
            }
            catch (OPatchAutoException e) {
                throw new PatchActionException((Throwable)e);
            }
        }
        return false;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public PatchActionResult execute(PatchTarget patchTarget) {
        try {
            String localImagePath = this.getPatchSession().getOptions().getOption("image.location").getValue();
            String remoteImagePath = this.getPatchSession().getOptions().getOption("remote.image.location").getValue();
            if (StringUtil.isNullOrEmpty((String)localImagePath, (boolean)true)) {
                throw new OPatchAutoException("70024", new Object[0]);
            }
            String tempHomeLocation = null;
            if (StringUtil.isNullOrEmpty((String)remoteImagePath, (boolean)true)) {
                String homeLoc = patchTarget.getHome(true).getLocation();
                File localImageLocation = new File(this.getPatchSession().getImageLocation());
                String[] remoteImageInfo = OPatchautoActionUtils.findTmpRemoteImagePath(homeLoc, localImageLocation.getName());
                remoteImagePath = remoteImageInfo[0];
                tempHomeLocation = remoteImageInfo[1];
                this.getPatchSession().getOptions().getOption("remote.image.location").setValue(remoteImagePath);
            }
            File localImage = new File(localImagePath);
            Host host = patchTarget.getHost();
            RemoteConnectionHandler connectionHandler = RemoteConnectionManager.getRemoteConnectionManager().getRemoteConnectionHandler((RemoteConnectionHost)host);
            connectionHandler.connect();
            OPatchautoActionUtils.prepareRemoteLocationForFileTransfer(connectionHandler, remoteImagePath);
            this._logger.info("Pushing local image " + localImage + " to location " + remoteImagePath + " on remote host " + connectionHandler.getHost());
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"BinaryPatchAction.pushing.remote.image", (Object[])new Object[]{connectionHandler.getHost().getHost(), remoteImagePath}));
            connectionHandler.put(remoteImagePath, localImage);
            if (!this.getPatchSession().isPushImage() && !StringUtil.isNullOrEmpty((String)tempHomeLocation)) {
                connectionHandler.deleteOnClose(tempHomeLocation);
            }
        }
        catch (Exception e) {
            return new PatchActionResult((Throwable)e);
        }
        return new PatchActionResult();
    }
}

