/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.action;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.CommonPatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.product.ProductSupport;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.MutablePatchTarget;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

public class CloneHomePatchAction
extends CommonPatchAction {
    public CloneHomePatchAction() {
        super(new Goal[]{OfflinePhase.Goal.binary_patching, OfflinePhase.Goal.finalize_binary_patching});
    }

    public Set<String> getSupportedProductTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(ProductSupportManager.getDefaultProductType().getType());
        return types;
    }

    public int getOrderingWeight(Goal goal) {
        if (goal == OfflinePhase.Goal.binary_patching) {
            return 10;
        }
        return super.getOrderingWeight(goal);
    }

    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        if (this.getPatchSession().isOutOfPlacePatchingEnabled()) {
            if (this.getPatchSession().getCurrentGoal() == OfflinePhase.Goal.binary_patching) {
                Home cloneHome = patchTarget.getHomeClone();
                if (cloneHome == null) {
                    String location;
                    cloneHome = patchTarget.getHome().getShallowCopy();
                    try {
                        location = ComdevHelper.isWindows() ? new File(cloneHome.getLocation()).getCanonicalPath() : cloneHome.getLocation();
                    }
                    catch (IOException e) {
                        throw new PatchActionException("70011", (Throwable)e, new Object[]{cloneHome.getLocation()});
                    }
                    if (location.replace("\\", "/").endsWith("/")) {
                        location = location.substring(0, location.length() - 1);
                    }
                    cloneHome.setLocation(location + "-clone-" + OPatchAutoHelper.getCurrentDateTimeStamp());
                    ((MutablePatchTarget)patchTarget).setHomeClone(cloneHome);
                }
                return true;
            }
            if (this.getPatchSession().getCurrentGoal() == OfflinePhase.Goal.finalize_binary_patching && !this.getPatchSession().isCreateImageEnabled()) {
                return true;
            }
        }
        return false;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public boolean isRemoteOutOfPlaceRequired() {
        return this.getPatchSession().getCurrentGoal() == OfflinePhase.Goal.finalize_binary_patching;
    }

    public PatchActionResult execute(PatchTarget patchTarget) {
        try {
            if (patchTarget.getHomeClone() == null) {
                throw new OPatchAutoException("70012", new Object[0]);
            }
            ProductSupport productSupport = this.getPatchSession().getProductSupportManager().getHomeCloningProductSupport(patchTarget);
            if (productSupport == null) {
                throw new PatchActionException("70013", new Object[]{patchTarget.getHome().getLocation()});
            }
            if (this.getPatchSession().getCurrentGoal() == OfflinePhase.Goal.binary_patching) {
                File sourceHome = new File(patchTarget.getHome(true).getLocation());
                File destHome = new File(patchTarget.getHomeClone().getLocation());
                productSupport.cloneHome(sourceHome, destHome);
            } else if (this.getPatchSession().getCurrentGoal() == OfflinePhase.Goal.finalize_binary_patching) {
                File sourceHome = new File(patchTarget.getHomeClone().getLocation());
                File destHome = new File(patchTarget.getHome(true).getLocation());
                File backupHome = new File(this.getPatchSession().getProductSupportManager().getOptions().getOption("backup.location").getValue());
                productSupport.applyClonedHome(sourceHome, destHome, backupHome, patchTarget.getHome().getInvPtrLoc());
                Delete.delete((File)sourceHome);
            }
        }
        catch (Exception e) {
            return new PatchActionResult((Throwable)e);
        }
        return new PatchActionResult();
    }

    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        if (patchActionResult.isSuccess()) {
            if (this.getPatchSession().getCurrentGoal() == OfflinePhase.Goal.binary_patching) {
                patchTarget.setUsingHomeClone(true);
            } else if (this.getPatchSession().getCurrentGoal() == OfflinePhase.Goal.finalize_binary_patching) {
                patchTarget.setUsingHomeClone(false);
            }
        }
    }

    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        if (this.getPatchSession().getCurrentGoal() == OfflinePhase.Goal.finalize_binary_patching) {
            try {
                container.addPatchActionParameter("backup.location", (Object)this.getPatchSession().getProductSupportManager().getOptions().getOption("backup.location").getValue());
            }
            catch (OPatchAutoException e) {
                throw new PatchActionException((Throwable)e);
            }
        }
    }

    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        String backupLocationVal;
        if (this.getPatchSession().getCurrentGoal() == OfflinePhase.Goal.finalize_binary_patching && !StringUtil.isNullOrEmpty((String)(backupLocationVal = (String)container.getPatchActionParameterValue("backup.location")), (boolean)true)) {
            try {
                patchSession.getProductSupportManager().getOptions().getOption("backup.location").setValue(backupLocationVal);
            }
            catch (OPatchAutoException e) {
                throw new PatchActionException((Throwable)e);
            }
        }
    }
}

