/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.utils.helper;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.topology.DBHomeImpl;
import com.oracle.glcm.patch.auto.db.integration.controller.RemoteContentTransferHandler;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import com.oracle.helper.util.HelperUtility;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class SDBRemoteFileHandlerHelper {
    private static final Logger _log = Logger.getLogger(SDBRemoteFileHandlerHelper.class.getName());
    private static Map<RemoteConnectionHandler, Map<String, String>> filesToBeDeleted = new HashMap<RemoteConnectionHandler, Map<String, String>>();
    private static final int MODE = 775;

    public void writeSDBInstanceFile(RemoteConnectionHandler handler, DBHomeImpl dbHomeImpl, RemoteContentTransferHandler contentHandler, OPatchAutoOptions options, boolean isRemote, String owner, Credential credential) throws OPatchAutoException, RemoteConnectionException {
        String localInstanceDir = this.getSystemInstanceFilePath(options);
        String fileName = "opatch_sdb_config.xml";
        File instanceFile = new File(localInstanceDir + fileName);
        _log.info("SDB Instance path: " + instanceFile.getAbsolutePath());
        String destInstanceDir = this.getDBTmpInstancePath(dbHomeImpl.getLocation(), handler);
        String destInstanceLocation = destInstanceDir + fileName;
        _log.info("Destination SDB Instance file Location : " + destInstanceLocation);
        if (isRemote) {
            this.transferFileToRemoteHost(handler, dbHomeImpl.getOwner(), contentHandler, instanceFile, destInstanceLocation);
            if (!dbHomeImpl.getOwner().equals(owner)) {
                contentHandler.chmod(destInstanceLocation, 775, handler);
            }
        } else if (!dbHomeImpl.getLocation().equals(OPatchAutoHelper.getOPatchAutoHome())) {
            DBPatchingUtil.copyFileToDestLoc(instanceFile, destInstanceDir, owner, credential, true);
        }
        this.addFilesToBeDeleted(handler, destInstanceLocation, owner);
    }

    private String getSystemInstanceFilePath(OPatchAutoOptions options) throws OPatchAutoException {
        String oracleHomePath = OPatchAutoHelper.getOPatchAutoHome();
        String patchId = null;
        String patchInformation = options.getOption("id").getValue();
        if (StringUtil.isNullOrEmpty((String)patchInformation)) {
            patchInformation = options.getOption("patch.location").getValue();
            if (StringUtil.isNullOrEmpty((String)patchInformation, (boolean)true)) {
                patchInformation = options.getOption("patch.base.directory").getValue();
            }
            patchId = new File(patchInformation).getName();
        } else {
            String[] patchIDList = patchInformation.split(",");
            patchId = patchIDList[0];
        }
        String path = SessionData.getConfigDir() + File.separator + patchId + File.separator;
        return path;
    }

    public void transferSysInstForSIDB(RemoteConnectionHandler handler, DBHomeImpl dbHomeImpl, RemoteContentTransferHandler contentHandler, boolean isRemote, String owner, Credential credential, String dbName) throws OPatchAutoException, RemoteConnectionException {
        SystemInstance sysInst = PatchPlanner.getInstance().getSystemInstance();
        if (sysInst != null) {
            List siDatabases = sysInst.getTargetsOfType(SIDatabase.class);
            for (SIDatabase sidb : siDatabases) {
                if (!sidb.getName().equalsIgnoreCase(dbName)) continue;
                try {
                    this.writeSIDBInstanceFile(handler, dbHomeImpl, contentHandler, isRemote, owner, credential, (AbstractBaseTarget)sidb);
                }
                catch (FileNotFoundException e) {
                    _log.throwing(OPatchAutoHelper.getLocalizedString((String)"File.not.found.message", (Object[])new Object[0]), e.getMessage(), e);
                    throw new OPatchAutoException((Throwable)e);
                }
            }
        }
    }

    private void writeSIDBInstanceFile(RemoteConnectionHandler handler, DBHomeImpl dbHomeImpl, RemoteContentTransferHandler contentHandler, boolean isRemote, String owner, Credential credential, AbstractBaseTarget shard) throws OPatchAutoException, FileNotFoundException, RemoteConnectionException {
        SIDatabase sidb = new SIDatabase();
        sidb = (SIDatabase)shard;
        OracleHome oracleHome = sidb.getRuns_from();
        Host host = sidb.getHost();
        SystemInstance sysInst = new SystemInstance();
        sysInst.getEntities().add(sidb);
        sysInst.getEntities().add(host);
        sysInst.getEntities().add(oracleHome);
        String localInstanceDir = OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB_INSTANCE;
        String sidbfile = localInstanceDir + "opatch_sidb_" + sidb.getName() + "_config.xml";
        File sysInstFile = this.createSystemInstanceXML(sidbfile);
        sysInst.writeFile(sysInstFile);
        _log.info("created sidb system instance file: " + sidbfile);
        String destInstanceDir = this.getDBTmpInstancePath(dbHomeImpl.getLocation(), handler);
        String destInstance = destInstanceDir + sysInstFile.getName();
        _log.info("Destination InstanceDir : " + destInstance);
        if (isRemote) {
            this.transferFileToRemoteHost(handler, dbHomeImpl.getOwner(), contentHandler, sysInstFile, destInstance);
            if (!dbHomeImpl.getOwner().equals(owner)) {
                contentHandler.chmod(destInstance, 775, handler);
            }
        } else if (!dbHomeImpl.getLocation().equals(OPatchAutoHelper.getOPatchAutoHome())) {
            DBPatchingUtil.copyFileToDestLoc(sysInstFile, destInstanceDir, owner, credential, true);
        }
        this.addFilesToBeDeleted(handler, destInstance, owner);
    }

    private File createSystemInstanceXML(String filePath) {
        String owner = OUIDriver.checkFileOwner((File)new File(System.getProperty("ORACLE_HOME"), DBCommonPatchingConstants.OPATCHAUTO_DB_SCRIPT));
        DBPatchingUtil.createNewFile(filePath, owner, null);
        File configXML = new File(filePath);
        return configXML;
    }

    public void persistSessionID(RemoteConnectionHandler handler, DBHomeImpl dbHomeImpl, RemoteContentTransferHandler contentHandler, boolean isRemote, String owner, Credential credential) throws OPatchAutoException, RemoteConnectionException {
        String currentHostName = OPatchAutoHelper.getOPatchAutoHost();
        if (currentHostName != null && currentHostName.indexOf(".") != -1) {
            currentHostName = currentHostName.substring(0, currentHostName.indexOf("."));
        }
        String localFilePath = SessionData.getConfigDir() + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "localSessionInfoFile_" + currentHostName + ".txt";
        File localSessionInfoFile = new File(localFilePath);
        _log.info("local SessionInfo File : " + localSessionInfoFile.getAbsolutePath());
        String destSessionInfoLocation = HelperUtility.detectOraBaseConfig((String)dbHomeImpl.getLocation()) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "sessioninfo.txt";
        _log.info("Destination SessionInfo Location : " + destSessionInfoLocation);
        if (isRemote) {
            this.transferFileToRemoteHost(handler, dbHomeImpl.getOwner(), contentHandler, localSessionInfoFile, destSessionInfoLocation);
            if (!dbHomeImpl.getOwner().equals(owner)) {
                contentHandler.chmod(destSessionInfoLocation, 775, handler);
            }
        } else {
            String copyCmd;
            GISystemCall.ExecReturn er;
            if (new File(destSessionInfoLocation).exists()) {
                new File(destSessionInfoLocation).delete();
            }
            if (!(er = GISystemCall.process(copyCmd = DBPatchingUtil.getCopyCmd(localSessionInfoFile) + localSessionInfoFile.getAbsolutePath() + " " + destSessionInfoLocation, owner, credential)).isOK()) {
                _log.log(Level.WARNING, er.getErrorMessage());
            }
        }
        this.addFilesToBeDeleted(handler, destSessionInfoLocation, owner);
    }

    public void writeWallet(RemoteConnectionHandler handler, DBHomeImpl dbHomeImpl, CredentialManager credentialManager, RemoteContentTransferHandler contentHandler, boolean isRemote, String owner, Credential credential) throws OPatchAutoException, RemoteConnectionException {
        File wallet = credentialManager.getWalletLocation();
        if (wallet != null) {
            _log.info("Wallet Path : " + wallet.getAbsolutePath());
            String walletDir = this.getDBTmpSdbPath(dbHomeImpl.getLocation(), handler) + "wallet" + File.separator;
            String destWalletLocation = walletDir + wallet.getName();
            _log.info("Destination Wallet Location : " + destWalletLocation);
            if (isRemote) {
                if (!dbHomeImpl.getOwner().equals(owner)) {
                    try {
                        this.runMkdirAndChmod(contentHandler, walletDir, handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS, dbHomeImpl.getOwner(), credential);
                    }
                    catch (RemoteConnectionException e) {
                        this.deleteDestinationFile(handler, walletDir, dbHomeImpl.getOwner());
                        throw new OPatchAutoException((Throwable)e);
                    }
                    this.transferFileToRemoteHost(handler, dbHomeImpl.getOwner(), contentHandler, wallet, destWalletLocation);
                    contentHandler.chmod(destWalletLocation, 775, handler);
                } else {
                    try {
                        contentHandler.mkDirOnRemoteHost(walletDir, handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS);
                    }
                    catch (RemoteConnectionException e) {
                        this.deleteDestinationFile(handler, walletDir, dbHomeImpl.getOwner());
                        throw new OPatchAutoException((Throwable)e);
                    }
                    this.transferFileToRemoteHost(handler, owner, contentHandler, wallet, destWalletLocation);
                }
            } else if (!dbHomeImpl.getLocation().equals(OPatchAutoHelper.getOPatchAutoHome())) {
                DBPatchingUtil.mkdirs(walletDir, owner, credential);
                DBPatchingUtil.copyFileToDestLoc(wallet, walletDir, owner, credential, true);
            }
            this.addFilesToBeDeleted(handler, destWalletLocation, owner);
            this.addFilesToBeDeleted(handler, walletDir, owner);
        }
    }

    public void unzipPatch(RemoteConnectionHandler handler, RemoteContentTransferHandler contentHandler, HostImpl host, DBHomeImpl dbHomeImpl, String owner, Credential credential) throws OPatchAutoException {
        File patchZipLocationFile = new File(System.getProperty("patch.zip.location"));
        String patchName = patchZipLocationFile.getName().split("\\.")[0];
        String patchZipLocation = host.getPatchLocation() + patchZipLocationFile.getName();
        _log.info("Destination Patch Zip Location : " + patchZipLocation);
        String destPatchZipLocation = dbHomeImpl.getLocation() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB + patchName + File.separator;
        _log.info("Destination PatchLocation : " + destPatchZipLocation);
        if (host.isRemote()) {
            if (!owner.equals(dbHomeImpl.getOwner())) {
                try {
                    contentHandler.unzipPatchOnRemote(handler, dbHomeImpl.getLocation(), patchZipLocation, destPatchZipLocation, dbHomeImpl.getOwner(), credential, null);
                }
                catch (RemoteConnectionException e) {
                    this.deleteDestinationFile(handler, destPatchZipLocation, dbHomeImpl.getOwner());
                    throw new OPatchAutoException((Throwable)e);
                }
            } else {
                try {
                    contentHandler.unzipPatchOnRemote(handler, dbHomeImpl.getLocation(), patchZipLocation, destPatchZipLocation, null);
                }
                catch (RemoteConnectionException e) {
                    this.deleteDestinationFile(handler, destPatchZipLocation, dbHomeImpl.getOwner());
                    throw new OPatchAutoException((Throwable)e);
                }
            }
        } else if (!dbHomeImpl.getLocation().equals(OPatchAutoHelper.getOPatchAutoHome())) {
            DBPatchingUtil.unzip(dbHomeImpl.getLocation(), patchZipLocationFile.getAbsolutePath(), this.getDBTmpSdbPath(dbHomeImpl.getLocation(), handler), owner, credential);
        }
        this.addFilesToBeDeleted(handler, destPatchZipLocation, owner);
        this.addFilesToBeDeleted(handler, patchZipLocation, owner);
    }

    public void copyPatchZip(RemoteConnectionHandler handler, RemoteContentTransferHandler contentHandler, HostImpl host, String owner) throws OPatchAutoException, RemoteConnectionException {
        String patchZipLocation = System.getProperty("patch.zip.location");
        File localZipLocationFile = new File(patchZipLocation);
        _log.info("Local Zip Location : " + localZipLocationFile.getAbsolutePath());
        String destPatchZipLocation = host.getPatchLocation() + localZipLocationFile.getName();
        _log.info("Destination PatchZipLocation : " + destPatchZipLocation);
        if (host.isRemote()) {
            this.transferFileToRemoteHost(handler, owner, contentHandler, localZipLocationFile, destPatchZipLocation);
            contentHandler.chmod(destPatchZipLocation, 775, handler);
        }
        this.addFilesToBeDeleted(handler, destPatchZipLocation, owner);
    }

    public Map<RemoteConnectionHandler, Map<String, String>> getFilesToBeDeleted() {
        return filesToBeDeleted;
    }

    private void addFilesToBeDeleted(RemoteConnectionHandler remoteHostHandler, String fileName, String owner) {
        if (filesToBeDeleted.get(remoteHostHandler) == null) {
            HashMap<String, String> ownerPathMap = new HashMap<String, String>();
            ownerPathMap.put(fileName, owner);
            filesToBeDeleted.put(remoteHostHandler, ownerPathMap);
        } else {
            filesToBeDeleted.get(remoteHostHandler).put(fileName, owner);
        }
    }

    private void runMkdirAndChmod(RemoteContentTransferHandler contentHandler, String location, RemoteConnectionHandler handler, RemoteContentTransferHandler.DeleteStatus deleteStatus, String owner, Credential credential) throws RemoteConnectionException, OPatchAutoException {
        try {
            contentHandler.mkDirOnRemoteHost(location, handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS, owner, credential);
        }
        catch (RemoteConnectionException e) {
            throw new OPatchAutoException((Throwable)e);
        }
        contentHandler.chmod(location, 775, handler, owner, credential);
    }

    public void createRemoteFolder(RemoteContentTransferHandler contentHandler, RemoteConnectionHandler handler, DBHomeImpl dbHomeImpl, String owner, Credential credential) throws RemoteConnectionException, OPatchAutoException {
        String oracleHomeLoc = dbHomeImpl.getLocation();
        if (!dbHomeImpl.getOwner().equals(owner)) {
            this.runMkdirAndChmod(contentHandler, this.getDBTmpPath(oracleHomeLoc, handler), handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS, dbHomeImpl.getOwner(), credential);
            this.runMkdirAndChmod(contentHandler, this.getDBTmpSdbPath(oracleHomeLoc, handler), handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS, dbHomeImpl.getOwner(), credential);
            this.runMkdirAndChmod(contentHandler, this.getDBSessionInfoPath(oracleHomeLoc, handler), handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS, dbHomeImpl.getOwner(), credential);
            this.runMkdirAndChmod(contentHandler, this.getDBTmpInstancePath(oracleHomeLoc, handler), handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS, dbHomeImpl.getOwner(), credential);
            this.runMkdirAndChmod(contentHandler, this.getSDBTmpPath(oracleHomeLoc, handler), handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS, dbHomeImpl.getOwner(), credential);
            this.runMkdirAndChmod(contentHandler, this.getDGTmpPath(oracleHomeLoc, handler), handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS, dbHomeImpl.getOwner(), credential);
            this.addFilesToBeDeleted(handler, this.getDBTmpInstancePath(oracleHomeLoc, handler), owner);
        } else {
            contentHandler.mkDirOnRemoteHost(HelperUtility.detectOraBaseConfig((String)oracleHomeLoc, (RemoteConnectionHandler)handler) + File.separator + "opatchautocfg", handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS);
            contentHandler.mkDirOnRemoteHost(HelperUtility.detectOraBaseConfig((String)oracleHomeLoc, (RemoteConnectionHandler)handler) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR, handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS);
            contentHandler.mkDirOnRemoteHost(this.getDBTmpPath(oracleHomeLoc, handler), handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS);
            contentHandler.mkDirOnRemoteHost(this.getDBTmpSdbPath(oracleHomeLoc, handler), handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS);
            contentHandler.mkDirOnRemoteHost(this.getDBSessionInfoPath(oracleHomeLoc, handler), handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS);
            contentHandler.mkDirOnRemoteHost(this.getDBTmpInstancePath(oracleHomeLoc, handler), handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS);
            contentHandler.mkDirOnRemoteHost(this.getSDBTmpPath(oracleHomeLoc, handler), handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS);
            contentHandler.mkDirOnRemoteHost(this.getDGTmpPath(oracleHomeLoc, handler), handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS);
            this.addFilesToBeDeleted(handler, this.getDBTmpInstancePath(oracleHomeLoc, handler), owner);
        }
    }

    private String getDBTmpInstancePath(String oracleHomeLoc, RemoteConnectionHandler handler) throws OPatchAutoException {
        return HelperUtility.detectOraBaseConfig((String)oracleHomeLoc, (RemoteConnectionHandler)handler) + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB_INSTANCE;
    }

    private String getDBTmpPath(String oracleHomeLoc, RemoteConnectionHandler handler) throws OPatchAutoException {
        return HelperUtility.detectOraBaseConfig((String)oracleHomeLoc, (RemoteConnectionHandler)handler) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_DBTMP_DIR;
    }

    private String getSDBTmpPath(String oracleHomeLoc, RemoteConnectionHandler handler) throws OPatchAutoException {
        return HelperUtility.detectOraBaseConfig((String)oracleHomeLoc, (RemoteConnectionHandler)handler) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "opatchauto-sdb-tmp";
    }

    private String getDGTmpPath(String oracleHomeLoc, RemoteConnectionHandler handler) throws OPatchAutoException {
        return HelperUtility.detectOraBaseConfig((String)oracleHomeLoc, (RemoteConnectionHandler)handler) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "opatchauto-dg-tmp";
    }

    private String getDBSessionInfoPath(String oracleHomeLoc, RemoteConnectionHandler handler) throws OPatchAutoException {
        return HelperUtility.detectOraBaseConfig((String)oracleHomeLoc, (RemoteConnectionHandler)handler) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR;
    }

    private String getDBTmpSdbPath(String oracleHomeLoc, RemoteConnectionHandler handler) throws OPatchAutoException {
        return HelperUtility.detectOraBaseConfig((String)oracleHomeLoc, (RemoteConnectionHandler)handler) + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB;
    }

    public void persistRootSession(RemoteConnectionHandler handler, String homePath, RemoteContentTransferHandler contentHandler, boolean isRemote, String owner, Credential credential, File localRootSessionInfoFile) throws OPatchAutoException, RemoteConnectionException {
        String destRootSessionInfoFilePath = HelperUtility.detectOraBaseConfig((String)homePath) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "rootSessionInfoFile.txt";
        _log.info("dest root SessionInfo File : " + destRootSessionInfoFilePath);
        String destSessionInfoPath = HelperUtility.detectOraBaseConfig((String)homePath) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "sessioninfo.txt";
        _log.info("dest SessionInfo File : " + destSessionInfoPath);
        _log.info("local SessionInfo File : " + localRootSessionInfoFile);
        if (isRemote) {
            this.deleteDestinationFile(handler, destRootSessionInfoFilePath, owner);
            this.deleteDestinationFile(handler, destSessionInfoPath, owner);
            if (!owner.equals(handler.getHost().getUsername())) {
                this.transferFileToRemoteHost(handler, owner, contentHandler, localRootSessionInfoFile, destRootSessionInfoFilePath);
                contentHandler.chmod(destRootSessionInfoFilePath, 775, handler);
            } else {
                this.transferFileToRemoteHost(handler, owner, contentHandler, localRootSessionInfoFile, destRootSessionInfoFilePath);
            }
        } else if (!homePath.equals(OPatchAutoHelper.getOPatchAutoHome())) {
            DBPatchingUtil.copyFileToDestLoc(localRootSessionInfoFile, destRootSessionInfoFilePath, owner, credential, true);
            if (!owner.equals(handler.getHost().getUsername())) {
                IOUtils.chmodTo775(new File(destRootSessionInfoFilePath), null);
            }
        }
    }

    public void deleteDestinationFile(RemoteConnectionHandler handler, String destFilePath, String remoteHomeowner) throws OPatchAutoException {
        try {
            if (handler.exists(destFilePath)) {
                if (!remoteHomeowner.equals(handler.getHost().getUsername())) {
                    handler.exec("echo '" + new String(handler.getHost().getPassword()) + "'" + " | sudo -S -u " + remoteHomeowner + " rm -rf \"" + destFilePath + "\"");
                } else {
                    handler.delete(destFilePath, true, false);
                }
            }
        }
        catch (RemoteConnectionException e) {
            _log.throwing("Exception while deleting remote file : " + destFilePath, e.getMessage(), e);
        }
    }

    private void transferFileToRemoteHost(RemoteConnectionHandler handler, String owner, RemoteContentTransferHandler contentHandler, File fileToTransfer, String destLocation) throws OPatchAutoException {
        try {
            contentHandler.transferFileToRemoteHost(destLocation, fileToTransfer, handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_SUCCESS);
        }
        catch (RemoteConnectionException e) {
            this.deleteDestinationFile(handler, destLocation, owner);
            throw new OPatchAutoException((Throwable)e);
        }
    }
}

