/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import dbmodel.common.Host;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class RemoteGIStatusValidation
implements IValidator {
    Logger logger = Logger.getLogger(RemoteGIStatusValidation.class.getName());
    private MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
    private final ArrayList<String> runningHosts = SessionData.getInstance().getRunningHosts();
    private final boolean isLocalCRSUp = SessionData.getInstance().isLocalCRSUp();
    private final List<String> remoteNodes = SessionData.getInstance().getRemoteList();

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        boolean bl;
        boolean remotePatching = (Boolean)params.get(ValidationParamKey.REMOTE_PATCHING.ordinal());
        boolean isAnalyzeMode = (Boolean)params.get(ValidationParamKey.ANALYZE_OPTION.ordinal());
        if (isAnalyzeMode && !remotePatching) {
            this.logger.info("This is a local node analyze session.");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "CRS Validations will be skipped for local node analyze sessions."));
            return this.multipleValidationResult;
        }
        ClusterInformationLoader.CrsType crsType = ClusterInformationLoader.getInstance().getCRSType();
        this.logger.info("CRS Type is detected to be " + crsType);
        if (ClusterInformationLoader.getInstance().getCRSType().equals((Object)ClusterInformationLoader.CrsType.SOFTWARE_INSTALLATION_ONLY)) {
            this.logger.info("Grid home is a software-only installation");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "CRS Validations will be skipped for a software-only home."));
            return this.multipleValidationResult;
        }
        if (SessionData.getInstance().isCrsStateValidated()) {
            this.logger.info("CRS Status has already been validated");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "CRS Status has already been validated"));
            return this.multipleValidationResult;
        }
        this.logger.info("Checking the CRS status and session state across the entire cluster");
        boolean validationSuccess = true;
        ConfigGraph configGraph = (ConfigGraph)params.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
        List<Host> hostModelList = configGraph.getTargets(Host.class);
        this.logger.info("Size of the host list is : " + hostModelList.size());
        List<OracleHome> oracleHomes = configGraph.getTargets(OracleHome.class);
        String crsHome = null;
        String crsOwner = null;
        boolean isSiha = false;
        Object clonePath = null;
        for (OracleHome oracleHome : oracleHomes) {
            if (oracleHome.getHomeType().equals("crs")) {
                crsHome = oracleHome.getPath();
                crsOwner = oracleHome.getOwner();
                break;
            }
            if (!oracleHome.getHomeType().equals("siha")) continue;
            crsHome = oracleHome.getPath();
            crsOwner = oracleHome.getOwner();
            isSiha = true;
            break;
        }
        this.logger.info("Is SIHA: " + isSiha);
        String localHost = "";
        for (Host host : hostModelList) {
            if (DBPatchingHelper.isRemoteHost(host)) continue;
            localHost = host.getHostName();
            break;
        }
        if (crsHome == null) {
            SessionData.getInstance().setCrsStateValidated(true);
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "CRS Home not being patched in this session."));
            return this.multipleValidationResult;
        }
        boolean bl2 = false;
        if (((Boolean)params.get(ValidationParamKey.NONROLLING_OPTION.ordinal())).booleanValue()) {
            bl = (Boolean)params.get(ValidationParamKey.NONROLLING_OPTION.ordinal());
        }
        boolean firstNode = false;
        String wallet = (String)params.get(ValidationParamKey.WALLET_LOC.ordinal());
        CredentialManager credManager = new CredentialManager();
        Credential credential = null;
        char[] pwd = null;
        try {
            this.logger.fine("Using wallet file from " + wallet);
            credManager.setWallet(new File(wallet), pwd);
            credential = credManager.getCredential(localHost, null, crsOwner);
        }
        catch (OPatchAutoException e) {
            credential = null;
            this.logger.info("Credential not found for user " + crsOwner + " on " + localHost);
        }
        if (credential == null && remotePatching) {
            SessionData.getInstance().setRemoteStateUnknown(true);
            this.logger.warning("NOTE: Wallet File does not contain grid home credentials. Hence, the remote mode of patching cannot proceed.");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, null, " CRS home credentials not available in the wallet"));
            return this.multipleValidationResult;
        }
        if (!isSiha && this.remoteNodes.size() < 1) {
            SessionData.getInstance().setInitiatedHosts(new String[0]);
            this.logger.info("Grid is a single node cluster installation");
            if (!this.isTwelveTwoAboveHome(new String[]{crsHome})) {
                if (bl) {
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "CRS Validations will be skipped for a single node GI."));
                } else {
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.SINGLE_NODE_GRID_NONROLLING, "Identified single node Grid installation, it needs to be executed in non-rolling mode."));
                }
            } else {
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "CRS Validations will be skipped for a single node GI."));
            }
            return this.multipleValidationResult;
        }
        firstNode = this.isFirstNodeOfPatching(crsHome, crsOwner, credential, localHost, this.remoteNodes.toArray(new String[0]), isSiha, wallet, pwd);
        this.logger.info("First node of patching :" + firstNode);
        String reason = null;
        DBValidationFailureReason reasonCode = null;
        if (firstNode && !isSiha) {
            if (!this.isLocalCRSUp) {
                validationSuccess = false;
                reason = "This is the start of a new GI patching session, CRS must be up and running on the local node.";
                reasonCode = DBValidationFailureReason.LOCAL_GI_NOT_RUNNING_FIRSTNODE;
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, reasonCode, reason));
            }
            if (!bl) {
                boolean minRUVersion = this.checkMinRUVersion(crsHome, crsOwner, credential, wallet, pwd);
                int expectedMinSize = !minRUVersion ? (this.isLocalCRSUp ? 2 : 1) : 1;
                if (this.runningHosts.size() < expectedMinSize) {
                    validationSuccess = false;
                    reason = "This is the start of a new GI patching session in rolling mode on this cluster. CRS must be running on at least 1 remote node.";
                    reasonCode = DBValidationFailureReason.REMOTE_GI_NOT_RUNNING_ROLLING;
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, reasonCode, reason));
                }
            }
            if (bl && !remotePatching) {
                int expectedMaxSize;
                int n = expectedMaxSize = this.isLocalCRSUp ? 1 : 0;
                if (this.runningHosts.size() > expectedMaxSize) {
                    validationSuccess = false;
                    StringBuilder remoteActiveHosts = new StringBuilder();
                    for (String host : this.runningHosts) {
                        if (host.equals(localHost)) continue;
                        remoteActiveHosts.append(host).append(",");
                    }
                    if (!StringUtil.isNullOrEmpty((String)remoteActiveHosts.toString())) {
                        remoteActiveHosts.deleteCharAt(remoteActiveHosts.length() - 1);
                    }
                    reason = "This is the start of a new GI patching session in non-rolling mode on this cluster. CRS must be stopped on ALL the remote nodes.";
                    reasonCode = DBValidationFailureReason.REMOTE_GI_RUNNING_NONROLLING;
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, reasonCode, remoteActiveHosts.toString()));
                }
            }
        } else if (!firstNode && !isSiha && remotePatching) {
            validationSuccess = false;
            reason = "A patching session on this cluster has been previously initiated. Remote mode of patching cannot be initiated without completing previous session.";
            reasonCode = DBValidationFailureReason.REMOTE_MODE_NOT_FIRSTNODE;
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, reasonCode, reason));
        }
        if (validationSuccess) {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, " Validation Successful"));
            SessionData.getInstance().setCrsStateValidated(true);
        }
        return this.multipleValidationResult;
    }

    private boolean isTwelveTwoAboveHome(String[] homeList) {
        ArrayList<String> ohList = new ArrayList<String>();
        for (String home : homeList) {
            ohList.add(home.trim());
        }
        List homes = OUIDriver.getLocalInfo(ohList);
        for (OracleHome oh : homes) {
            this.logger.info("oh: " + oh.getPath());
            List ouiComp = oh.getTopLevelOUI();
            String version = ((OUIComponent)ouiComp.get(0)).getVersion();
            this.logger.info("version: " + version);
            if (!DBPatchingUtil.isVersionEqalOrlater(version, "12.2.0.1.0")) continue;
            return true;
        }
        return false;
    }

    private boolean isFirstNodeOfPatching(String crsHome, String owner, Credential credential, String localHost, String[] remoteArray, boolean isSiha, String wallet, char[] walletPwd) {
        boolean first = true;
        if (isSiha) {
            this.logger.info("This is a SIHA environment, state file will not be checked.");
            SessionData.getInstance().setInitiatedHosts(new String[0]);
            return true;
        }
        this.logger.info("Checking the session state across the entire cluster");
        String[] initiatedRemoteNodes = null;
        if (remoteArray != null && remoteArray.length > 0) {
            initiatedRemoteNodes = DBPatchingHelper.fetchPreInitiatedNodes(crsHome, remoteArray, crsHome, wallet, walletPwd);
        }
        if (null != initiatedRemoteNodes) {
            if (initiatedRemoteNodes.length > 0) {
                this.logger.info("Total remote nodes with pre-initiated patch sessions is " + initiatedRemoteNodes.length);
                first = false;
                for (int i = 0; i < initiatedRemoteNodes.length; ++i) {
                    this.logger.info("Session was already initiated on host " + initiatedRemoteNodes[i]);
                }
            } else {
                this.logger.info("This is the start of a new patching session on the cluster");
            }
        } else {
            initiatedRemoteNodes = new String[]{};
            this.logger.info("This is the start of a new patching session on the cluster, pre-initiated remote node list is empty");
        }
        SessionData.getInstance().setInitiatedHosts(initiatedRemoteNodes);
        return first;
    }

    private boolean checkMinRUVersion(String crsHome, String owner, Credential credential, String wallet, char[] walletPwd) {
        boolean versionOK = false;
        String fullRUVersion = "";
        String min21RUVersion = "21.5.0.0.0";
        String min19RUVersion = "19.15.0.0.0";
        String commandToExecute = crsHome + File.separator + "bin" + File.separator + "oraversion -compositeVersion";
        try {
            GISystemCall.ExecReturn ret = GISystemCall.process(commandToExecute, owner, credential);
            if (!ret.isOK()) {
                this.logger.info("Failed to check RU version.");
                return false;
            }
            String version = "";
            fullRUVersion = ret.getNormalMessage().trim();
            this.logger.info("Full RU version is " + fullRUVersion + "\n");
            if (fullRUVersion.startsWith("21")) {
                versionOK = DBPatchingUtil.isVersionEqalOrlater(fullRUVersion, min21RUVersion);
                this.logger.info("versionChk21RU " + versionOK + "\n");
            } else if (fullRUVersion.startsWith("19")) {
                versionOK = DBPatchingUtil.isVersionEqalOrlater(fullRUVersion, min19RUVersion);
                this.logger.info("versionChk19RU " + versionOK + "\n");
            } else {
                versionOK = false;
            }
        }
        catch (Exception e) {
            this.logger.info("Failed to check full RU version. Hence, minimum RU version check is skipped ");
            return false;
        }
        return versionOK;
    }
}

