/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.sdk.cookies.SkipTargetCookie;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationUtil;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSObjectValidator;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RACversionCRSValidator
implements IValidator {
    Logger logger = Logger.getLogger(RACversionCRSValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.INFO, "Invoking rule to ensure that CRS has a greater version than the RAC DBs");
        CRSObjectValidator crsObjectValidator = new CRSObjectValidator();
        crsObjectValidator.setClazz(RACversionCRSValidator.class);
        MultipleValidationResult multipleValidationResult = crsObjectValidator.validate(params);
        if (this.getFailureResult(multipleValidationResult)) {
            return multipleValidationResult;
        }
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        CRSCluster crs = (CRSCluster)systemInst.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        list.add(crs);
        List racs = crs.getDbRAC();
        String message = null;
        String formattedMsg = "";
        ArrayList<BaseClass> noInstances = new ArrayList<BaseClass>();
        if (racs != null && !racs.isEmpty()) {
            for (RACDatabase rac : racs) {
                if (rac.getDbInstances() != null && !rac.getDbInstances().isEmpty()) continue;
                this.logger.log(Level.INFO, "There are RAC Databases with no instances associated");
                noInstances.add((BaseClass)rac);
            }
        }
        if (!noInstances.isEmpty()) {
            message = BundleUtils.getMessage(RACversionCRSValidator.class, "NO_RACINSTANCE", BundleUtils.makeStringOutOfList(noInstances));
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_RACINSTANCE, noInstances));
            formattedMsg = ValidationUtil.getFormattedMessage(noInstances, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, formattedMsg);
            return multipleValidationResult;
        }
        String verCRS = crs.getVersion();
        ArrayList<BaseClass> instMissingVersion = new ArrayList<BaseClass>();
        ArrayList<BaseClass> wrongVersion = new ArrayList<BaseClass>();
        if (racs != null && !racs.isEmpty()) {
            for (RACDatabase rac : racs) {
                String verRAC = null;
                if (rac.getProperty(SkipTargetCookie.class) != null) continue;
                for (RACDBInstance instance : rac.getDbInstances()) {
                    String verInst = instance.getVersion();
                    if (verInst == null) {
                        instMissingVersion.add((BaseClass)instance);
                        continue;
                    }
                    if (verRAC != null) continue;
                    verRAC = verInst;
                }
                if (verCRS == null || verRAC == null) continue;
                String crsVersion = this.formattedVersion(verCRS);
                String racVersion = this.formattedVersion(verRAC);
                if (crsVersion.trim().compareToIgnoreCase(racVersion.trim()) >= 0) continue;
                wrongVersion.add((BaseClass)rac);
            }
        }
        if (!instMissingVersion.isEmpty()) {
            message = BundleUtils.getMessage(RACversionCRSValidator.class, "MISSING_VERSION", BundleUtils.makeStringOutOfList(instMissingVersion));
            formattedMsg = ValidationUtil.getFormattedMessage(instMissingVersion, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, formattedMsg);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.MISSING_VERSION, instMissingVersion));
        }
        if (!wrongVersion.isEmpty()) {
            message = BundleUtils.getMessage(RACversionCRSValidator.class, "RAC_VERSION_GREATER_THAN_CRS", BundleUtils.makeStringOutOfList(wrongVersion));
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.RAC_VERSION_GREATER_THAN_CRS, wrongVersion));
            formattedMsg = ValidationUtil.getFormattedMessage(wrongVersion, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, formattedMsg);
            return multipleValidationResult;
        }
        message = " CRS version is greater or equal to RAC";
        this.logger.log(Level.INFO, message);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }

    private boolean getFailureResult(MultipleValidationResult multipleValidationResult) {
        for (ValidationResult validationResult : multipleValidationResult.getValidationResultList()) {
            if (validationResult.getStatus() != ValidationResult.ValidationStatus.FAILED || validationResult.getFailureReason().equals(DBValidationFailureReason.MISSING_VERSION)) continue;
            return true;
        }
        return false;
    }

    private String formattedVersion(String formattedVersion) {
        if (formattedVersion.split("\\.").length == 5) {
            formattedVersion = formattedVersion.substring(0, formattedVersion.lastIndexOf("."));
        }
        return formattedVersion;
    }
}

