/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.controller.CommandExecutionThread;
import com.oracle.glcm.patch.auto.db.integration.controller.ExecutionCommand;
import com.oracle.glcm.patch.auto.db.integration.controller.ParallelExecution;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class RACNonRollingValidator
implements IValidator {
    Logger logger = Logger.getLogger(RACNonRollingValidator.class.getName());
    private MultipleValidationResult multipleValidationResult = new MultipleValidationResult();

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.INFO, "Running validation of remote node status for RAC nonrolling patching.");
        ClusterInformationLoader.CrsType crsType = ClusterInformationLoader.getInstance().getCRSType();
        this.logger.info("CRS Type is detected to be " + crsType);
        if (crsType.equals((Object)ClusterInformationLoader.CrsType.SOFTWARE_INSTALLATION_ONLY)) {
            this.logger.info("Grid home is a software-only installation");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "RAC NonRolling validation is not required for a software-only installation."));
            return this.multipleValidationResult;
        }
        ConfigGraph configGraph = (ConfigGraph)params.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
        List<Host> hostModelList = configGraph.getTargets(Host.class);
        List<OracleHome> oracleHomes = configGraph.getTargets(OracleHome.class);
        boolean isCRS = false;
        boolean isSiha = false;
        for (OracleHome oh : oracleHomes) {
            if (oh.getHomeType().equals("crs")) {
                isCRS = true;
                break;
            }
            if (!oh.getHomeType().equals("siha")) continue;
            isSiha = true;
            break;
        }
        if (isSiha || isCRS) {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "RAC Non-rolling validator is not required if CRS is also being patched."));
            return this.multipleValidationResult;
        }
        boolean isOOPEnabled = false;
        if (params.get(ValidationParamKey.OOP_ENABLED.ordinal()) != null && (isOOPEnabled = ((Boolean)params.get(ValidationParamKey.OOP_ENABLED.ordinal())).booleanValue())) {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "RAC Non-rolling validator is not required for OOP patching."));
            return this.multipleValidationResult;
        }
        boolean isAnyRemoteDBRunning = false;
        OPatchAutoCommand operation = (OPatchAutoCommand)params.get(ValidationParamKey.OPERATION.ordinal());
        PatchTarget patchTarget = (PatchTarget)params.get(ValidationParamKey.PATCH_TARGET.ordinal());
        String home = patchTarget.getHome().getLocation();
        boolean firstNodeForAllPatches = DBPatchingHelper.isFirstNodeForAllPatches(home, SessionData.getInstance().getHostPatchDataMap(home), operation.isRollback());
        if (!firstNodeForAllPatches) {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "This is not the first node of patching for ALL patches."));
            return this.multipleValidationResult;
        }
        try {
            if (this.isDBRunningOnAnyNode(home)) {
                isAnyRemoteDBRunning = true;
            }
        }
        catch (Exception e) {
            this.logger.info("Unable to verify DB status for remote home " + home);
        }
        if (isAnyRemoteDBRunning) {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.REMOTE_DB_RUNNING_IN_NONROLLING, null));
            return this.multipleValidationResult;
        }
        return this.multipleValidationResult;
    }

    private boolean isDBRunningOnAnyNode(String home) {
        ArrayList<String> hosts = new ArrayList<String>(SessionData.getInstance().getHostPatchDataMap(home).keySet());
        this.logger.info("Set of Hosts for the selected home " + home + " is : " + hosts.toString());
        String owner = OUIDriver.checkFileOwner((File)new File(home, "oraInst.loc"));
        ArrayList<ExecutionCommand> remoteStatusCmds = new ArrayList<ExecutionCommand>();
        String statusCmd = home + File.separator + DBCommonPatchingConstants.HOME_STATUS_COMMAND;
        String statfile = home + File.separator + DBCommonPatchingConstants.HOME_STATUS_FILE;
        for (String host : hosts) {
            StringBuilder remoteCommand = new StringBuilder();
            remoteCommand.append("ssh " + owner + "@" + host + " \"");
            remoteCommand.append("bash -c 'ORACLE_HOME=" + home + " ");
            remoteCommand.append(statusCmd).append(" -o ");
            remoteCommand.append(home).append(" -s ");
            remoteCommand.append(statfile).append(" -n ");
            remoteCommand.append(host);
            remoteCommand.append("' \"");
            this.logger.info("Remote command to check home status: " + remoteCommand.toString());
            ExecutionCommand e = new ExecutionCommand(host, remoteCommand.toString());
            remoteStatusCmds.add(e);
        }
        ParallelExecution pe = new ParallelExecution(remoteStatusCmds, owner);
        pe.execute();
        boolean isRunning = false;
        for (CommandExecutionThread cet : pe.getResults()) {
            GISystemCall.ExecReturn er = cet.er;
            int exit_code = er.getReturnCode();
            if (exit_code != 0) {
                this.logger.info("Unable to detect home status on remote host " + cet.host);
                continue;
            }
            if (StringUtil.isNullOrEmpty((String)er.getNormalMessage(), (boolean)true)) continue;
            this.logger.info("Following databases are running on the remote host " + cet.host + " : \n" + er.getNormalMessage().trim());
            isRunning = true;
        }
        return isRunning;
    }
}

