/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.validation.validators.DiskSpaceCheckRequestParam;
import com.oracle.glcm.patch.auto.db.product.validation.validators.DiskSpaceCheckResult;
import com.oracle.glcm.patch.auto.db.product.validation.validators.DiskSpaceVerifier;
import com.oracle.helper.remote.RemoteCommandListenerObject;
import com.oracle.helper.remote.RemoteExecutionResult;
import com.oracle.helper.remote.RemoteHandlerListener;
import com.oracle.helper.remote.RemoteRequestParam;
import com.oracle.helper.remote.RequestParam;
import com.oracle.helper.remote.UserEquivalenceCommandHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;

public class DiskSpaceCheckHelper
implements RemoteHandlerListener {
    private static final int CLASSNOT_FOUND_EXCEPTION = 1;
    private static final int FILE_IO_EXCEPTION = 2;
    private static DiskSpaceCheckResult result = null;
    static Logger logger;

    public static void main(String[] args) {
        String requestObjectLocation = null;
        ArrayList<String> argsList = new ArrayList<String>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        for (int i = 0; i < argsList.size(); ++i) {
            if (!((String)argsList.get(i)).equalsIgnoreCase("-OBJECTLOC")) continue;
            requestObjectLocation = (String)argsList.get(++i);
        }
        logger.info("requestObjectLocation: " + requestObjectLocation);
        try {
            DiskSpaceCheckRequestParam param = (DiskSpaceCheckRequestParam)FileUtility.deserializeDataObj((String)requestObjectLocation);
            DiskSpaceCheckHelper helper = new DiskSpaceCheckHelper();
            result = helper.checkDiskSpace(param);
            FileUtility.persistDataObj((String)param.getResponseObjectLocation(), (Object)result, (boolean)true);
        }
        catch (ClassNotFoundException e) {
            logger.warning("ClassNotFoundException: " + e.getMessage());
            new OPatchAutoException(e.getMessage(), new Object[0]);
            System.exit(1);
        }
        catch (IOException e) {
            logger.warning("IOException: " + e.getMessage());
            new OPatchAutoException(e.getMessage(), new Object[0]);
            System.exit(2);
        }
    }

    public DiskSpaceCheckResult checkDiskSpace(DiskSpaceCheckRequestParam param) {
        long patchSize = param.getPatchSize();
        logger.info("patchSize: " + patchSize);
        Map<String, Map<String, String>> hostWithHomes = param.getHostWithHomes();
        String responseObjLocation = param.getResponseObjectLocation();
        ArrayList<RemoteRequestParam> remoteExecutionParams = new ArrayList<RemoteRequestParam>();
        for (String hostName : hostWithHomes.keySet()) {
            logger.info("hostName: " + hostName);
            if (hostName.equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()))) {
                this.updateResult(DiskSpaceVerifier.checkSpaceforCloning(patchSize, hostWithHomes.get(hostName)), hostName);
                continue;
            }
            ArrayList<RequestParam> requestParams = new ArrayList<RequestParam>();
            String homePath = hostWithHomes.get(hostName).keySet().iterator().next();
            String cloneHome = this.getCommaSeparatedCloneHome(hostWithHomes.get(hostName));
            requestParams.add(this.generateExecutionParams(this.getRemoteCommand(String.valueOf(patchSize), homePath, cloneHome, responseObjLocation), responseObjLocation, new HashMap<RequestParam.PrereqCode, List<String>>()));
            RemoteRequestParam remoteExecutionParam = new RemoteRequestParam(hostName, requestParams, false);
            remoteExecutionParams.add(remoteExecutionParam);
        }
        if (!remoteExecutionParams.isEmpty()) {
            UserEquivalenceCommandHandler commandHandler = new UserEquivalenceCommandHandler(remoteExecutionParams, (RemoteHandlerListener)this);
            commandHandler.executeCommand();
        }
        return result;
    }

    private String getRemoteCommand(String patchSize, String homePath, String cloneHomeMap, String objLoc) {
        StringBuilder perlPath = new StringBuilder();
        perlPath.append(homePath).append(File.separator).append(ProductDriverConstants.PERL_PATH);
        StringBuilder remoteCommand = new StringBuilder();
        remoteCommand.append((CharSequence)perlPath);
        remoteCommand.append(homePath);
        remoteCommand.append(ProductDriverConstants.OPATCHAUTO_BIN);
        remoteCommand.append("RemoteHostExecutor.pl ");
        remoteCommand.append(" -PATCHSIZE=").append(patchSize);
        remoteCommand.append(" -CLONEHOMEMAP=").append(cloneHomeMap);
        remoteCommand.append(" -OBJECTLOC=").append(objLoc);
        remoteCommand.append(" -JVM_HANDLER=com/oracle/glcm/patch/auto/db/product/validation/validators/DiskSpaceVerifier ");
        logger.info("command: " + remoteCommand.toString());
        return remoteCommand.toString();
    }

    private String getCommaSeparatedCloneHome(Map<String, String> cloneHomeMap) {
        String clonePath = "";
        for (String home : cloneHomeMap.keySet()) {
            clonePath = clonePath + home + "\\#" + cloneHomeMap.get(home) + ",";
        }
        clonePath = clonePath.substring(0, clonePath.lastIndexOf(","));
        return clonePath;
    }

    private RequestParam generateExecutionParams(String command, String serializedObjLoc, HashMap<RequestParam.PrereqCode, List<String>> prereqMap) {
        RequestParam requestParam = new RequestParam(command, prereqMap);
        requestParam.setSerializedObjLoc(serializedObjLoc);
        return requestParam;
    }

    public void notifyResult(List<RemoteCommandListenerObject> commandListenerObjects) {
        if (null != commandListenerObjects) {
            for (RemoteCommandListenerObject commandListenerObject : commandListenerObjects) {
                if (commandListenerObject.getResultID() == 1) {
                    logger.info("Command execution failed for host " + commandListenerObject.getHost() + " due to : " + commandListenerObject.getException().getMessage());
                    if (result == null) {
                        result = new DiskSpaceCheckResult(1, commandListenerObject.getHost(), null);
                    } else {
                        result.setResultStatus(1);
                        result.getResult().put(commandListenerObject.getHost(), null);
                    }
                    result.setResultMessage("Command execution failed for host " + commandListenerObject.getHost() + " due to : " + commandListenerObject.getException().getMessage());
                    continue;
                }
                logger.info("Consolidating result from host : " + commandListenerObject.getHost());
                List remoteExecutionResults = commandListenerObject.getRemoteExecutionResults();
                for (RemoteExecutionResult remoteExecutionResult : remoteExecutionResults) {
                    if (remoteExecutionResult.getResultID() == 2) {
                        logger.info("Connection failed for host " + commandListenerObject.getHost() + " due to : " + remoteExecutionResult.getException());
                        if (result == null) {
                            result = new DiskSpaceCheckResult(2, commandListenerObject.getHost(), null);
                        } else {
                            result.setResultStatus(2);
                            result.getResult().put(commandListenerObject.getHost(), null);
                        }
                        result.setResultMessage("Connection failed for host " + commandListenerObject.getHost() + " due to : " + commandListenerObject.getException().getMessage());
                        continue;
                    }
                    if (remoteExecutionResult.getResultID() == 1) {
                        logger.info("Execution failed for host " + commandListenerObject.getHost() + " due to : " + remoteExecutionResult.getException());
                        if (result == null) {
                            result = new DiskSpaceCheckResult(1, commandListenerObject.getHost(), null);
                        } else {
                            result.setResultStatus(1);
                            result.getResult().put(commandListenerObject.getHost(), null);
                        }
                        String msg = "Not details found";
                        if (remoteExecutionResult.getException() != null) {
                            msg = remoteExecutionResult.getException().getMessage();
                        }
                        result.setResultMessage("Command execution failed for host " + commandListenerObject.getHost() + " due to : " + msg);
                        continue;
                    }
                    String host = commandListenerObject.getHost();
                    logger.info("Data retrieved from host " + host);
                    if (null == remoteExecutionResult.getCommandExecutionResult()) continue;
                    DiskSpaceCheckResult spaceCheckResult = (DiskSpaceCheckResult)remoteExecutionResult.getCommandExecutionResult();
                    this.updateResult(spaceCheckResult, host);
                }
            }
        }
    }

    private void updateResult(DiskSpaceCheckResult spaceCheckResult, String host) {
        logger.info("spaceCheckResult: " + spaceCheckResult);
        logger.info("result: " + result);
        if (result == null) {
            result = spaceCheckResult;
        } else {
            result.getResult().put(host, spaceCheckResult.getResult().get(host));
        }
        logger.info("final result: " + result);
    }

    static {
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchautodb/messages");
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchautodb/opatchauto-db");
        ResourceBundleManager.setPrefix((String)"opatchauto", (String)"OPATCHAUTO");
        logger = Logger.getLogger(DiskSpaceCheckHelper.class.getName());
    }
}

