/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanEnv;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.util.PatchPlanUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;

public class DatabaseHomeOptionValidation
implements IValidator {
    Logger logger = Logger.getLogger(DatabaseHomeOptionValidation.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        StringBuilder message = new StringBuilder("");
        List oracleHomes = (List)params.get(ValidationParamKey.ORACLE_HOMES.ordinal());
        List databases = (List)params.get(ValidationParamKey.DATABASE.ordinal());
        boolean ohOptionEnabled = (Boolean)params.get(ValidationParamKey.HOME_KEY_OPTION.ordinal());
        boolean databaseOptionEnabled = (Boolean)params.get(ValidationParamKey.DATABASE_KEY_OPTION.ordinal());
        boolean isSidbOnlyMode = false;
        if (params.get(ValidationParamKey.SIDB_ONLY.ordinal()) != null) {
            isSidbOnlyMode = (Boolean)params.get(ValidationParamKey.SIDB_ONLY.ordinal());
        }
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        try {
            String oracleHome = (String)oracleHomes.get(0);
            if (oracleHome != null) {
                oracleHome = PatchPlanUtils.removeFileSeperatorAtEnd(oracleHome);
            }
            String gridHome = "";
            if (!isSidbOnlyMode) {
                ClusterInformationLoader crs = ClusterInformationLoader.getInstance();
                this.removLock();
                gridHome = crs.getGridHome();
            }
            DBValidationFailureReason reason = null;
            if (ohOptionEnabled && (reason = this.checkHomeLocations(oracleHomes)) != null) {
                message.append("ERROR: ").append("One of the specified Oracle Home locations is invalid. \n");
            } else if (databaseOptionEnabled) {
                HashMap<String, String> dbohMap = DBPatchingUtil.getDatabaseNameLocs();
                if (!this.checkDatabaseHomeLocations(databases, dbohMap)) {
                    reason = DBValidationFailureReason.INVALID_DATABASE;
                    message.append("ERROR: ").append("One of the Specified Database locations is invalid. \n");
                }
                if (reason == null && !this.validateDbHomesWithOpatchHome(databases, dbohMap)) {
                    reason = DBValidationFailureReason.INVALID_OPATCH_HOME;
                    message.append("ERROR: ").append("OPatchauto Should be executed from one of the Database home. \n");
                }
            }
            if (reason == null && !isSidbOnlyMode && (reason = this.checkClusterware(gridHome, ohOptionEnabled, databaseOptionEnabled, message)) != null) {
                this.logger.info(message.toString());
            }
            if (reason == null) {
                multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
            } else {
                this.validationFailedReason(message, multipleValidationResult, reason);
            }
        }
        finally {
            this.removLock();
        }
        return multipleValidationResult;
    }

    private DBValidationFailureReason checkClusterware(String gridHome, boolean ohOptionEnabled, boolean databaseOptionEnabled, StringBuilder message) {
        String opatchHome;
        DBValidationFailureReason reason = null;
        ClusterInformationLoader clusterInfoLoader = ClusterInformationLoader.getInstance();
        this.removLock();
        ClusterInformationLoader.CrsType crstype = clusterInfoLoader.getCRSType();
        try {
            if (!(clusterInfoLoader.isStackRunning() || ohOptionEnabled || databaseOptionEnabled)) {
                switch (crstype) {
                    case SOFTWARE_INSTALLATION_ONLY: {
                        message.append(BundleUtils.getMessage(DatabaseHomeOptionValidation.class, "SOFTWARE_ONLY_WITH_OH", new Object[0]));
                        break;
                    }
                    default: {
                        message.append(BundleUtils.getMessage(DatabaseHomeOptionValidation.class, "CRS_NOT_RUNNING", new Object[0]));
                    }
                }
                reason = DBValidationFailureReason.CLUSTERHOME_NOT_RUNNIG;
                if (reason != null) {
                    Reporting.report((String)message.toString());
                }
            }
        }
        catch (Exception e) {
            message.append(e.getMessage());
            reason = DBValidationFailureReason.CLUSTERHOME_NOT_RUNNIG;
        }
        if (!(reason != null || ohOptionEnabled || databaseOptionEnabled || this.isActiveGridHome(opatchHome = System.getProperty("OPatch.ORACLE_HOME")))) {
            message.append(BundleUtils.getMessage(DatabaseHomeOptionValidation.class, "INVALID_GRID_HOME", new Object[0]));
            reason = DBValidationFailureReason.MULTIPLE_GRID_IDENTIFIED;
        }
        return reason;
    }

    private void removLock() {
        PatchPlanEnv env = PatchPlanner.getInstance().getOPlanEnv();
        String invPtrLoc = env.getInvPtrLocation();
        String ctrInvLoc = env.getCentralInvLoc(invPtrLoc);
        String invLocCommand = "rm -rf " + ctrInvLoc + File.separator + "locks";
        byte[] pwd = null;
        GISystemCall.process(invLocCommand, "root", pwd);
    }

    private void validationFailedReason(StringBuilder message, MultipleValidationResult multipleValidationResult, DBValidationFailureReason reason) {
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, reason, null));
        this.logger.log(Level.INFO, message.toString());
    }

    private void invalidOracleHomeLocationErrorMessage(String errorType, String messagetype, String optinType) {
        String errorMessage = BundleUtils.getMessage(DatabaseHomeOptionValidation.class, errorType, messagetype, optinType);
        this.logger.log(Level.WARNING, errorMessage.toString());
    }

    private DBValidationFailureReason checkHomeLocations(List<String> oracleHomes) {
        DBValidationFailureReason reason = null;
        for (String oh : oracleHomes) {
            reason = this.isValidOracleHome(oh);
            if (reason == null) continue;
            return reason;
        }
        return reason;
    }

    private DBValidationFailureReason isValidOracleHome(String oh) {
        DBValidationFailureReason reason = null;
        String error = "INVALID_HOME_DB";
        if (!ClusterInformationLoader.isGridHome((String)oh) && !this.isSrvctlFilePath(oh)) {
            reason = DBValidationFailureReason.INVALID_ORACLE_HOME;
            this.invalidOracleHomeLocationErrorMessage(error, "Oracle Home", oh);
        }
        return reason;
    }

    public boolean isActiveGridHome(String oh) {
        boolean isActiveGridHome = false;
        String gridHome = ClusterInformationLoader.getInstance().getGridHome();
        if (DBPatchingHelper.compareFilePath(oh, gridHome)) {
            isActiveGridHome = true;
        }
        return isActiveGridHome;
    }

    private boolean checkDatabaseHomeLocations(List<String> databases, HashMap<String, String> dbohMap) {
        for (String dbname : databases) {
            String home = dbohMap.get(dbname);
            if (this.isSrvctlFilePath(home)) continue;
            this.invalidOracleHomeLocationErrorMessage("INVALID_HOME_DB", "Database", dbname);
            return false;
        }
        return true;
    }

    private boolean isSrvctlFilePath(String oh) {
        String srvctl = oh + File.separator + DBCommonPatchingConstants.SRVCTL_COMMAND;
        return new File(srvctl).isFile();
    }

    private boolean validateDbHomesWithOpatchHome(List<String> databases, HashMap<String, String> dbohMap) {
        HashSet<String> dblocation = new HashSet<String>();
        String opatchHome = System.getProperty("OPatch.ORACLE_HOME");
        for (Map.Entry<String, String> entry : dbohMap.entrySet()) {
            if (!databases.contains(entry.getKey())) continue;
            dblocation.add(entry.getValue());
        }
        if (null != dblocation && !dblocation.isEmpty()) {
            new FileUtils();
            if (!dblocation.contains(FileUtils.getFile((String)opatchHome).getPath())) {
                this.invalidOracleHomeLocationErrorMessage("INVALID_OPATCH_HOME", "", "");
                return false;
            }
        }
        return true;
    }
}

