/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class ConsistentPatchingModeValidator
implements IValidator {
    Logger logger = Logger.getLogger(ConsistentPatchingModeValidator.class.getName());
    private MultipleValidationResult multipleValidationResult = new MultipleValidationResult();

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.INFO, "Running consistent patching mode validation");
        ClusterInformationLoader.CrsType crsType = ClusterInformationLoader.getInstance().getCRSType();
        this.logger.info("CRS Type is detected to be " + crsType);
        if (crsType.equals((Object)ClusterInformationLoader.CrsType.SOFTWARE_INSTALLATION_ONLY)) {
            this.logger.info("Grid home is a software-only installation");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Patching mode consistency validation is not required for a software-only installation."));
            return this.multipleValidationResult;
        }
        ConfigGraph configGraph = (ConfigGraph)params.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
        PatchTarget patchTarget = (PatchTarget)params.get(ValidationParamKey.PATCH_TARGET.ordinal());
        List<Host> hostModelList = configGraph.getTargets(Host.class);
        this.logger.info("Size of the host list from config graph is : " + hostModelList.size());
        String home = patchTarget.getHome(true).getLocation();
        List<OracleHome> oracleHomes = configGraph.getTargets(OracleHome.class);
        String crsHome = null;
        String crsOwner = null;
        boolean isSiha = false;
        for (OracleHome oh : oracleHomes) {
            if (oh.getHomeType().equals("crs")) {
                crsHome = oh.getPath();
                crsOwner = oh.getOwner();
                break;
            }
            if (!oh.getHomeType().equals("siha")) continue;
            crsHome = oh.getPath();
            crsOwner = oh.getOwner();
            isSiha = true;
            break;
        }
        this.logger.fine("Is SIHA: " + isSiha);
        if (isSiha) {
            this.logger.info("This is a SIHA environment.");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Patching mode consistency validation is not required for a SIHA environment."));
            return this.multipleValidationResult;
        }
        boolean isOOPEnabled = false;
        if (params.get(ValidationParamKey.OOP_ENABLED.ordinal()) != null) {
            isOOPEnabled = (Boolean)params.get(ValidationParamKey.OOP_ENABLED.ordinal());
        }
        String localHost = "";
        ArrayList<String> remoteNodes = new ArrayList<String>();
        for (Host host : hostModelList) {
            if (!DBPatchingHelper.isRemoteHost(host)) {
                localHost = host.getHostName();
                break;
            }
            remoteNodes.add(host.getHostName());
        }
        try {
            boolean isConsistent = true;
            if (!isOOPEnabled) {
                isConsistent = this.checkConsistencyForInPlace(home, localHost, remoteNodes, params);
            }
            if (!isConsistent) {
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.INCONSISTENT_PATCHING_MODE, null));
                return this.multipleValidationResult;
            }
        }
        catch (Exception e) {
            this.logger.info("Unable to check patching mode history for home " + home);
        }
        return this.multipleValidationResult;
    }

    private boolean checkConsistencyForInPlace(String home, String localHost, ArrayList<String> remoteNodes, ValidationParam params) {
        return this.checkConsistencyForMode(home, localHost, remoteNodes, params);
    }

    private boolean checkConsistencyForMode(String home, String localHost, ArrayList<String> remoteNodes, ValidationParam params) {
        boolean isNonRolling = (Boolean)params.get(ValidationParamKey.NONROLLING_OPTION.ordinal());
        boolean isSame = true;
        ArrayList<Object> remotesToCheck = new ArrayList();
        String ohOwner = OUIDriver.checkFileOwner((File)new File(home, "oraInst.loc"));
        if (remoteNodes.size() > 1) {
            remotesToCheck = remoteNodes;
        } else {
            remotesToCheck = DBPatchingUtil.getRemoteNodesForHome(home);
            this.logger.info("Size of the host list from saved file is : " + remotesToCheck.size());
        }
        for (String string : remotesToCheck) {
            try {
                Credential cred;
                if (string.equalsIgnoreCase(localHost)) continue;
                String source = home + File.separator + ".opatchauto_storage" + File.separator + "mode_info";
                String dst = source + "_" + string;
                String scpCmd = "scp " + ohOwner + "@" + string + ":" + source + " " + dst;
                GISystemCall.ExecReturn ret = GISystemCall.process(scpCmd, ohOwner, cred = null);
                if (!ret.isOK()) {
                    this.logger.fine("Unable to check patch mode on host " + string);
                    continue;
                }
                String oper = "ROLLBACK";
                OPatchAutoCommand operation = (OPatchAutoCommand)params.get(ValidationParamKey.OPERATION.ordinal());
                if (operation.isApply()) {
                    oper = "APPLY";
                }
                String mode = isNonRolling ? "NONROLLING" : "ROLLING";
                String reverse_mode = isNonRolling ? "ROLLING" : "NONROLLING";
                ArrayList<OPatchPatchInfo> patchList = SessionData.getInstance().getAnalyzedPatchList(home);
                File f = new File(dst);
                if (patchList != null && !patchList.isEmpty() && f.exists()) {
                    for (OPatchPatchInfo individualPatchInfo : patchList) {
                        String file_line;
                        String patchId = individualPatchInfo.getPatchID();
                        if (DBPatchingHelper.identifyNodeOfPatching(home, patchId, SessionData.getInstance().getHostPatchDataMap(home), operation.isRollback()) == DBPatchingHelper.NodeOfPatching.FIRST) continue;
                        String reverse_line = patchId + " : " + oper + " " + reverse_mode;
                        BufferedReader reader = new BufferedReader(new FileReader(f));
                        while ((file_line = reader.readLine()) != null) {
                            if (!reverse_line.equals(file_line.trim())) continue;
                            isSame = false;
                            this.logger.severe("Same " + mode + " patching mode was not used for patch " + patchId + " on host " + string);
                            break;
                        }
                        reader.close();
                    }
                }
                if (!f.exists()) continue;
                f.delete();
            }
            catch (Exception e) {
                this.logger.info("Unable to validate the patching mode consistency for host " + string);
            }
        }
        return isSame;
    }
}

