/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationUtil;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSObjectValidator;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CRSRAChomeNotSharedValidator
implements IValidator {
    Logger logger = Logger.getLogger(CRSRAChomeNotSharedValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        String formattedMessage;
        this.logger.log(Level.FINE, "Invoking rule to ensure RACHome is not shared.");
        CRSObjectValidator crsObjectValidator = new CRSObjectValidator();
        crsObjectValidator.setClazz(CRSRAChomeNotSharedValidator.class);
        MultipleValidationResult multipleValidationResult = crsObjectValidator.validate(params);
        if (this.getFailureResult(multipleValidationResult)) {
            return multipleValidationResult;
        }
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        CRSCluster crs = (CRSCluster)systemInst.getTop();
        ArrayList list = new ArrayList();
        List racs = crs.getDbRAC();
        String message = null;
        ArrayList<BaseClass> noInstances = new ArrayList<BaseClass>();
        for (RACDatabase rac : racs) {
            if (rac.getDbInstances() != null && !rac.getDbInstances().isEmpty()) continue;
            this.logger.log(Level.FINE, "There are RAC Databases with no instances associated");
            noInstances.add((BaseClass)rac);
        }
        if (!noInstances.isEmpty()) {
            message = BundleUtils.getMessage(CRSRAChomeNotSharedValidator.class, "NO_RACINSTANCE", BundleUtils.makeStringOutOfList(noInstances));
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_RACINSTANCE, noInstances));
            String formattedMessage2 = ValidationUtil.getFormattedMessage(noInstances, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, formattedMessage2);
            return multipleValidationResult;
        }
        ArrayList<BaseClass> missingHome = new ArrayList<BaseClass>();
        ArrayList<BaseClass> missingHost = new ArrayList<BaseClass>();
        ArrayList<BaseClass> shared = new ArrayList<BaseClass>();
        ArrayList<OracleHome> nonshared = new ArrayList<OracleHome>();
        block1: for (RACDatabase rac : racs) {
            for (RACDBInstance instance : rac.getDbInstances()) {
                OracleHome home = instance.getRuns_from();
                if (home == null) {
                    this.logger.log(Level.FINE, "Instance is missing OracleHome information it runs from.");
                    missingHome.add((BaseClass)instance);
                    continue block1;
                }
                List hosts = home.getHosts();
                if (hosts == null || hosts.isEmpty()) {
                    this.logger.log(Level.FINE, "RACHome is missing the host information.");
                    missingHost.add((BaseClass)home);
                    continue block1;
                }
                if (hosts.size() != 1) {
                    this.logger.log(Level.FINE, "Home at " + home.getPath() + " is shared.");
                    shared.add((BaseClass)home);
                    continue;
                }
                this.logger.log(Level.FINE, "Home at " + home.getPath() + " is not shared.");
                nonshared.add(home);
            }
        }
        if (!missingHome.isEmpty()) {
            message = BundleUtils.getMessage(CRSRAChomeNotSharedValidator.class, "RACINSTANCE_MISSING_HOME", BundleUtils.makeStringOutOfList(missingHome));
            formattedMessage = ValidationUtil.getFormattedMessage(missingHome, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, formattedMessage);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.RACINSTANCE_MISSING_HOME, missingHome));
        }
        if (!missingHost.isEmpty()) {
            message = BundleUtils.getMessage(CRSRAChomeNotSharedValidator.class, "RACINSTANCE_MISSING_HOME", BundleUtils.makeStringOutOfList(missingHost));
            formattedMessage = ValidationUtil.getFormattedMessage(missingHost, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, formattedMessage);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.MISSING_HOST, missingHost));
        }
        if (!multipleValidationResult.isEmpty()) {
            return multipleValidationResult;
        }
        if (!shared.isEmpty()) {
            message = BundleUtils.getMessage(CRSRAChomeNotSharedValidator.class, "HOMES_SHARED", BundleUtils.makeStringOutOfList(shared));
            formattedMessage = ValidationUtil.getFormattedMessage(shared, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, formattedMessage);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.HOMES_SHARED, shared));
            return multipleValidationResult;
        }
        message = "all RAC run from non-shared homes";
        this.logger.log(Level.FINE, message);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }

    private boolean getFailureResult(MultipleValidationResult multipleValidationResult) {
        for (ValidationResult validationResult : multipleValidationResult.getValidationResultList()) {
            if (validationResult.getStatus() != ValidationResult.ValidationStatus.FAILED || validationResult.getFailureReason().equals(DBValidationFailureReason.MISSING_VERSION)) continue;
            return true;
        }
        return false;
    }
}

