/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSObjectValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSPlatformValidator;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CRSPlatformAsRequestedValidator
implements IValidator {
    Logger logger = Logger.getLogger(CRSPlatformAsRequestedValidator.class.getName());
    Set<String> platforms = null;
    private CRSObjectValidator crsObjectValidator;

    public CRSPlatformAsRequestedValidator(Set<String> platforms, boolean isCrsPresent) {
        this.platforms = platforms;
        if (isCrsPresent) {
            this.crsObjectValidator = new CRSObjectValidator();
        }
    }

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        CRSPlatformValidator crsPlatformValidator;
        MultipleValidationResult crsPlatformValidatorResult;
        this.logger.log(Level.FINE, "Invoking rule to ensure that all the homes have the platform as one of the supported platforms.");
        MultipleValidationResult crsObjectValidationResult = new MultipleValidationResult();
        if (this.crsObjectValidator != null) {
            this.crsObjectValidator.setClazz(CRSPlatformAsRequestedValidator.class);
            crsObjectValidationResult = this.crsObjectValidator.validate(params);
            if (this.getFailureResult(crsObjectValidationResult)) {
                return crsObjectValidationResult;
            }
        }
        if (this.getFailureResult(crsPlatformValidatorResult = (crsPlatformValidator = new CRSPlatformValidator()).validate(params))) {
            return crsPlatformValidatorResult;
        }
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        ArrayList<BaseClass> list = new ArrayList<BaseClass>();
        List homes = systemInst.getAllHomes();
        String platform = null;
        for (OracleHome home : homes) {
            platform = home.getARUId();
            if (this.platforms.contains(platform)) continue;
            this.logger.log(Level.FINE, " The following home has a platform that is not supported ");
            for (Host host : home.getHosts()) {
                if (list.contains(host)) continue;
                list.add((BaseClass)host);
            }
        }
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        String message = null;
        if (!list.isEmpty()) {
            message = BundleUtils.getMessage(CRSPlatformAsRequestedValidator.class, "PLATFORM_NOT_SUPPORTED", BundleUtils.makeStringOutOfList(list));
            Reporting.report((String)message);
            this.logger.log(Level.INFO, message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.PLATFORM_NOT_SUPPORTED, list));
            return multipleValidationResult;
        }
        message = " CRS platform (ARUid) value is in the set of values" + this.platforms;
        this.logger.log(Level.FINE, message);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }

    private boolean getFailureResult(MultipleValidationResult multipleValidationResult) {
        for (ValidationResult validationResult : multipleValidationResult.getValidationResultList()) {
            if (validationResult.getStatus() != ValidationResult.ValidationStatus.FAILED) continue;
            return true;
        }
        return false;
    }
}

