/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.CRSCluster;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CRSObjectValidator
implements IValidator {
    private Class<?> clazz = CRSObjectValidator.class;

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        String message = null;
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        if (systemInst.getTop() == null) {
            logger.log(Level.FINE, "System Instance top was found to be null. Ensuring if no crs object exists.");
            List crsList = systemInst.getTargetsOfType(CRSCluster.class);
            if (crsList == null || crsList.isEmpty()) {
                logger.log(Level.FINE, "CRSCluster does not exist.");
                message = BundleUtils.getMessage(this.clazz, "NO_CRS", new Object[0]);
                Reporting.report((String)message);
                logger.log(Level.INFO, message);
                multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_CRS, null));
                return multipleValidationResult;
            }
            if (crsList.size() != 1) {
                logger.log(Level.FINE, "More than one CRS object recognized. Set top to the CRSObject");
                message = BundleUtils.getMessage(this.clazz, "MULTIPLE_CRS_OBJECT", new Object[0]);
                Reporting.report((String)message);
                logger.log(Level.INFO, message);
                multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.MULTIPLE_CRS_OBJECT, null));
                return multipleValidationResult;
            }
            logger.log(Level.INFO, "Setting the top to the CRSObject");
            systemInst.setTop((AbstractBaseTarget)crsList.get(0));
        } else if (!(systemInst.getTop() instanceof CRSCluster)) {
            logger.log(Level.FINE, "SystemInstance top is not CRSCluster object");
            message = BundleUtils.getMessage(this.clazz, "TOP_NOT_CRS", new Object[0]);
            Reporting.report((String)message);
            logger.log(Level.INFO, message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.TOP_NOT_CRS, null));
            return multipleValidationResult;
        }
        CRSCluster crs = (CRSCluster)systemInst.getTop();
        ArrayList<BaseClass> list = new ArrayList<BaseClass>();
        String verCRS = crs.getVersion();
        if (verCRS == null || verCRS.length() == 0) {
            logger.log(Level.FINE, "CRS Version is not set");
            list.add((BaseClass)crs);
            message = BundleUtils.getMessage(this.clazz, "MISSING_VERSION", BundleUtils.makeStringOutOfList(list));
            StringBuffer str = new StringBuffer();
            str.append("\n    ").append(message).append("\n      " + crs);
            message = str.toString();
            Reporting.report((String)message);
            logger.log(Level.INFO, message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.MISSING_VERSION, crs));
            return multipleValidationResult;
        }
        message = " CRS object is valid, no associated object is validated by this rule";
        logger.log(Level.FINE, message);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }
}

