/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.summary.generator;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cookies.CloneCookie;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.summary.ISummaryGenerator;
import com.oracle.glcm.patch.auto.db.product.summary.Summary;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryTarget;
import dbmodel.common.OracleHome;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class OOPPatcingSummaryGenerator
implements ISummaryGenerator {
    @Override
    public void generateSummary(SummaryID id, Map<SummaryTarget, Summary> summaryTargetList, List<String> summaryList, OPatchAutoCommand command) {
        if (id == SummaryID.oop_summary) {
            Reporting.report((String)"Out of place patching clone home(s) summary");
            Reporting.report((String)"____________________________________________");
            for (Map.Entry<SummaryTarget, Summary> summaryEntry : summaryTargetList.entrySet()) {
                Reporting.report((String)("Host : " + summaryEntry.getKey().getHost()));
                Reporting.report((String)("Actual Home : " + summaryEntry.getKey().getHome()));
                if (!StringUtil.isNullOrEmpty((String)summaryEntry.getKey().getVersion(), (boolean)true)) {
                    Reporting.report((String)("Version:" + summaryEntry.getKey().getVersion()));
                }
                String cloneHomePath = null;
                cloneHomePath = summaryEntry.getKey().getCloneHome() != null ? summaryEntry.getKey().getCloneHome() : this.getDefaultClonePath(summaryEntry.getKey().getHome());
                Reporting.report((String)("Clone Home Path : " + cloneHomePath + "\n"));
            }
        }
    }

    private String getDefaultClonePath(String actualHome) {
        String cloneHomePath = null;
        List<OracleHome> ohList = PatchPlanner.getInstance().getConfigGraph().getTargets(OracleHome.class);
        CloneCookie cookie = null;
        for (OracleHome oh : ohList) {
            if (!DBPatchingHelper.compareFilePath(oh.getPath(), actualHome)) continue;
            cookie = (CloneCookie)oh.getProperty(CloneCookie.class);
            cloneHomePath = cookie.getClonePath();
            break;
        }
        if (cloneHomePath == null) {
            List localInfo = OUIDriver.getLocalInfo();
            HashSet<String> localHomeSet = new HashSet<String>();
            for (OracleHome oh : localInfo) {
                localHomeSet.add(oh.getPath());
            }
            try {
                cloneHomePath = DBPatchingUtil.getSubCloneHomeDir(actualHome, localHomeSet);
            }
            catch (OPatchAutoException e) {
                // empty catch block
            }
        }
        return cloneHomePath;
    }
}

