/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.summary;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.db.product.summary.CommonSummaryList;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryTarget;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryTargetList;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="patching-summary", propOrder={"sessionID", "status", "targetPatchingSummaryDetails", "generalPatchingSummaryDetails", "configPatchingSummaryDetails"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="patching-summary")
public class PatchingSummary {
    public static final int SUCCESS = 0;
    public static final int FAILURE = 1;
    public static final int RESUME = 2;
    @XmlElementWrapper(name="target-patching-summary-list")
    private Map<SummaryID, SummaryTargetList> targetPatchingSummaryDetails = new LinkedHashMap<SummaryID, SummaryTargetList>();
    @XmlElementWrapper(name="general-patching-summary")
    private Map<SummaryID, CommonSummaryList> generalPatchingSummaryDetails = new LinkedHashMap<SummaryID, CommonSummaryList>();
    @XmlElementWrapper(name="config-patching-summary")
    private Map<SummaryID, CommonSummaryList> configPatchingSummaryDetails = new LinkedHashMap<SummaryID, CommonSummaryList>();
    @XmlElement(name="last-status", required=true)
    private int status;
    @XmlElement(name="sessionid", required=true)
    private String sessionID = "";

    void init(String sessionID) {
        this.sessionID = sessionID;
    }

    void storePatchingSummary(int status, SummaryID summaryID, PatchTarget target, String summary) {
        this.status = status;
        if (target == null) {
            CommonSummaryList generalSummaryList = this.generalPatchingSummaryDetails.get((Object)summaryID);
            if (generalSummaryList == null) {
                generalSummaryList = new CommonSummaryList();
            }
            generalSummaryList.updateList(summary);
            this.generalPatchingSummaryDetails.put(summaryID, generalSummaryList);
        } else {
            SummaryTargetList targetSummaryList = null;
            targetSummaryList = this.targetPatchingSummaryDetails.containsKey((Object)summaryID) ? this.targetPatchingSummaryDetails.get((Object)summaryID) : new SummaryTargetList();
            SummaryTarget targetSummary = this.getTargetSummary(target);
            if (summaryID.equals((Object)SummaryID.sdb_patching) || summaryID.equals((Object)SummaryID.sdb_analyze_patching) || summaryID.equals((Object)SummaryID.shard_patching)) {
                targetSummaryList.updateSDBTargetList(targetSummary, status, summary);
            } else {
                targetSummaryList.updateTargetList(targetSummary, status, summary);
            }
            this.targetPatchingSummaryDetails.put(summaryID, targetSummaryList);
        }
    }

    void storeConfigSummary(int status, SummaryID summaryID, String summary) {
        this.status = status;
        CommonSummaryList configSummaryList = this.configPatchingSummaryDetails.get((Object)summaryID);
        if (configSummaryList == null) {
            configSummaryList = new CommonSummaryList();
        }
        configSummaryList.updateList(summary);
        this.configPatchingSummaryDetails.put(summaryID, configSummaryList);
    }

    int getLastActionStatus() {
        return this.status;
    }

    String getSessionID() {
        return this.sessionID;
    }

    SummaryTargetList getTargetSummaryList(SummaryID id) {
        return this.targetPatchingSummaryDetails.get((Object)id);
    }

    Set<SummaryID> getTargetSummaryIDList() {
        return this.targetPatchingSummaryDetails.keySet();
    }

    List<String> getGeneralSummaryList(SummaryID id) {
        return this.generalPatchingSummaryDetails.get((Object)id).getList();
    }

    Set<SummaryID> getGeneralSummaryIDList() {
        return this.generalPatchingSummaryDetails.keySet();
    }

    List<String> getConfigSummaryList(SummaryID id) {
        return this.configPatchingSummaryDetails.get((Object)id).getList();
    }

    Set<SummaryID> getConfigSummaryIDList() {
        return this.configPatchingSummaryDetails.keySet();
    }

    void clear() {
        this.targetPatchingSummaryDetails.clear();
        this.generalPatchingSummaryDetails.clear();
        this.configPatchingSummaryDetails.clear();
    }

    private SummaryTarget getTargetSummary(PatchTarget target) {
        SummaryTarget targetSummary = new SummaryTarget();
        targetSummary.setHome(target.getHome(true).getLocation());
        targetSummary.setHost(target.getHost().getHost());
        targetSummary.setProductType(target.getProductType().getType().toUpperCase());
        if (target.getHomeClone() != null) {
            targetSummary.setCloneHome(target.getHomeClone().getLocation());
        }
        if (!StringUtil.isNullOrEmpty((String)target.getHome(true).getVersion(), (boolean)true)) {
            targetSummary.setVersion(target.getHome(true).getVersion());
        }
        return targetSummary;
    }
}

