/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.patchlevel;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevel;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevelReporter;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevelXMLFormatter;
import com.oracle.glcm.patch.auto.db.product.patchlevel.PatchLevelReportingListener;
import com.oracle.glcm.patch.auto.topology.Home;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.patchmodel.CompositePatch;
import dbmodel.patchmodel.GenericPatch;
import dbmodel.patchmodel.GenericSingletonPatch;
import dbmodel.patchmodel.OPatchSingleton;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class PatchLevelInfoManager
implements PatchLevelReportingListener {
    public static final int PATCH_QUERY_FAILED = 100;
    public static final int REMOTE_CONNECTION_FAILED = 101;
    public static final int REMOTE_HOST_CHECK_FAILED = 102;
    public static final int PATCH_DATA_SERIALIZATION_FAILED = 103;
    public static final int SERIALIZATION_OF_QEURY_OBJECT_FAILED = 104;
    public static final int SSH_USER_EQUIVALENCE_NOT_FOUND = 105;
    private Map<com.oracle.glcm.patch.auto.topology.Host, OracleHomePatchLevel> hostOHMap = new ConcurrentHashMap<com.oracle.glcm.patch.auto.topology.Host, OracleHomePatchLevel>();
    private static final PatchLevelInfoManager instance = new PatchLevelInfoManager();
    private Logger logger = Logger.getLogger(PatchLevelInfoManager.class.getName());

    private PatchLevelInfoManager() {
    }

    public static PatchLevelInfoManager getInstance() {
        return instance;
    }

    public void queryInitialPatchLevelInfo(List<com.oracle.glcm.patch.auto.topology.Host> hosts) {
        new OracleHomePatchLevelReporter().report(hosts, this);
    }

    private int getDBMessageID(int exitCode) {
        int dbMessageID = 0;
        switch (exitCode) {
            case 100: {
                dbMessageID = 72086;
                break;
            }
            case 101: {
                dbMessageID = 72102;
                break;
            }
            case 102: {
                dbMessageID = 72103;
                break;
            }
            case 103: {
                dbMessageID = 72104;
                break;
            }
            case 104: {
                dbMessageID = 72105;
                break;
            }
            case 105: {
                dbMessageID = 72106;
                break;
            }
        }
        return dbMessageID;
    }

    @Override
    public void notifyResult(int resultID, int messageID, String message, Object payload) {
        this.logger.info("resultID: " + resultID);
        if (resultID == 0) {
            this.hostOHMap = (Map)payload;
        } else {
            this.logger.info("message: " + message);
            int dbmessageID = this.getDBMessageID(messageID);
            Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(dbmessageID), (Object[])new Object[]{message}));
            System.exit(messageID);
        }
    }

    public void updatePatchLevelInfo(com.oracle.glcm.patch.auto.topology.Host host, Home home, Object payload, OPatchAutoCommand operationType) {
        Set<com.oracle.glcm.patch.auto.topology.Host> hostList = this.hostOHMap.keySet();
        this.logger.info("host: " + host.getHost());
        this.logger.info("Home: " + home.getLocation());
        ArrayList appliedPatches = (ArrayList)payload;
        this.logger.info("appliedPatches: " + appliedPatches);
        List<GenericPatch> patches = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getAllPatches();
        HashSet<com.oracle.glcm.patch.auto.topology.Host> sharedHosts = new HashSet<com.oracle.glcm.patch.auto.topology.Host>();
        sharedHosts.add(host);
        List<OracleHome> ohList = PatchPlanner.getInstance().getConfigGraph().getTargets(OracleHome.class);
        for (OracleHome oh : ohList) {
            if (!oh.getPath().equals(home.getLocation())) continue;
            if (!oh.getIsShared()) break;
            for (Host modelhost : oh.getHosts()) {
                for (com.oracle.glcm.patch.auto.topology.Host topologyHost : hostList) {
                    if (!modelhost.getHostName().equals(topologyHost.getHost())) continue;
                    sharedHosts.add(topologyHost);
                }
            }
        }
        if (operationType.isApply()) {
            this.handleApplyUpdate(sharedHosts, home, appliedPatches, patches);
        } else {
            this.handleRollbackUpdate(sharedHosts, home, appliedPatches, patches);
        }
    }

    private void handleRollbackUpdate(Set<com.oracle.glcm.patch.auto.topology.Host> hostList, Home home, List<String> appliedPatches, List<GenericPatch> patches) {
        for (com.oracle.glcm.patch.auto.topology.Host host : hostList) {
            OracleHomePatchLevel patchLevel;
            Map<String, List<OPatchPatchInfo>> patchMap;
            if (!this.hostOHMap.containsKey(host) || !(patchMap = (patchLevel = this.hostOHMap.get(host)).getOracleHomePatchLevel()).containsKey(home.getLocation())) continue;
            ArrayList<String> subPatch = new ArrayList<String>();
            List<OPatchPatchInfo> info = patchMap.get(home.getLocation());
            Iterator<OPatchPatchInfo> itr = info.iterator();
            while (itr.hasNext()) {
                String patchID = itr.next().getPatchID();
                if (!appliedPatches.contains(patchID) || this.updateSubPatches(patches, patchID, subPatch)) continue;
                itr.remove();
            }
            if (subPatch.isEmpty()) continue;
            Iterator<OPatchPatchInfo> subPatchItr = info.iterator();
            while (subPatchItr.hasNext()) {
                String patchID = subPatchItr.next().getPatchID();
                if (!subPatch.contains(patchID)) continue;
                subPatchItr.remove();
            }
        }
    }

    private boolean updateSubPatches(List<GenericPatch> patches, String patchID, List<String> subPatch) {
        boolean hasSubPatches = false;
        for (GenericPatch patch : patches) {
            CompositePatch compositePatch;
            if (!(patch instanceof CompositePatch) || !(compositePatch = (CompositePatch)patch).getPatchID().equals(patchID)) continue;
            List compositeSubPatches = compositePatch.getSubPatches();
            for (GenericSingletonPatch genericSingletonPatch : compositeSubPatches) {
                subPatch.add(genericSingletonPatch.getPatchID());
            }
            hasSubPatches = true;
        }
        this.logger.info("hasSubPatches: " + hasSubPatches);
        return hasSubPatches;
    }

    private void handleApplyUpdate(Set<com.oracle.glcm.patch.auto.topology.Host> hostList, Home home, List<String> appliedPatches, List<GenericPatch> patches) {
        ArrayList<OPatchPatchInfo> patchInfos = new ArrayList<OPatchPatchInfo>();
        for (GenericPatch patch : patches) {
            CompositePatch compositePatch;
            if (patch instanceof OPatchSingleton) {
                OPatchSingleton singletonPatch = (OPatchSingleton)patch;
                if (!appliedPatches.contains(singletonPatch.getPatchID())) continue;
                OPatchPatchInfo patchInfo = new OPatchPatchInfo();
                patchInfo.setPatchID(singletonPatch.getPatchID());
                patchInfo.setUniquePatchID(singletonPatch.getUPI());
                patchInfo.setSQLPatch(singletonPatch.getSqlPatch().booleanValue());
                patchInfos.add(patchInfo);
                continue;
            }
            if (!(patch instanceof CompositePatch) || !appliedPatches.contains((compositePatch = (CompositePatch)patch).getPatchID())) continue;
            List compositeSubPatches = compositePatch.getSubPatches();
            for (GenericSingletonPatch genericSingletonPatch : compositeSubPatches) {
                if (!(genericSingletonPatch instanceof OPatchSingleton)) continue;
                OPatchSingleton singletonPatch = (OPatchSingleton)genericSingletonPatch;
                OPatchPatchInfo patchInfo = new OPatchPatchInfo();
                patchInfo.setPatchID(singletonPatch.getPatchID());
                patchInfo.setUniquePatchID(singletonPatch.getUPI());
                patchInfo.setSQLPatch(singletonPatch.getSqlPatch().booleanValue());
                patchInfos.add(patchInfo);
            }
        }
        for (com.oracle.glcm.patch.auto.topology.Host host : hostList) {
            OracleHomePatchLevel patchLevel;
            Map<String, List<OPatchPatchInfo>> patchMap;
            if (!this.hostOHMap.containsKey(host) || !(patchMap = (patchLevel = this.hostOHMap.get(host)).getOracleHomePatchLevel()).containsKey(home.getLocation())) continue;
            patchMap.get(home.getLocation()).addAll(patchInfos);
        }
    }

    public void persistPatchLevelInfo(String location, String host) throws OPatchAutoException {
        this.logger.info("location: " + location);
        new OracleHomePatchLevelXMLFormatter().formatReport(location, this.hostOHMap, host);
    }
}

