/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.executor;

import java.util.ArrayList;
import java.util.List;

public class ExecutionResult {
    List<CommandExecutionResult> resultList = new ArrayList<CommandExecutionResult>();

    public ExecutionResult(List<CommandExecutionResult> list) {
        this.resultList.addAll(list);
    }

    public void addCommandResult(CommandExecutionResult result) {
        this.resultList.add(result);
    }

    public List<CommandExecutionResult> getResultList() {
        ArrayList<CommandExecutionResult> results = new ArrayList<CommandExecutionResult>();
        results.addAll(this.resultList);
        return this.resultList;
    }

    public boolean isSuccessful() {
        boolean isSuccess = false;
        if (this.resultList != null && !this.resultList.isEmpty()) {
            for (CommandExecutionResult commandResult : this.resultList) {
                if (commandResult.getStatus() == ExecutionStatus.FAILURE) {
                    isSuccess = false;
                    break;
                }
                isSuccess = true;
            }
        }
        return isSuccess;
    }

    public class CommandExecutionResult {
        private ExecutionStatus status;
        private String message;
        private String errorMessage;
        private String command;

        public CommandExecutionResult(ExecutionStatus status, String message, String errorMessage, String command) {
            this.status = status;
            this.message = message;
            this.errorMessage = errorMessage;
            this.command = command;
        }

        public ExecutionStatus getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getCommand() {
            return this.command;
        }
    }

    public static enum ExecutionStatus {
        SUCCESS,
        FAILURE,
        WARNING;

    }
}

