/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.driver.sdb;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.SDBProductDriver;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.SystemInstBuilder;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.db_crs.ShardGroup;
import dbmodel.db_crs.ShardProperty;
import dbmodel.db_crs.ShardSpace;
import dbmodel.db_crs.ShardedDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class ShardSpaceSystemInstBuilder
extends SDBProductDriver
implements SystemInstBuilder {
    public ShardSpaceSystemInstBuilder(List<ShardProperty> shardPropertyList, SystemInstance ti) {
        this.shardPropertyList = shardPropertyList;
        this.ti = ti;
    }

    @Override
    public SystemInstance createSystemInstance() {
        ShardedDatabase sdb = (ShardedDatabase)this.ti.getTop();
        ArrayList<ShardSpace> shardSpaceList = null;
        this.logger.finest("Started building ShardSpaces");
        String shardSpaceName = "";
        if (this.shardPropertyList != null) {
            if (!sdb.getShardingType().equalsIgnoreCase("user-defined")) {
                ListIterator shardGrpItr = this.ti.getTargetsOfType(ShardGroup.class).listIterator();
                while (shardGrpItr.hasNext()) {
                    ShardGroup shdGrp = (ShardGroup)shardGrpItr.next();
                    shardSpaceName = shdGrp.getShardSpaceName();
                    this.logger.fine("shardGroupName : " + shdGrp.getShardGroupName());
                    this.logger.fine("shardSpaceName : " + shardSpaceName);
                    boolean isPresent = false;
                    if (StringUtil.isNullOrEmpty((String)shardSpaceName)) continue;
                    if (shardSpaceList == null) {
                        shardSpaceList = new ArrayList<ShardSpace>();
                        ShardSpace shdSpc = this.createNewShardSpcObj(shardSpaceName, shdGrp);
                        sdb.getShardSpaces().add(shdSpc);
                        shardSpaceList.add(shdSpc);
                    } else {
                        ShardSpace shdSpc;
                        ListIterator shdSpcItr = shardSpaceList.listIterator();
                        this.logger.fine("shardSpaceList size : " + shardSpaceList.size());
                        while (shdSpcItr.hasNext()) {
                            shdSpc = (ShardSpace)shdSpcItr.next();
                            if (shdSpc == null || !shdSpc.getShardSpaceName().equalsIgnoreCase(shardSpaceName)) continue;
                            this.logger.fine("Shard Space Name : " + shdSpc.getShardSpaceName());
                            shdSpc.getShardGroups().add(shdGrp);
                            shdSpc.getDatabases().addAll(shdGrp.getDatabases());
                            isPresent = true;
                        }
                        if (!isPresent) {
                            shdSpc = this.createNewShardSpcObj(shardSpaceName, shdGrp);
                            sdb.getShardSpaces().add(shdSpc);
                            shardSpaceList.add(shdSpc);
                        }
                    }
                    this.logger.fine("shardSpaceList size final: " + shardSpaceList.size());
                }
            } else {
                ArrayList databases = new ArrayList();
                databases.addAll(this.ti.getTargetsOfType(SIDatabase.class));
                databases.addAll(this.ti.getTargetsOfType(RACDatabase.class));
                ListIterator shardItr = databases.listIterator();
                while (shardItr.hasNext()) {
                    AbstractBaseTarget shard = (AbstractBaseTarget)shardItr.next();
                    boolean isPresent = false;
                    shardSpaceName = "";
                    if (shard instanceof RACDatabase) {
                        RACDatabase racDB = (RACDatabase)shard;
                        shardSpaceName = racDB.getShardProperty().getShardSpaceName();
                    } else if (shard instanceof SIDatabase) {
                        SIDatabase siDB = (SIDatabase)shard;
                        shardSpaceName = siDB.getShardProperty().getShardSpaceName();
                    }
                    this.logger.fine("shardSpaceName : " + shardSpaceName);
                    if (StringUtil.isNullOrEmpty((String)shardSpaceName)) continue;
                    if (shardSpaceList == null) {
                        shardSpaceList = new ArrayList();
                        ShardSpace shdSpc = this.createNewShardSpcObj(shardSpaceName, shard);
                        shardSpaceList.add(shdSpc);
                    } else {
                        ShardSpace shdSpc;
                        ListIterator shdSpcItr = shardSpaceList.listIterator();
                        this.logger.fine("shardSpaceList size : " + shardSpaceList.size());
                        while (shdSpcItr.hasNext()) {
                            shdSpc = (ShardSpace)shdSpcItr.next();
                            if (shdSpc == null) continue;
                            this.logger.fine("shard Space Name : " + shdSpc.getShardSpaceName());
                            if (shdSpc.getShardSpaceName() == null || !shdSpc.getShardSpaceName().equalsIgnoreCase(shardSpaceName)) continue;
                            shdSpc.getDatabases().add(shard);
                            isPresent = true;
                        }
                        if (!isPresent) {
                            shdSpc = this.createNewShardSpcObj(shardSpaceName, shard);
                            shardSpaceList.add(shdSpc);
                        }
                    }
                    this.logger.fine("shardSpaceList size final: " + shardSpaceList.size());
                }
            }
        }
        sdb.setShardSpaces(shardSpaceList);
        this.logger.finest("Completed building ShardSpaces.");
        return this.ti;
    }

    private ShardSpace createNewShardSpcObj(String shardSpaceName, ShardGroup shdGrp) {
        this.logger.finest("Creating new shardspace object for shardspace : " + shardSpaceName);
        ShardSpace shdSpc = new ShardSpace();
        ArrayList shdGrpList = new ArrayList();
        shdSpc.setShardGroups(shdGrpList);
        shdSpc.setShardSpaceName(shardSpaceName);
        shdSpc.getShardGroups().add(shdGrp);
        shdSpc.setDatabases(new ArrayList());
        shdSpc.getDatabases().addAll(shdGrp.getDatabases());
        this.ti.getEntities().add(shdSpc);
        return shdSpc;
    }

    private ShardSpace createNewShardSpcObj(String shardSpaceName, AbstractBaseTarget shard) {
        this.logger.finest("Creating new shardspace object for shardspace : " + shardSpaceName + "for shard : " + shard.getName());
        ShardSpace shdSpc = new ShardSpace();
        shdSpc.setDatabases(new ArrayList());
        shdSpc.setShardSpaceName(shardSpaceName);
        shdSpc.getDatabases().add(shard);
        this.ti.getEntities().add(shdSpc);
        return shdSpc;
    }
}

