/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.driver.dataguard;

import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.DataGuard;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.db_crs.ShardSpace;
import java.util.ArrayList;
import java.util.List;
import oracle.dbsysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriver;

public class DataGuardDriver
extends ProductDriver {
    public SystemInstance addDataGuardInstances(List<AbstractBaseTarget> shardList, SystemInstance sdbInstance) {
        SystemInstance updatedSysInstance = sdbInstance;
        if (shardList != null) {
            for (AbstractBaseTarget abt : shardList) {
                boolean isPrimary = false;
                String shardSpaceName = "";
                int drsetNumber = -1;
                if (abt instanceof RACDatabase) {
                    RACDatabase racDB = (RACDatabase)abt;
                    isPrimary = racDB.getPrimary();
                    shardSpaceName = racDB.getShardProperty().getShardSpaceName();
                    drsetNumber = racDB.getShardProperty().getDrsetNumber();
                } else if (abt instanceof SIDatabase) {
                    SIDatabase siDatabase = (SIDatabase)abt;
                    isPrimary = siDatabase.getPrimary();
                    shardSpaceName = siDatabase.getShardProperty().getShardSpaceName();
                    drsetNumber = siDatabase.getShardProperty().getDrsetNumber();
                }
                if (!isPrimary) continue;
                DataGuard dgInst = new DataGuard();
                dgInst.setPrimary(abt);
                List<AbstractBaseTarget> standByDBs = this.findStandByDBs(drsetNumber, shardList);
                dgInst.setStandbyDatabases(standByDBs);
                updatedSysInstance.getEntities().add(dgInst);
                for (BaseClass base : updatedSysInstance.getEntities()) {
                    ShardSpace shSpace;
                    if (!(base instanceof ShardSpace) || !(shSpace = (ShardSpace)base).getShardSpaceName().equalsIgnoreCase(shardSpaceName)) continue;
                    if (null == shSpace.getDataGuards()) {
                        shSpace.setDataGuards(new ArrayList());
                    }
                    shSpace.getDataGuards().add(dgInst);
                }
            }
        }
        return updatedSysInstance;
    }

    private List<AbstractBaseTarget> findStandByDBs(int primaryDrset, List<AbstractBaseTarget> shardList) {
        ArrayList<AbstractBaseTarget> standByDBs = new ArrayList<AbstractBaseTarget>();
        if (shardList != null) {
            for (AbstractBaseTarget abt : shardList) {
                boolean isStandby = false;
                int drsetNumber = -1;
                if (abt instanceof RACDatabase) {
                    RACDatabase racDB = (RACDatabase)abt;
                    isStandby = racDB.getStandby();
                    drsetNumber = racDB.getShardProperty().getDrsetNumber();
                } else if (abt instanceof SIDatabase) {
                    SIDatabase database = (SIDatabase)abt;
                    isStandby = database.getStandby();
                    drsetNumber = database.getShardProperty().getDrsetNumber();
                }
                if (!isStandby || drsetNumber != primaryDrset) continue;
                standByDBs.add(abt);
            }
        }
        return standByDBs;
    }

    public SystemInstance buildSystemInstance() {
        return null;
    }

    public LocalInfo getLocalInfo() {
        return null;
    }
}

